/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.Properties;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcThinStreamingResetStreamTest
extends GridCommonAbstractTest {
    private static final String URL = "jdbc:ignite:thin://127.0.0.1/";
    private Connection conn;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(3);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.conn = DriverManager.getConnection(URL, new Properties());
        this.conn.prepareStatement("CREATE TABLE test(id LONG PRIMARY KEY, val0 VARCHAR, val1 VARCHAR) WITH \"template=replicated\"").execute();
    }

    protected void afterTest() throws Exception {
        try {
            this.conn.prepareStatement("SET STREAMING OFF").execute();
            this.conn.prepareStatement("DROP TABLE test").execute();
        }
        finally {
            U.close((AutoCloseable)this.conn, (IgniteLogger)log);
        }
        super.afterTest();
    }

    @Test
    public void testOrdered() throws Exception {
        this.checkStreamReset(true);
    }

    @Test
    public void testNotOrdered() throws Exception {
        this.checkStreamReset(false);
    }

    @Test
    public void testOrderedResetWorkerCreationRace() throws Exception {
        long BATCH_SIZE = 2L;
        long ITERATIONS = 1000L;
        int iter = 0;
        while ((long)iter < 1000L) {
            this.conn.prepareStatement("SET STREAMING ON BATCH_SIZE 2 ORDERED").execute();
            String sql = "INSERT INTO test (id, val0, val1) VALUES (?, ?, ?)";
            PreparedStatement ps = this.conn.prepareStatement(sql);
            ps.setInt(1, (int)Math.round(Math.random()));
            ps.setString(2, String.valueOf(Math.random()));
            ps.setString(3, String.valueOf(Math.random()));
            ps.execute();
            ++iter;
        }
    }

    public void checkStreamReset(boolean ordered) throws Exception {
        long BATCH_SIZE = 4096L;
        long ROWS = 8193L;
        long ITERATIONS = 100L;
        int iter = 0;
        while ((long)iter < 100L) {
            this.conn.prepareStatement("SET STREAMING ON FLUSH_FREQUENCY 1000 BATCH_SIZE 4096" + (ordered ? " ORDERED" : "")).execute();
            String sql = "INSERT INTO test (id, val0, val1) VALUES (?, ?, ?)";
            PreparedStatement ps = this.conn.prepareStatement(sql);
            int i = 0;
            while ((long)i < 8193L) {
                ps.setInt(1, i);
                ps.setString(2, String.valueOf(Math.random()));
                ps.setString(3, String.valueOf(Math.random()));
                ps.execute();
                ++i;
            }
            this.conn.prepareStatement("SET STREAMING OFF").execute();
            ++iter;
        }
    }
}

