/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class JdbcThinMissingLongArrayResultsTest
extends JdbcThinAbstractSelfTest {
    private static final String CACHE_NAME = "test";
    private static final String URL = "jdbc:ignite:thin://127.0.0.1";
    private static final int GRID_CNT = 2;
    private static final Random RAND = new Random(123L);
    private static final int SAMPLE_SIZE = 1000000;
    private static final int BLOCK_SIZE = 5000;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration(CACHE_NAME)});
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String name) throws Exception {
        CacheConfiguration cfg = JdbcThinMissingLongArrayResultsTest.defaultCacheConfiguration();
        cfg.setIndexedTypes(new Class[]{Key.class, Value.class});
        cfg.setName(name);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(2);
        IgniteEx ignite = this.ignite(0);
        try (IgniteDataStreamer streamer = ignite.dataStreamer(CACHE_NAME);){
            streamer.allowOverwrite(true);
            streamer.perNodeBufferSize(50);
            streamer.autoFlushFrequency(TimeUnit.SECONDS.toMillis(45L));
            streamer.skipStore(false);
            streamer.keepBinary(true);
            int secId = 0;
            int maxBlocks = 200;
            Key key = new Key();
            Value value = new Value();
            long date = System.nanoTime();
            for (int blockId = 0; blockId < 200; ++blockId) {
                long[] time = new long[5000];
                double[] open = new double[5000];
                double[] close = new double[5000];
                double[] high = new double[5000];
                double[] low = new double[5000];
                double[] marketVWAP = new double[5000];
                for (int i = 0; i < 5000; ++i) {
                    time[i] = System.nanoTime();
                    open[i] = Math.abs(RAND.nextGaussian());
                    close[i] = Math.abs(RAND.nextGaussian());
                    high[i] = Math.max(open[i], Math.abs(RAND.nextGaussian()));
                    low[i] = Math.min(open[i], Math.abs(RAND.nextGaussian()));
                    marketVWAP[i] = Math.abs(RAND.nextGaussian());
                }
                key.setDate(date);
                key.setSecurityId(secId);
                value.setTime(time);
                value.setOpen(open);
                value.setHigh(high);
                value.setLow(low);
                value.setClose(close);
                value.setMarketVWAP(marketVWAP);
                streamer.addData((Object)key, (Object)value);
                ++secId;
                if (blockId % 100 != 0) continue;
                System.out.println("+++ Processed " + blockId * 5000 + " events so far " + new Date());
            }
            streamer.flush();
        }
        ignite.active(true);
    }

    @Test
    public void testDefaults() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            conn.setSchema("\"test\"");
            try (PreparedStatement st = conn.prepareStatement("SELECT * FROM VALUE");){
                ResultSet rs = st.executeQuery();
                int cols = rs.getMetaData().getColumnCount();
                while (rs.next()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(rs.getObject(1).toString());
                    for (int i = 1; i < cols; ++i) {
                        sb.append(", ").append(rs.getObject(i + 1).toString());
                    }
                    System.out.println(sb.toString());
                }
            }
        }
    }

    public static class Value
    implements Serializable {
        @QuerySqlField
        private long[] time;
        @QuerySqlField
        private double[] open;
        @QuerySqlField
        private double[] high;
        @QuerySqlField
        private double[] low;
        @QuerySqlField
        private double[] close;
        @QuerySqlField
        private double[] marketVWAP;

        public double[] getClose() {
            return this.close;
        }

        public long[] getTime() {
            return this.time;
        }

        public void setTime(long[] time) {
            this.time = time;
        }

        public void setOpen(double[] open) {
            this.open = open;
        }

        public void setHigh(double[] high) {
            this.high = high;
        }

        public void setLow(double[] low) {
            this.low = low;
        }

        public void setClose(double[] close) {
            this.close = close;
        }

        public void setMarketVWAP(double[] marketVWAP) {
            this.marketVWAP = marketVWAP;
        }

        public String toString() {
            return "OHLC{, time=" + Arrays.toString(this.time) + ", open=" + Arrays.toString(this.open) + ", high=" + Arrays.toString(this.high) + ", low=" + Arrays.toString(this.low) + ", close=" + Arrays.toString(this.close) + ", marketVWAP=" + Arrays.toString(this.marketVWAP) + '}';
        }
    }

    public static class Key
    implements Serializable {
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="date_sec_idx", order=0, descending=true)})
        private long date;
        @QuerySqlField(index=true, orderedGroups={@QuerySqlField.Group(name="date_sec_idx", order=3)})
        private int securityId;

        public long getDate() {
            return this.date;
        }

        public void setSecurityId(int securityId) {
            this.securityId = securityId;
        }

        public void setDate(long date) {
            this.date = date;
        }
    }
}

