/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractDmlStatementSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class JdbcThinBatchSelfTest
extends JdbcThinAbstractDmlStatementSelfTest {
    private static final String SQL_PREPARED = "insert into Person(_key, id, firstName, lastName, age) values (?, ?, ?, ?, ?)";
    private Statement stmt;
    private PreparedStatement pstmt;

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stmt = this.conn.createStatement();
        this.pstmt = this.conn.prepareStatement(SQL_PREPARED);
        JdbcThinBatchSelfTest.assertNotNull((Object)this.stmt);
        JdbcThinBatchSelfTest.assertFalse((boolean)this.stmt.isClosed());
        JdbcThinBatchSelfTest.assertNotNull((Object)this.pstmt);
        JdbcThinBatchSelfTest.assertFalse((boolean)this.pstmt.isClosed());
    }

    @Override
    protected void afterTest() throws Exception {
        if (this.stmt != null && !this.stmt.isClosed()) {
            this.stmt.close();
        }
        if (this.pstmt != null && !this.pstmt.isClosed()) {
            this.pstmt.close();
        }
        JdbcThinBatchSelfTest.assertTrue((boolean)this.pstmt.isClosed());
        JdbcThinBatchSelfTest.assertTrue((boolean)this.stmt.isClosed());
        super.afterTest();
    }

    @Test
    public void testBatch() throws SQLException {
        int BATCH_SIZE = 10;
        int idx = 0;
        int i = 0;
        while (i < 10) {
            this.stmt.addBatch("insert into Person (_key, id, firstName, lastName, age) values " + this.generateValues(idx, i + 1));
            idx += ++i;
        }
        int[] updCnts = this.stmt.executeBatch();
        JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)10, (int)updCnts.length);
        for (i = 0; i < 10; ++i) {
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid update count", (int)(i + 1), (int)updCnts[i]);
        }
    }

    @Test
    public void testBatchOnClosedStatement() throws SQLException {
        final Statement stmt2 = this.conn.createStatement();
        final PreparedStatement pstmt2 = this.conn.prepareStatement("");
        stmt2.close();
        pstmt2.close();
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                stmt2.addBatch("");
                return null;
            }
        }, SQLException.class, (String)"Statement is closed.");
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                stmt2.clearBatch();
                return null;
            }
        }, SQLException.class, (String)"Statement is closed.");
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                stmt2.executeBatch();
                return null;
            }
        }, SQLException.class, (String)"Statement is closed.");
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                pstmt2.addBatch();
                return null;
            }
        }, SQLException.class, (String)"Statement is closed.");
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                pstmt2.clearBatch();
                return null;
            }
        }, SQLException.class, (String)"Statement is closed.");
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                pstmt2.executeBatch();
                return null;
            }
        }, SQLException.class, (String)"Statement is closed.");
    }

    @Test
    public void testBatchException() throws Exception {
        int BATCH_SIZE = 7;
        int FAILED_IDX = 5;
        int idx = 0;
        int i = 0;
        while (i < 5) {
            this.stmt.addBatch("insert into Person (_key, id, firstName, lastName, age) values " + this.generateValues(idx, i + 1));
            idx += ++i;
        }
        this.stmt.addBatch("select * from Person");
        this.stmt.addBatch("insert into Person (_key, id, firstName, lastName, age) values " + this.generateValues(100, 7));
        try {
            this.stmt.executeBatch();
            JdbcThinBatchSelfTest.fail((String)"BatchUpdateException must be thrown");
        }
        catch (BatchUpdateException e) {
            this.checkThereAreNotUsedConnections();
            int[] updCnts = e.getUpdateCounts();
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)7, (int)updCnts.length);
            for (int i2 = 0; i2 < 7; ++i2) {
                JdbcThinBatchSelfTest.assertEquals((String)"Invalid update count", (int)(i2 != 5 ? i2 + 1 : -3), (int)updCnts[i2]);
            }
            if (!e.getMessage().contains("Given statement type does not match that declared by JDBC driver")) {
                log.error("Invalid exception: ", (Throwable)e);
                JdbcThinBatchSelfTest.fail();
            }
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid SQL state.", (String)"42000", (String)e.getSQLState());
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid error code.", (int)3003, (int)e.getErrorCode());
        }
    }

    @Test
    public void testBatchParseException() throws Exception {
        int BATCH_SIZE = 7;
        int FAILED_IDX = 5;
        int idx = 0;
        int i = 0;
        while (i < 5) {
            this.stmt.addBatch("insert into Person (_key, id, firstName, lastName, age) values " + this.generateValues(idx, i + 1));
            idx += ++i;
        }
        this.stmt.addBatch("insert into Person (_key, id, firstName, lastName, age) values (4444, 'fail', 1, 1, 1)");
        this.stmt.addBatch("insert into Person (_key, id, firstName, lastName, age) values " + this.generateValues(100, 7));
        try {
            this.stmt.executeBatch();
            JdbcThinBatchSelfTest.fail((String)"BatchUpdateException must be thrown");
        }
        catch (BatchUpdateException e) {
            this.checkThereAreNotUsedConnections();
            int[] updCnts = e.getUpdateCounts();
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)7, (int)updCnts.length);
            for (int i2 = 0; i2 < 7; ++i2) {
                JdbcThinBatchSelfTest.assertEquals((String)("Invalid update count: " + i2), (int)(i2 != 5 ? i2 + 1 : -3), (int)updCnts[i2]);
            }
            if (!e.getMessage().contains("Value conversion failed")) {
                log.error("Invalid exception: ", (Throwable)e);
                JdbcThinBatchSelfTest.fail();
            }
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid SQL state.", (String)"0700B", (String)e.getSQLState());
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid error code.", (int)3013, (int)e.getErrorCode());
        }
    }

    @Test
    public void testBatchMerge() throws SQLException {
        int BATCH_SIZE = 7;
        int idx = 0;
        int i = 0;
        while (i < 7) {
            this.stmt.addBatch("merge into Person (_key, id, firstName, lastName, age) values " + this.generateValues(idx, i + 1));
            idx += ++i;
        }
        int[] updCnts = this.stmt.executeBatch();
        JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)7, (int)updCnts.length);
        for (i = 0; i < 7; ++i) {
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid update count", (int)(i + 1), (int)updCnts[i]);
        }
    }

    @Test
    public void testBatchMergeParseException() throws Exception {
        int BATCH_SIZE = 7;
        int FAILED_IDX = 5;
        int idx = 0;
        int i = 0;
        while (i < 5) {
            this.stmt.addBatch("merge into Person (_key, id, firstName, lastName, age) values " + this.generateValues(idx, i + 1));
            idx += ++i;
        }
        this.stmt.addBatch("merge into Person (_key, id, firstName, lastName, age) values (4444, 'FAIL', 1, 1, 1)");
        this.stmt.addBatch("merge into Person (_key, id, firstName, lastName, age) values " + this.generateValues(100, 7));
        try {
            this.stmt.executeBatch();
            JdbcThinBatchSelfTest.fail((String)"BatchUpdateException must be thrown");
        }
        catch (BatchUpdateException e) {
            this.checkThereAreNotUsedConnections();
            int[] updCnts = e.getUpdateCounts();
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)7, (int)updCnts.length);
            for (int i2 = 0; i2 < 7; ++i2) {
                JdbcThinBatchSelfTest.assertEquals((String)("Invalid update count: " + i2), (int)(i2 != 5 ? i2 + 1 : -3), (int)updCnts[i2]);
            }
            if (!e.getMessage().contains("Value conversion failed")) {
                log.error("Invalid exception: ", (Throwable)e);
                JdbcThinBatchSelfTest.fail();
            }
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid SQL state.", (String)"0700B", (String)e.getSQLState());
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid error code.", (int)3013, (int)e.getErrorCode());
        }
    }

    @Test
    public void testBatchKeyDuplicatesException() throws Exception {
        int BATCH_SIZE = 7;
        int FAILED_IDX = 5;
        int idx = 0;
        int i = 0;
        while (i < 5) {
            this.stmt.addBatch("insert into Person (_key, id, firstName, lastName, age) values " + this.generateValues(idx, i + 1));
            idx += ++i;
        }
        this.stmt.addBatch("insert into Person (_key, id, firstName, lastName, age) values ('p0', 0, 'Name0', 'Lastname0', 20)");
        this.stmt.addBatch("insert into Person (_key, id, firstName, lastName, age) values " + this.generateValues(++idx, 7));
        try {
            this.stmt.executeBatch();
            JdbcThinBatchSelfTest.fail((String)"BatchUpdateException must be thrown");
        }
        catch (BatchUpdateException e) {
            this.checkThereAreNotUsedConnections();
            int[] updCnts = e.getUpdateCounts();
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)7, (int)updCnts.length);
            for (int i2 = 0; i2 < 7; ++i2) {
                JdbcThinBatchSelfTest.assertEquals((String)("Invalid update count: " + i2), (int)(i2 != 5 ? i2 + 1 : -3), (int)updCnts[i2]);
            }
            if (!e.getMessage().contains("Failed to INSERT some keys because they are already in cache [keys=[p0]")) {
                log.error("Invalid exception: ", (Throwable)e);
                JdbcThinBatchSelfTest.fail();
            }
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid SQL state.", (String)"23000", (String)e.getSQLState());
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid error code.", (int)4001, (int)e.getErrorCode());
        }
    }

    @Test
    public void testHeterogeneousBatch() throws SQLException {
        this.stmt.addBatch("insert into Person (_key, id, firstName, lastName, age) values ('p0', 0, 'Name0', 'Lastname0', 10)");
        this.stmt.addBatch("insert into Person (_key, id, firstName, lastName, age) values ('p1', 1, 'Name1', 'Lastname1', 20), ('p2', 2, 'Name2', 'Lastname2', 30)");
        this.stmt.addBatch("merge into Person (_key, id, firstName, lastName, age) values ('p3', 3, 'Name3', 'Lastname3', 40)");
        this.stmt.addBatch("update Person set id = 5 where age >= 30");
        this.stmt.addBatch("merge into Person (_key, id, firstName, lastName, age) values ('p0', 2, 'Name2', 'Lastname2', 50)");
        this.stmt.addBatch("delete from Person where age <= 40");
        int[] updCnts = this.stmt.executeBatch();
        JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)6, (int)updCnts.length);
        Assert.assertArrayEquals((String)"Invalid update count", (int[])new int[]{1, 2, 1, 2, 1, 3}, (int[])updCnts);
    }

    @Test
    public void testHeterogeneousBatchException() throws Exception {
        this.stmt.addBatch("insert into Person (_key, id, firstName, lastName, age) values ('p0', 0, 'Name0', 'Lastname0', 10)");
        this.stmt.addBatch("insert into Person (_key, id, firstName, lastName, age) values ('p1', 1, 'Name1', 'Lastname1', 20), ('p2', 2, 'Name2', 'Lastname2', 30)");
        this.stmt.addBatch("merge into Person (_key, id, firstName, lastName, age) values ('p3', 3, 'Name3', 'Lastname3', 40)");
        this.stmt.addBatch("update Person set id = 'FAIL' where age >= 30");
        this.stmt.addBatch("merge into Person (_key, id, firstName, lastName, age) values ('p0', 2, 'Name2', 'Lastname2', 50)");
        this.stmt.addBatch("delete from Person where FAIL <= 40");
        try {
            this.stmt.executeBatch();
            JdbcThinBatchSelfTest.fail((String)"BatchUpdateException must be thrown");
        }
        catch (BatchUpdateException e) {
            this.checkThereAreNotUsedConnections();
            int[] updCnts = e.getUpdateCounts();
            if (!e.getMessage().contains("Value conversion failed")) {
                log.error("Invalid exception: ", (Throwable)e);
                JdbcThinBatchSelfTest.fail();
            }
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)6, (int)updCnts.length);
            Assert.assertArrayEquals((String)"Invalid update count", (int[])new int[]{1, 2, 1, -3, 1, -3}, (int[])updCnts);
        }
    }

    @Test
    public void testBatchClear() throws SQLException {
        int BATCH_SIZE = 7;
        int idx = 0;
        int i = 0;
        while (i < 7) {
            this.stmt.addBatch("insert into Person (_key, id, firstName, lastName, age) values " + this.generateValues(idx, i + 1));
            idx += ++i;
        }
        this.stmt.clearBatch();
        int[] updates = this.stmt.executeBatch();
        JdbcThinBatchSelfTest.assertEquals((String)"Returned update counts array should have no elements for empty batch.", (int)0, (int)updates.length);
    }

    @Test
    public void testEmptyBatchStreaming() throws SQLException {
        JdbcThinBatchSelfTest.executeUpdateOn(this.conn, "SET STREAMING ON");
        int[] updates = this.stmt.executeBatch();
        JdbcThinBatchSelfTest.assertEquals((String)"Returned update counts array should have no elements for empty batch.", (int)0, (int)updates.length);
        JdbcThinBatchSelfTest.executeUpdateOn(this.conn, "SET STREAMING OFF");
        JdbcThinBatchSelfTest.assertEquals((String)"Test table should be empty after empty batch is performed.", (long)0L, (long)this.personsCount());
    }

    @Test
    public void testEmptyBatchStreamingPrepared() throws SQLException {
        try (Statement statement = this.conn.createStatement();){
            statement.executeUpdate("SET STREAMING ON");
        }
        int[] updates = this.pstmt.executeBatch();
        JdbcThinBatchSelfTest.assertEquals((String)"Returned update counts array should have no elements for empty batch.", (int)0, (int)updates.length);
        try (Statement statement = this.conn.createStatement();){
            statement.executeUpdate("SET STREAMING OFF");
        }
        JdbcThinBatchSelfTest.assertEquals((String)"Test table should be empty after empty batch is performed.", (long)0L, (long)this.personsCount());
    }

    @Test
    public void testBatchPrepared() throws SQLException {
        int BATCH_SIZE = 10;
        for (int i = 0; i < 10; ++i) {
            int paramCnt = 1;
            this.pstmt.setString(paramCnt++, "p" + i);
            this.pstmt.setInt(paramCnt++, i);
            this.pstmt.setString(paramCnt++, "Name" + i);
            this.pstmt.setString(paramCnt++, "Lastname" + i);
            this.pstmt.setInt(paramCnt++, 20 + i);
            this.pstmt.addBatch();
        }
        int[] updCnts = this.pstmt.executeBatch();
        JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)10, (int)updCnts.length);
        for (int i = 0; i < 10; ++i) {
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid update count", (int)1, (int)updCnts[i]);
        }
    }

    @Test
    public void testBatchExceptionPrepared() throws Exception {
        int BATCH_SIZE = 7;
        int FAILED_IDX = 5;
        for (int i = 0; i < 5; ++i) {
            int paramCnt = 1;
            this.pstmt.setString(paramCnt++, "p" + i);
            this.pstmt.setInt(paramCnt++, i);
            this.pstmt.setString(paramCnt++, "Name" + i);
            this.pstmt.setString(paramCnt++, "Lastname" + i);
            this.pstmt.setInt(paramCnt++, 20 + i);
            this.pstmt.addBatch();
        }
        int paramCnt = 1;
        this.pstmt.setString(paramCnt++, "p5");
        this.pstmt.setString(paramCnt++, "FAIL");
        this.pstmt.setString(paramCnt++, "Name5");
        this.pstmt.setString(paramCnt++, "Lastname5");
        this.pstmt.setInt(paramCnt++, 25);
        this.pstmt.addBatch();
        paramCnt = 1;
        this.pstmt.setString(paramCnt++, "p51");
        this.pstmt.setInt(paramCnt++, 6);
        this.pstmt.setString(paramCnt++, "Name51");
        this.pstmt.setString(paramCnt++, "Lastname51");
        this.pstmt.setInt(paramCnt++, 26);
        this.pstmt.addBatch();
        try {
            this.pstmt.executeBatch();
            JdbcThinBatchSelfTest.fail((String)"BatchUpdateException must be thrown");
        }
        catch (BatchUpdateException e) {
            this.checkThereAreNotUsedConnections();
            int[] updCnts = e.getUpdateCounts();
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)7, (int)updCnts.length);
            for (int i = 0; i < 7; ++i) {
                JdbcThinBatchSelfTest.assertEquals((String)"Invalid update count", (int)(i != 5 ? 1 : -3), (int)updCnts[i]);
            }
            if (!e.getMessage().contains("Value conversion failed")) {
                log.error("Invalid exception: ", (Throwable)e);
                JdbcThinBatchSelfTest.fail();
            }
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid SQL state.", (String)"0700B", (String)e.getSQLState());
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid error code.", (int)3013, (int)e.getErrorCode());
        }
    }

    @Test
    public void testBatchMergePrepared() throws SQLException {
        int BATCH_SIZE = 10;
        this.pstmt = this.conn.prepareStatement("merge into Person(_key, id, firstName, lastName, age) values (?, ?, ?, ?, ?)");
        for (int i = 0; i < 10; ++i) {
            int paramCnt = 1;
            this.pstmt.setString(paramCnt++, "p" + i);
            this.pstmt.setInt(paramCnt++, i);
            this.pstmt.setString(paramCnt++, "Name" + i);
            this.pstmt.setString(paramCnt++, "Lastname" + i);
            this.pstmt.setInt(paramCnt++, 20 + i);
            this.pstmt.addBatch();
        }
        int[] updCnts = this.pstmt.executeBatch();
        JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)10, (int)updCnts.length);
        for (int i = 0; i < 10; ++i) {
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid update count", (int)1, (int)updCnts[i]);
        }
    }

    @Test
    public void testBatchMergeExceptionPrepared() throws Exception {
        int BATCH_SIZE = 7;
        int FAILED_IDX = 5;
        this.pstmt = this.conn.prepareStatement("merge into Person(_key, id, firstName, lastName, age) values (?, ?, ?, ?, ?)");
        for (int i = 0; i < 5; ++i) {
            int paramCnt = 1;
            this.pstmt.setString(paramCnt++, "p" + i);
            this.pstmt.setInt(paramCnt++, i);
            this.pstmt.setString(paramCnt++, "Name" + i);
            this.pstmt.setString(paramCnt++, "Lastname" + i);
            this.pstmt.setInt(paramCnt++, 20 + i);
            this.pstmt.addBatch();
        }
        int paramCnt = 1;
        this.pstmt.setString(paramCnt++, "p5");
        this.pstmt.setString(paramCnt++, "FAIL");
        this.pstmt.setString(paramCnt++, "Name5");
        this.pstmt.setString(paramCnt++, "Lastname5");
        this.pstmt.setInt(paramCnt++, 25);
        this.pstmt.addBatch();
        paramCnt = 1;
        this.pstmt.setString(paramCnt++, "p51");
        this.pstmt.setInt(paramCnt++, 6);
        this.pstmt.setString(paramCnt++, "Name51");
        this.pstmt.setString(paramCnt++, "Lastname51");
        this.pstmt.setInt(paramCnt++, 26);
        this.pstmt.addBatch();
        try {
            int[] res = this.pstmt.executeBatch();
            JdbcThinBatchSelfTest.fail((String)("BatchUpdateException must be thrown res=" + Arrays.toString(res)));
        }
        catch (BatchUpdateException e) {
            this.checkThereAreNotUsedConnections();
            int[] updCnts = e.getUpdateCounts();
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)7, (int)updCnts.length);
            for (int i = 0; i < 7; ++i) {
                JdbcThinBatchSelfTest.assertEquals((String)"Invalid update count", (int)(i != 5 ? 1 : -3), (int)updCnts[i]);
            }
            if (!e.getMessage().contains("Value conversion failed")) {
                log.error("Invalid exception: ", (Throwable)e);
                JdbcThinBatchSelfTest.fail();
            }
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid SQL state.", (String)"0700B", (String)e.getSQLState());
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid error code.", (int)3013, (int)e.getErrorCode());
        }
    }

    private void populateTable(int size) throws SQLException {
        this.stmt.addBatch("insert into Person (_key, id, firstName, lastName, age) values " + this.generateValues(0, size));
        this.stmt.executeBatch();
    }

    @Test
    public void testBatchUpdatePrepared() throws SQLException {
        int BATCH_SIZE = 10;
        this.populateTable(10);
        this.pstmt = this.conn.prepareStatement("update Person set age = 100 where id = ?;");
        for (int i = 0; i < 10; ++i) {
            this.pstmt.setInt(1, i);
            this.pstmt.addBatch();
        }
        int[] updCnts = this.pstmt.executeBatch();
        JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)10, (int)updCnts.length);
        for (int i = 0; i < 10; ++i) {
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid update count", (int)1, (int)updCnts[i]);
        }
    }

    @Test
    public void testBatchUpdateExceptionPrepared() throws Exception {
        int BATCH_SIZE = 7;
        int FAILED_IDX = 5;
        this.populateTable(7);
        this.pstmt = this.conn.prepareStatement("update Person set age = 100 where id = ?;");
        for (int i = 0; i < 5; ++i) {
            this.pstmt.setInt(1, i);
            this.pstmt.addBatch();
        }
        this.pstmt.setString(1, "FAIL");
        this.pstmt.addBatch();
        this.pstmt.setInt(1, 6);
        this.pstmt.addBatch();
        try {
            int[] res = this.pstmt.executeBatch();
            JdbcThinBatchSelfTest.fail((String)("BatchUpdateException must be thrown res=" + Arrays.toString(res)));
        }
        catch (BatchUpdateException e) {
            this.checkThereAreNotUsedConnections();
            int[] updCnts = e.getUpdateCounts();
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)7, (int)updCnts.length);
            for (int i = 0; i < 7; ++i) {
                JdbcThinBatchSelfTest.assertEquals((String)("Invalid update count[" + i + ']'), (int)(i != 5 ? 1 : -3), (int)updCnts[i]);
            }
            if (!e.getMessage().contains("Data conversion error converting \"FAIL\"")) {
                log.error("Invalid exception: ", (Throwable)e);
                JdbcThinBatchSelfTest.fail();
            }
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid SQL state.", (String)"50000", (String)e.getSQLState());
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid error code.", (int)1, (int)e.getErrorCode());
        }
    }

    @Test
    public void testBatchDeletePrepared() throws SQLException {
        int BATCH_SIZE = 10;
        this.populateTable(10);
        this.pstmt = this.conn.prepareStatement("delete from Person where id = ?;");
        for (int i = 0; i < 10; ++i) {
            this.pstmt.setInt(1, i);
            this.pstmt.addBatch();
        }
        int[] updCnts = this.pstmt.executeBatch();
        JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)10, (int)updCnts.length);
        for (int i = 0; i < 10; ++i) {
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid update count", (int)1, (int)updCnts[i]);
        }
    }

    @Test
    public void testBatchDeleteExceptionPrepared() throws Exception {
        int BATCH_SIZE = 7;
        int FAILED_IDX = 5;
        this.populateTable(7);
        this.pstmt = this.conn.prepareStatement("delete from Person where id = ?;");
        for (int i = 0; i < 5; ++i) {
            this.pstmt.setInt(1, i);
            this.pstmt.addBatch();
        }
        this.pstmt.setString(1, "FAIL");
        this.pstmt.addBatch();
        this.pstmt.setInt(1, 6);
        this.pstmt.addBatch();
        try {
            int[] res = this.pstmt.executeBatch();
            JdbcThinBatchSelfTest.fail((String)("BatchUpdateException must be thrown res=" + Arrays.toString(res)));
        }
        catch (BatchUpdateException e) {
            this.checkThereAreNotUsedConnections();
            int[] updCnts = e.getUpdateCounts();
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid update counts size", (int)7, (int)updCnts.length);
            for (int i = 0; i < 7; ++i) {
                JdbcThinBatchSelfTest.assertEquals((String)"Invalid update count", (int)(i != 5 ? 1 : -3), (int)updCnts[i]);
            }
            if (!e.getMessage().contains("Data conversion error converting \"FAIL\"")) {
                log.error("Invalid exception: ", (Throwable)e);
                JdbcThinBatchSelfTest.fail();
            }
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid SQL state.", (String)"50000", (String)e.getSQLState());
            JdbcThinBatchSelfTest.assertEquals((String)"Invalid error code.", (int)1, (int)e.getErrorCode());
        }
    }

    @Test
    public void testBatchClearPrepared() throws SQLException {
        int BATCH_SIZE = 10;
        for (int persIdx = 0; persIdx < 10; ++persIdx) {
            JdbcThinBatchSelfTest.fillParamsWithPerson(this.pstmt, persIdx);
            this.pstmt.addBatch();
        }
        this.pstmt.clearBatch();
        int[] updates = this.pstmt.executeBatch();
        JdbcThinBatchSelfTest.assertEquals((String)"Returned update counts array should have no elements for empty batch.", (int)0, (int)updates.length);
        JdbcThinBatchSelfTest.assertEquals((String)"Test table should be empty after empty batch is performed.", (long)0L, (long)this.personsCount());
    }

    private String generateValues(int beginIndex, int cnt) {
        StringBuilder sb = new StringBuilder();
        int lastIdx = beginIndex + cnt - 1;
        for (int i = beginIndex; i < lastIdx; ++i) {
            sb.append(this.valuesRow(i)).append(',');
        }
        sb.append(this.valuesRow(lastIdx));
        return sb.toString();
    }

    private String valuesRow(int idx) {
        return String.format("('p%d', %d, 'Name%d', 'Lastname%d', %d)", idx, idx, idx, idx, 20 + idx);
    }

    private static void fillParamsWithPerson(PreparedStatement stmt, int personIdx) throws SQLException {
        int paramCnt = 1;
        stmt.setString(paramCnt++, "p" + personIdx);
        stmt.setInt(paramCnt++, personIdx);
        stmt.setString(paramCnt++, "Name" + personIdx);
        stmt.setString(paramCnt++, "Lastname" + personIdx);
        stmt.setInt(paramCnt++, 20 + personIdx);
    }

    private long personsCount() throws SQLException {
        try (ResultSet cnt = this.stmt.executeQuery("SELECT COUNT(*) FROM PERSON;");){
            cnt.next();
            long l = cnt.getLong(1);
            return l;
        }
    }

    private static void executeUpdateOn(Connection conn, String updQry) throws SQLException {
        try (Statement statement = conn.createStatement();){
            statement.executeUpdate(updQry);
        }
    }
}

