/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class JdbcThinAutoCloseServerCursorTest
extends JdbcThinAbstractSelfTest {
    private static final String CACHE_NAME = "cache";
    private static final String URL = "jdbc:ignite:thin://127.0.0.1/?autoCloseServerCursor=true";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcThinAutoCloseServerCursorTest.defaultCacheConfiguration();
        cache.setName(CACHE_NAME);
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{Integer.class, Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
    }

    protected void afterTest() throws Exception {
        IgniteCache cache = this.grid(0).cache(CACHE_NAME);
        cache.clear();
    }

    @Test
    public void testQuery() throws Exception {
        Person[] persons;
        IgniteCache cache = this.grid(0).cache(CACHE_NAME);
        for (Person person : persons = new Person[]{new Person(1, "John", 25), new Person(2, "Mary", 23)}) {
            cache.put((Object)person.id, (Object)person);
        }
        try (Connection conn = DriverManager.getConnection(URL);){
            Throwable throwable;
            ResultSet rs;
            conn.setSchema("\"cache\"");
            String sqlText = "select * from Person";
            try (Statement stmt = conn.createStatement();){
                stmt.setFetchSize(2);
                rs = stmt.executeQuery(sqlText);
                throwable = null;
                try {
                    GridTestUtils.assertThrows((IgniteLogger)this.log(), (Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return rs.getMetaData();
                        }
                    }, SQLException.class, (String)"Server cursor is already closed");
                    GridTestUtils.assertThrows((IgniteLogger)this.log(), (Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return rs.findColumn("id");
                        }
                    }, SQLException.class, (String)"Server cursor is already closed");
                    this.checkResultSet(rs, persons);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            stmt = conn.createStatement();
            var7_11 = null;
            try {
                stmt.setFetchSize(1);
                rs = stmt.executeQuery(sqlText);
                throwable = null;
                try {
                    JdbcThinAutoCloseServerCursorTest.assertEquals((int)3, (int)rs.getMetaData().getColumnCount());
                    JdbcThinAutoCloseServerCursorTest.assertEquals((int)1, (int)rs.findColumn("id"));
                    this.checkResultSet(rs, persons);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (Throwable rs2) {
                var7_11 = rs2;
                throw rs2;
            }
            finally {
                if (stmt != null) {
                    if (var7_11 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs2) {
                            var7_11.addSuppressed(rs2);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            stmt = conn.createStatement();
            var7_11 = null;
            try {
                stmt.setFetchSize(1);
                rs = stmt.executeQuery(sqlText);
                throwable = null;
                try {
                    this.checkResultSet(rs, persons);
                    GridTestUtils.assertThrows((IgniteLogger)this.log(), (Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return rs.getMetaData();
                        }
                    }, SQLException.class, (String)"Server cursor is already closed");
                    GridTestUtils.assertThrows((IgniteLogger)this.log(), (Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return rs.findColumn("id");
                        }
                    }, SQLException.class, (String)"Server cursor is already closed");
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (Throwable throwable8) {
                var7_11 = throwable8;
                throw throwable8;
            }
            finally {
                if (stmt != null) {
                    if (var7_11 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable9) {
                            var7_11.addSuppressed(throwable9);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
    }

    @Test
    public void testInsert() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            conn.setSchema("\"cache\"");
            String sqlText = "insert into Person (_key, id, name, age) values (?, ?, ?, ?)";
            Person p = new Person(1, "John", 25);
            try (PreparedStatement prepared = conn.prepareStatement(sqlText);){
                prepared.setInt(1, p.id);
                prepared.setInt(2, p.id);
                prepared.setString(3, p.name);
                prepared.setInt(4, p.age);
                JdbcThinAutoCloseServerCursorTest.assertFalse((boolean)prepared.execute());
                JdbcThinAutoCloseServerCursorTest.assertEquals((int)1, (int)prepared.getUpdateCount());
            }
            IgniteCache cache = this.grid(0).cache(CACHE_NAME);
            JdbcThinAutoCloseServerCursorTest.assertEquals((Object)p, (Object)cache.get((Object)1));
        }
    }

    @Test
    public void testUpdate() throws Exception {
        IgniteCache cache = this.grid(0).cache(CACHE_NAME);
        Person p = new Person(1, "John", 25);
        cache.put((Object)1, (Object)p);
        try (Connection conn = DriverManager.getConnection(URL);){
            conn.setSchema("\"cache\"");
            String sqlText = "update Person set age = age + 1";
            try (Statement stmt = conn.createStatement();){
                JdbcThinAutoCloseServerCursorTest.assertEquals((int)1, (int)stmt.executeUpdate(sqlText));
            }
            JdbcThinAutoCloseServerCursorTest.assertEquals((int)(p.age + 1), (int)((Person)cache.get((Object)1)).age);
        }
    }

    @Test
    public void testDelete() throws Exception {
        IgniteCache cache = this.grid(0).cache(CACHE_NAME);
        Person p = new Person(1, "John", 25);
        cache.put((Object)1, (Object)p);
        try (Connection conn = DriverManager.getConnection(URL);){
            conn.setSchema("\"cache\"");
            String sqlText = "delete Person where age = ?";
            try (PreparedStatement prepared = conn.prepareStatement(sqlText);){
                prepared.setInt(1, p.age);
                JdbcThinAutoCloseServerCursorTest.assertEquals((int)1, (int)prepared.executeUpdate());
            }
            JdbcThinAutoCloseServerCursorTest.assertNull((Object)cache.get((Object)1));
        }
    }

    private void checkResultSet(ResultSet rs, Person[] persons) throws Exception {
        while (rs.next()) {
            Person p = new Person(rs.getInt(1), rs.getString(2), rs.getInt(3));
            assert (p.id > 0 && p.id <= persons.length);
            JdbcThinAutoCloseServerCursorTest.assertEquals((Object)persons[p.id - 1], (Object)p);
        }
    }

    static class Person
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField
        private final String name;
        @QuerySqlField
        private final int age;

        Person(int id, String name, int age) {
            assert (!F.isEmpty((String)name));
            assert (age > 0);
            this.id = id;
            this.name = name;
            this.age = age;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            if (this.id != person.id) {
                return false;
            }
            if (this.name == null ^ person.name == null) {
                return false;
            }
            if (this.name != null && !this.name.equals(person.name)) {
                return false;
            }
            return this.age == person.age;
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + this.age;
            return result;
        }
    }
}

