/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.marshaller.Marshaller;

public abstract class JdbcThinAbstractDmlStatementSelfTest
extends JdbcThinAbstractSelfTest {
    static final String SQL_SELECT = "select _key, id, firstName, lastName, age from Person";
    protected Connection conn;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
    }

    protected void beforeTest() throws Exception {
        this.ignite(0).getOrCreateCache(this.cacheConfig());
        this.conn = this.createConnection();
        this.conn.setSchema("\"default\"");
    }

    protected void afterTest() throws Exception {
        this.grid(0).destroyCache("default");
        this.conn.close();
        JdbcThinAbstractDmlStatementSelfTest.assertTrue((boolean)this.conn.isClosed());
    }

    protected Connection createConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/");
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return this.getConfiguration0(igniteInstanceName);
    }

    private IgniteConfiguration getConfiguration0(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    IgniteConfiguration getBinaryConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = this.getConfiguration0(igniteInstanceName);
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        CacheConfiguration ccfg = cfg.getCacheConfiguration()[0];
        ccfg.getQueryEntities().clear();
        QueryEntity e = new QueryEntity();
        e.setKeyType(String.class.getName());
        e.setValueType("Person");
        e.addQueryField("id", Integer.class.getName(), null);
        e.addQueryField("age", Integer.class.getName(), null);
        e.addQueryField("firstName", String.class.getName(), null);
        e.addQueryField("lastName", String.class.getName(), null);
        ccfg.setQueryEntities(Collections.singletonList(e));
        return cfg;
    }

    private CacheConfiguration nonBinCacheConfig() {
        CacheConfiguration cache = JdbcThinAbstractDmlStatementSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{String.class, Person.class});
        return cache;
    }

    final CacheConfiguration binaryCacheConfig() {
        CacheConfiguration cache = JdbcThinAbstractDmlStatementSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        QueryEntity e = new QueryEntity();
        e.setKeyType(String.class.getName());
        e.setValueType("Person");
        e.addQueryField("id", Integer.class.getName(), null);
        e.addQueryField("age", Integer.class.getName(), null);
        e.addQueryField("firstName", String.class.getName(), null);
        e.addQueryField("lastName", String.class.getName(), null);
        cache.setQueryEntities(Collections.singletonList(e));
        return cache;
    }

    CacheConfiguration cacheConfig() {
        return this.nonBinCacheConfig();
    }

    static class Person
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField
        private final String firstName;
        @QuerySqlField
        private final String lastName;
        @QuerySqlField
        private final int age;

        Person(int id, String firstName, String lastName, int age) {
            assert (!F.isEmpty((String)firstName));
            assert (!F.isEmpty((String)lastName));
            assert (age > 0);
            this.id = id;
            this.firstName = firstName;
            this.lastName = lastName;
            this.age = age;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            if (this.id != person.id) {
                return false;
            }
            if (this.age != person.age) {
                return false;
            }
            if (this.firstName != null ? !this.firstName.equals(person.firstName) : person.firstName != null) {
                return false;
            }
            return this.lastName != null ? this.lastName.equals(person.lastName) : person.lastName == null;
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
            result = 31 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
            result = 31 * result + this.age;
            return result;
        }
    }
}

