/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityKey;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcMetadataSelfTest
extends GridCommonAbstractTest {
    private static final String URL = "jdbc:ignite://127.0.0.1/pers";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    protected CacheConfiguration cacheConfiguration() {
        CacheConfiguration cache = JdbcMetadataSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        return cache;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
        IgniteCache orgCache = this.jcache((Ignite)this.grid(0), this.cacheConfiguration(), "org", String.class, Organization.class);
        assert (orgCache != null);
        orgCache.put((Object)"o1", (Object)new Organization(1, "A"));
        orgCache.put((Object)"o2", (Object)new Organization(2, "B"));
        IgniteCache personCache = this.jcache((Ignite)this.grid(0), this.cacheConfiguration(), "pers", AffinityKey.class, Person.class);
        assert (personCache != null);
        personCache.put((Object)new AffinityKey((Object)"p1", (Object)"o1"), (Object)new Person("John White", 25, 1));
        personCache.put((Object)new AffinityKey((Object)"p2", (Object)"o1"), (Object)new Person("Joe Black", 35, 1));
        personCache.put((Object)new AffinityKey((Object)"p3", (Object)"o2"), (Object)new Person("Mike Green", 40, 2));
        this.jcache((Ignite)this.grid(0), this.cacheConfiguration(), "metaTest", AffinityKey.class, MetaTest.class);
    }

    @Test
    public void testResultSetMetaData() throws Exception {
        Statement stmt = DriverManager.getConnection(URL).createStatement();
        ResultSet rs = stmt.executeQuery("select p.name, o.id as orgId from \"pers\".Person p, \"org\".Organization o where p.orgId = o.id");
        assert (rs != null);
        ResultSetMetaData meta = rs.getMetaData();
        assert (meta != null);
        assert (meta.getColumnCount() == 2);
        assert ("Person".equalsIgnoreCase(meta.getTableName(1)));
        assert ("name".equalsIgnoreCase(meta.getColumnName(1)));
        assert ("name".equalsIgnoreCase(meta.getColumnLabel(1)));
        assert (meta.getColumnType(1) == 12);
        assert ("VARCHAR".equals(meta.getColumnTypeName(1)));
        assert ("java.lang.String".equals(meta.getColumnClassName(1)));
        assert ("Organization".equalsIgnoreCase(meta.getTableName(2)));
        assert ("orgId".equalsIgnoreCase(meta.getColumnName(2)));
        assert ("orgId".equalsIgnoreCase(meta.getColumnLabel(2)));
        assert (meta.getColumnType(2) == 4);
        assert ("INTEGER".equals(meta.getColumnTypeName(2)));
        assert ("java.lang.Integer".equals(meta.getColumnClassName(2)));
    }

    @Test
    public void testDecimalAndDateTypeMetaData() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select t.decimal, t.date from \"metaTest\".MetaTest as t");
            assert (rs != null);
            ResultSetMetaData meta = rs.getMetaData();
            assert (meta != null);
            assert (meta.getColumnCount() == 2);
            assert ("METATEST".equalsIgnoreCase(meta.getTableName(1)));
            assert ("DECIMAL".equalsIgnoreCase(meta.getColumnName(1)));
            assert ("DECIMAL".equalsIgnoreCase(meta.getColumnLabel(1)));
            assert (meta.getColumnType(1) == 3);
            assert ("DECIMAL".equals(meta.getColumnTypeName(1)));
            assert ("java.math.BigDecimal".equals(meta.getColumnClassName(1)));
            assert ("METATEST".equalsIgnoreCase(meta.getTableName(2)));
            assert ("DATE".equalsIgnoreCase(meta.getColumnName(2)));
            assert ("DATE".equalsIgnoreCase(meta.getColumnLabel(2)));
            assert (meta.getColumnType(2) == 91);
            assert ("DATE".equals(meta.getColumnTypeName(2)));
            assert ("java.sql.Date".equals(meta.getColumnClassName(2)));
        }
    }

    @Test
    public void testGetTables() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getTables("", "pers", "%", new String[]{"TABLE"});
            JdbcMetadataSelfTest.assertNotNull((Object)rs);
            JdbcMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcMetadataSelfTest.assertEquals((String)"TABLE", (String)rs.getString("TABLE_TYPE"));
            JdbcMetadataSelfTest.assertEquals((String)"PERSON", (String)rs.getString("TABLE_NAME"));
            rs = meta.getTables("", "org", "%", new String[]{"TABLE"});
            JdbcMetadataSelfTest.assertNotNull((Object)rs);
            JdbcMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcMetadataSelfTest.assertEquals((String)"TABLE", (String)rs.getString("TABLE_TYPE"));
            JdbcMetadataSelfTest.assertEquals((String)"ORGANIZATION", (String)rs.getString("TABLE_NAME"));
            rs = meta.getTables("", "pers", "%", null);
            JdbcMetadataSelfTest.assertNotNull((Object)rs);
            JdbcMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcMetadataSelfTest.assertEquals((String)"TABLE", (String)rs.getString("TABLE_TYPE"));
            JdbcMetadataSelfTest.assertEquals((String)"PERSON", (String)rs.getString("TABLE_NAME"));
            rs = meta.getTables("", "org", "%", null);
            JdbcMetadataSelfTest.assertNotNull((Object)rs);
            JdbcMetadataSelfTest.assertTrue((boolean)rs.next());
            JdbcMetadataSelfTest.assertEquals((String)"TABLE", (String)rs.getString("TABLE_TYPE"));
            JdbcMetadataSelfTest.assertEquals((String)"ORGANIZATION", (String)rs.getString("TABLE_NAME"));
            rs = meta.getTables("", "PUBLIC", "", new String[]{"WRONG"});
            JdbcMetadataSelfTest.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testGetColumns() throws Exception {
        boolean primitivesInformationIsLostAfterStore = this.ignite(0).configuration().getMarshaller() instanceof BinaryMarshaller;
        try (Connection conn = DriverManager.getConnection(URL);){
            String name;
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getColumns("", "pers", "Person", "%");
            assert (rs != null);
            ArrayList<String> names = new ArrayList<String>(2);
            names.add("NAME");
            names.add("AGE");
            names.add("ORGID");
            int cnt = 0;
            while (rs.next()) {
                name = rs.getString("COLUMN_NAME");
                assert (names.remove(name));
                if ("NAME".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 12);
                    assert ("VARCHAR".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 1);
                } else if ("AGE".equals(name) || "ORGID".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 4);
                    assert ("INTEGER".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == (primitivesInformationIsLostAfterStore ? 1 : 0));
                }
                if ("_KEY".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 1111);
                    assert ("OTHER".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 0);
                }
                if ("_VAL".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 1111);
                    assert ("OTHER".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 0);
                }
                ++cnt;
            }
            assert (names.isEmpty());
            assert (cnt == 3);
            rs = meta.getColumns("", "org", "Organization", "%");
            assert (rs != null);
            names.add("ID");
            names.add("NAME");
            cnt = 0;
            while (rs.next()) {
                name = rs.getString("COLUMN_NAME");
                assert (names.remove(name));
                if ("id".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 4);
                    assert ("INTEGER".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 0);
                } else if ("name".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 12);
                    assert ("VARCHAR".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 1);
                }
                if ("_KEY".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 12);
                    assert ("VARCHAR".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 0);
                }
                if ("_VAL".equals(name)) {
                    assert (rs.getInt("DATA_TYPE") == 1111);
                    assert ("OTHER".equals(rs.getString("TYPE_NAME")));
                    assert (rs.getInt("NULLABLE") == 0);
                }
                ++cnt;
            }
            assert (names.isEmpty());
            assert (cnt == 2);
        }
    }

    @Test
    public void testMetadataResultSetClose() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);
             ResultSet tbls = conn.getMetaData().getTables(null, null, "%", null);){
            int colCnt = tbls.getMetaData().getColumnCount();
            while (tbls.next()) {
                for (int i = 0; i < colCnt; ++i) {
                    tbls.getObject(i + 1);
                }
            }
        }
        catch (Exception ignored) {
            JdbcMetadataSelfTest.fail();
        }
    }

    @Test
    public void testCheckSupports() throws SQLException {
        try (Connection conn = DriverManager.getConnection(URL);){
            DatabaseMetaData meta = conn.getMetaData();
            JdbcMetadataSelfTest.assertTrue((boolean)meta.supportsANSI92EntryLevelSQL());
            JdbcMetadataSelfTest.assertTrue((boolean)meta.supportsAlterTableWithAddColumn());
            JdbcMetadataSelfTest.assertTrue((boolean)meta.supportsAlterTableWithDropColumn());
            JdbcMetadataSelfTest.assertTrue((boolean)meta.nullPlusNonNullIsNull());
        }
    }

    private static class MetaTest
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField
        private final Date date;
        @QuerySqlField
        private final BigDecimal decimal;

        private MetaTest(int id, Date date, BigDecimal decimal) {
            this.id = id;
            this.date = date;
            this.decimal = decimal;
        }
    }

    private static class Organization
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField(index=false)
        private final String name;

        private Organization(int id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField(index=false)
        private final String name;
        @QuerySqlField
        private final int age;
        @QuerySqlField
        private final int orgId;

        private Person(String name, int age, int orgId) {
            assert (!F.isEmpty((String)name));
            assert (age > 0);
            assert (orgId > 0);
            this.name = name;
            this.age = age;
            this.orgId = orgId;
        }
    }
}

