/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.rest.TestMemcacheClient;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class RestMemcacheProtocolSelfTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache";
    private static final String HOST = "127.0.0.1";
    private static final int PORT = 11212;
    private TestMemcacheClient client;

    protected void beforeTestsStarted() throws Exception {
        this.startGrid();
    }

    protected void beforeTest() throws Exception {
        this.client = this.client();
    }

    protected void afterTest() throws Exception {
        this.client.shutdown();
        this.grid().cache("default").clear();
        this.grid().cache(CACHE_NAME).clear();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setLocalHost(HOST);
        assert (cfg.getConnectorConfiguration() == null);
        ConnectorConfiguration clientCfg = new ConnectorConfiguration();
        clientCfg.setPort(11212);
        cfg.setConnectorConfiguration(clientCfg);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("default"), this.cacheConfiguration(CACHE_NAME)});
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String cacheName) throws Exception {
        CacheConfiguration cfg = RestMemcacheProtocolSelfTest.defaultCacheConfiguration();
        cfg.setCacheMode(CacheMode.LOCAL);
        cfg.setName(cacheName);
        cfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cfg.setStatisticsEnabled(true);
        return cfg;
    }

    private TestMemcacheClient client() throws IgniteCheckedException {
        return new TestMemcacheClient(HOST, 11212);
    }

    @Test
    public void testPut() throws Exception {
        RestMemcacheProtocolSelfTest.assertTrue((boolean)this.client.cachePut(null, "key1", "val1"));
        RestMemcacheProtocolSelfTest.assertEquals((Object)"val1", (Object)this.grid().cache("default").get((Object)"key1"));
        RestMemcacheProtocolSelfTest.assertTrue((boolean)this.client.cachePut(CACHE_NAME, "key1", "val1"));
        RestMemcacheProtocolSelfTest.assertEquals((Object)"val1", (Object)this.grid().cache(CACHE_NAME).get((Object)"key1"));
    }

    @Test
    public void testGet() throws Exception {
        this.grid().cache("default").put((Object)"key", (Object)"val");
        Assert.assertEquals((Object)"val", this.client.cacheGet(null, "key"));
        this.grid().cache(CACHE_NAME).put((Object)"key", (Object)"val");
        Assert.assertEquals((Object)"val", this.client.cacheGet(CACHE_NAME, "key"));
    }

    @Test
    public void testRemove() throws Exception {
        this.grid().cache("default").put((Object)"key", (Object)"val");
        RestMemcacheProtocolSelfTest.assertTrue((boolean)this.client.cacheRemove(null, "key"));
        RestMemcacheProtocolSelfTest.assertFalse((boolean)this.client.cacheRemove(null, "wrongKey"));
        RestMemcacheProtocolSelfTest.assertNull((Object)this.grid().cache("default").get((Object)"key"));
        this.grid().cache(CACHE_NAME).put((Object)"key", (Object)"val");
        RestMemcacheProtocolSelfTest.assertTrue((boolean)this.client.cacheRemove(CACHE_NAME, "key"));
        RestMemcacheProtocolSelfTest.assertFalse((boolean)this.client.cacheRemove(CACHE_NAME, "wrongKey"));
        RestMemcacheProtocolSelfTest.assertNull((Object)this.grid().cache(CACHE_NAME).get((Object)"key"));
    }

    @Test
    public void testAdd() throws Exception {
        RestMemcacheProtocolSelfTest.assertTrue((boolean)this.client.cacheAdd(null, "key", "val"));
        RestMemcacheProtocolSelfTest.assertEquals((Object)"val", (Object)this.grid().cache("default").get((Object)"key"));
        RestMemcacheProtocolSelfTest.assertFalse((boolean)this.client.cacheAdd(null, "key", "newVal"));
        RestMemcacheProtocolSelfTest.assertEquals((Object)"val", (Object)this.grid().cache("default").get((Object)"key"));
        RestMemcacheProtocolSelfTest.assertTrue((boolean)this.client.cacheAdd(CACHE_NAME, "key", "val"));
        RestMemcacheProtocolSelfTest.assertEquals((Object)"val", (Object)this.grid().cache(CACHE_NAME).get((Object)"key"));
        RestMemcacheProtocolSelfTest.assertFalse((boolean)this.client.cacheAdd(CACHE_NAME, "key", "newVal"));
        RestMemcacheProtocolSelfTest.assertEquals((Object)"val", (Object)this.grid().cache(CACHE_NAME).get((Object)"key"));
    }

    @Test
    public void testReplace() throws Exception {
        RestMemcacheProtocolSelfTest.assertFalse((boolean)this.client.cacheReplace(null, "key1", "val1"));
        this.grid().cache("default").put((Object)"key1", (Object)"val1");
        RestMemcacheProtocolSelfTest.assertTrue((boolean)this.client.cacheReplace(null, "key1", "val2"));
        RestMemcacheProtocolSelfTest.assertFalse((boolean)this.client.cacheReplace(null, "key2", "val1"));
        this.grid().cache("default").put((Object)"key2", (Object)"val1");
        RestMemcacheProtocolSelfTest.assertTrue((boolean)this.client.cacheReplace(null, "key2", "val2"));
        this.grid().cache("default").clear();
        RestMemcacheProtocolSelfTest.assertFalse((boolean)this.client.cacheReplace(CACHE_NAME, "key1", "val1"));
        this.grid().cache(CACHE_NAME).put((Object)"key1", (Object)"val1");
        RestMemcacheProtocolSelfTest.assertTrue((boolean)this.client.cacheReplace(CACHE_NAME, "key1", "val2"));
    }

    @Test
    public void testMetrics() throws Exception {
        this.grid().cache("default").localMxBean().clear();
        this.grid().cache(CACHE_NAME).localMxBean().clear();
        this.grid().cache("default").put((Object)"key1", (Object)"val");
        this.grid().cache("default").put((Object)"key2", (Object)"val");
        this.grid().cache("default").put((Object)"key2", (Object)"val");
        this.grid().cache("default").get((Object)"key1");
        this.grid().cache("default").get((Object)"key2");
        this.grid().cache("default").get((Object)"key2");
        this.grid().cache(CACHE_NAME).put((Object)"key1", (Object)"val");
        this.grid().cache(CACHE_NAME).put((Object)"key2", (Object)"val");
        this.grid().cache(CACHE_NAME).put((Object)"key2", (Object)"val");
        this.grid().cache(CACHE_NAME).get((Object)"key1");
        this.grid().cache(CACHE_NAME).get((Object)"key2");
        this.grid().cache(CACHE_NAME).get((Object)"key2");
        Map<String, Long> m = this.client.cacheMetrics(null);
        RestMemcacheProtocolSelfTest.assertNotNull(m);
        RestMemcacheProtocolSelfTest.assertEquals((int)4, (int)m.size());
        RestMemcacheProtocolSelfTest.assertEquals((long)3L, (long)m.get("reads"));
        RestMemcacheProtocolSelfTest.assertEquals((long)3L, (long)m.get("writes"));
        m = this.client.cacheMetrics(CACHE_NAME);
        RestMemcacheProtocolSelfTest.assertNotNull(m);
        RestMemcacheProtocolSelfTest.assertEquals((int)4, (int)m.size());
        RestMemcacheProtocolSelfTest.assertEquals((long)3L, (long)m.get("reads"));
        RestMemcacheProtocolSelfTest.assertEquals((long)3L, (long)m.get("writes"));
    }

    @Test
    public void testIncrement() throws Exception {
        RestMemcacheProtocolSelfTest.assertEquals((long)15L, (long)this.client().increment("key", 10L, 5L));
        RestMemcacheProtocolSelfTest.assertEquals((long)15L, (long)this.grid().atomicLong("key", 0L, true).get());
        RestMemcacheProtocolSelfTest.assertEquals((long)18L, (long)this.client().increment("key", 20L, 3L));
        RestMemcacheProtocolSelfTest.assertEquals((long)18L, (long)this.grid().atomicLong("key", 0L, true).get());
        RestMemcacheProtocolSelfTest.assertEquals((long)20L, (long)this.client().increment("key", null, 2L));
        RestMemcacheProtocolSelfTest.assertEquals((long)20L, (long)this.grid().atomicLong("key", 0L, true).get());
        RestMemcacheProtocolSelfTest.assertEquals((long)15L, (long)this.client().increment("key1", 10L, 5L));
        RestMemcacheProtocolSelfTest.assertEquals((long)15L, (long)this.grid().atomicLong("key1", 0L, true).get());
        RestMemcacheProtocolSelfTest.assertEquals((long)18L, (long)this.client().increment("key1", 20L, 3L));
        RestMemcacheProtocolSelfTest.assertEquals((long)18L, (long)this.grid().atomicLong("key1", 0L, true).get());
        RestMemcacheProtocolSelfTest.assertEquals((long)20L, (long)this.client().increment("key1", null, 2L));
        RestMemcacheProtocolSelfTest.assertEquals((long)20L, (long)this.grid().atomicLong("key1", 0L, true).get());
    }

    @Test
    public void testDecrement() throws Exception {
        RestMemcacheProtocolSelfTest.assertEquals((long)15L, (long)this.client().decrement("key", 20L, 5L));
        RestMemcacheProtocolSelfTest.assertEquals((long)15L, (long)this.grid().atomicLong("key", 0L, true).get());
        RestMemcacheProtocolSelfTest.assertEquals((long)12L, (long)this.client().decrement("key", 20L, 3L));
        RestMemcacheProtocolSelfTest.assertEquals((long)12L, (long)this.grid().atomicLong("key", 0L, true).get());
        RestMemcacheProtocolSelfTest.assertEquals((long)10L, (long)this.client().decrement("key", null, 2L));
        RestMemcacheProtocolSelfTest.assertEquals((long)10L, (long)this.grid().atomicLong("key", 0L, true).get());
        RestMemcacheProtocolSelfTest.assertEquals((long)15L, (long)this.client().decrement("key1", 20L, 5L));
        RestMemcacheProtocolSelfTest.assertEquals((long)15L, (long)this.grid().atomicLong("key1", 0L, true).get());
        RestMemcacheProtocolSelfTest.assertEquals((long)12L, (long)this.client().decrement("key1", 20L, 3L));
        RestMemcacheProtocolSelfTest.assertEquals((long)12L, (long)this.grid().atomicLong("key1", 0L, true).get());
        RestMemcacheProtocolSelfTest.assertEquals((long)10L, (long)this.client().decrement("key1", null, 2L));
        RestMemcacheProtocolSelfTest.assertEquals((long)10L, (long)this.grid().atomicLong("key1", 0L, true).get());
    }

    @Test
    public void testAppend() throws Exception {
        RestMemcacheProtocolSelfTest.assertFalse((boolean)this.client.cacheAppend(null, "wrongKey", "_suffix"));
        RestMemcacheProtocolSelfTest.assertFalse((boolean)this.client.cacheAppend(CACHE_NAME, "wrongKey", "_suffix"));
        this.grid().cache("default").put((Object)"key", (Object)"val");
        RestMemcacheProtocolSelfTest.assertTrue((boolean)this.client.cacheAppend(null, "key", "_suffix"));
        RestMemcacheProtocolSelfTest.assertEquals((Object)"val_suffix", (Object)this.grid().cache("default").get((Object)"key"));
        this.grid().cache(CACHE_NAME).put((Object)"key", (Object)"val");
        RestMemcacheProtocolSelfTest.assertTrue((boolean)this.client.cacheAppend(CACHE_NAME, "key", "_suffix"));
        RestMemcacheProtocolSelfTest.assertEquals((Object)"val_suffix", (Object)this.grid().cache(CACHE_NAME).get((Object)"key"));
    }

    @Test
    public void testPrepend() throws Exception {
        RestMemcacheProtocolSelfTest.assertFalse((boolean)this.client.cachePrepend(null, "wrongKey", "prefix_"));
        RestMemcacheProtocolSelfTest.assertFalse((boolean)this.client.cachePrepend(CACHE_NAME, "wrongKey", "prefix_"));
        this.grid().cache("default").put((Object)"key", (Object)"val");
        RestMemcacheProtocolSelfTest.assertTrue((boolean)this.client.cachePrepend(null, "key", "prefix_"));
        RestMemcacheProtocolSelfTest.assertEquals((Object)"prefix_val", (Object)this.grid().cache("default").get((Object)"key"));
        this.grid().cache(CACHE_NAME).put((Object)"key", (Object)"val");
        RestMemcacheProtocolSelfTest.assertTrue((boolean)this.client.cachePrepend(CACHE_NAME, "key", "prefix_"));
        RestMemcacheProtocolSelfTest.assertEquals((Object)"prefix_val", (Object)this.grid().cache(CACHE_NAME).get((Object)"key"));
    }

    @Test
    public void testVersion() throws Exception {
        RestMemcacheProtocolSelfTest.assertNotNull((Object)this.client.version());
    }

    @Test
    public void testNoop() throws Exception {
        this.client.noop();
    }

    @Test
    public void testQuit() throws Exception {
        this.client.quit();
    }
}

