/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.ignite.internal.processors.rest.AbstractRestProcessorSelfTest;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.TestRestClient;
import org.apache.ignite.internal.processors.rest.protocols.http.jetty.GridJettyObjectMapper;

public abstract class JettyRestProcessorCommonSelfTest
extends AbstractRestProcessorSelfTest {
    private static final int GRID_CNT = 3;
    protected static final ObjectMapper JSON_MAPPER = new GridJettyObjectMapper();
    private final TestRestClient restClient = this.createRestClient();

    @Override
    protected void beforeTestsStarted() throws Exception {
        System.setProperty("IGNITE_JETTY_PORT", Integer.toString(this.restPort()));
        super.beforeTestsStarted();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        System.clearProperty("IGNITE_JETTY_PORT");
    }

    @Override
    protected int gridCount() {
        return 3;
    }

    protected TestRestClient createRestClient() {
        return new TestRestClient(this::signature);
    }

    protected int restPort() {
        return this.restClient.restPort();
    }

    protected boolean securityEnabled() {
        return false;
    }

    protected abstract String signature() throws Exception;

    protected String content(Map<String, String> params) throws Exception {
        return this.restClient.content(params);
    }

    protected String content(String cacheName, GridRestCommand cmd, String ... params) throws Exception {
        return this.restClient.content(cacheName, cmd, params);
    }

    protected String jsonField(String json, String field) throws IOException {
        return this.restClient.jsonField(json, field);
    }
}

