/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.JettyRestProcessorAuthenticationAbstractTest;
import org.apache.ignite.internal.processors.rest.TestRestClient;
import org.apache.ignite.internal.util.typedef.F;
import org.junit.Test;

public class JettyRestProcessorAuthenticationWithTokenSelfTest
extends JettyRestProcessorAuthenticationAbstractTest {
    private String tok = "";

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        if (F.isEmpty((String)this.tok)) {
            this.refreshToken();
        }
    }

    @Override
    protected void restartGrid() throws Exception {
        this.tok = null;
        super.restartGrid();
        this.refreshToken();
    }

    private void refreshToken() throws Exception {
        String ret = this.content("default", GridRestCommand.AUTHENTICATE, "user", "ignite", "password", "ignite");
        int p1 = ret.indexOf("sessionToken");
        int p2 = ret.indexOf(34, p1 + 16);
        this.tok = ret.substring(p1 + 15, p2);
    }

    @Override
    protected TestRestClient createRestClient() {
        return new TestRestClient(this::signature){

            @Override
            public String restUrl() {
                String url = super.restUrl();
                if (!F.isEmpty((String)JettyRestProcessorAuthenticationWithTokenSelfTest.this.tok)) {
                    url = url + "sessionToken=" + JettyRestProcessorAuthenticationWithTokenSelfTest.this.tok + "&";
                }
                return url;
            }
        };
    }

    @Test
    public void testInvalidSessionToken() throws Exception {
        this.tok = null;
        String ret = this.content(null, GridRestCommand.NAME, new String[0]);
        this.assertResponseContainsError(ret, "Failed to handle request - session token not found or invalid");
        this.tok = "InvalidToken";
        ret = this.content(null, GridRestCommand.NAME, new String[0]);
        this.assertResponseContainsError(ret, "Failed to handle request - session token not found or invalid");
        this.tok = "26BE027D32CC42329DEC92D517B44E9E";
        ret = this.content(null, GridRestCommand.NAME, new String[0]);
        this.assertResponseContainsError(ret, "Failed to handle request - unknown session token (maybe expired session)");
        this.tok = null;
    }
}

