/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.Map;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.rest.AbstractRestProcessorSelfTest;
import org.apache.ignite.internal.util.typedef.F;
import org.junit.Assert;
import org.junit.Test;

public class ClientMemcachedProtocolSelfTest
extends AbstractRestProcessorSelfTest {
    private static final int GRID_CNT = 1;
    private Integer customPort;
    private MemcachedClientIF client;

    @Override
    protected int gridCount() {
        return 1;
    }

    private MemcachedClientIF startClient() throws Exception {
        int port = this.customPort != null ? this.customPort : 11211;
        return new MemcachedClient((ConnectionFactory)new BinaryConnectionFactory(), F.asList((Object)new InetSocketAddress("127.0.0.1", port)));
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.client = this.startClient();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.client.shutdown();
        this.customPort = null;
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        assert (cfg.getConnectorConfiguration() != null);
        if (this.customPort != null) {
            cfg.getConnectorConfiguration().setPort(this.customPort.intValue());
        }
        return cfg;
    }

    @Test
    public void testGet() throws Exception {
        this.jcache().put((Object)"getKey1", (Object)"getVal1");
        this.jcache().put((Object)"getKey2", (Object)"getVal2");
        Assert.assertEquals((Object)"getVal1", (Object)this.client.get("getKey1"));
        Assert.assertEquals((Object)"getVal2", (Object)this.client.get("getKey2"));
        Assert.assertNull((Object)this.client.get("wrongKey"));
    }

    @Test
    public void testGetBulk() throws Exception {
        this.jcache().put((Object)"getKey1", (Object)"getVal1");
        this.jcache().put((Object)"getKey2", (Object)"getVal2");
        this.jcache().put((Object)"getKey3", (Object)"getVal3");
        Map map = this.client.getBulk(new String[]{"getKey1", "getKey2"});
        this.info("Map: " + map);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"getVal1", map.get("getKey1"));
        Assert.assertEquals((Object)"getVal2", map.get("getKey2"));
    }

    @Test
    public void testSet() throws Exception {
        Assert.assertTrue((boolean)((Boolean)this.client.set("setKey", 0, (Object)"setVal").get()));
        ClientMemcachedProtocolSelfTest.assertEquals((Object)"setVal", (Object)this.jcache().get((Object)"setKey"));
    }

    @Test
    public void testSetWithExpiration() throws Exception {
        Assert.assertTrue((boolean)((Boolean)this.client.set("setKey", 2000, (Object)"setVal").get()));
        ClientMemcachedProtocolSelfTest.assertEquals((Object)"setVal", (Object)this.jcache().get((Object)"setKey"));
        Thread.sleep(2100L);
        Assert.assertNull((Object)this.jcache().get((Object)"setKey"));
    }

    @Test
    public void testAdd() throws Exception {
        this.jcache().put((Object)"addKey1", (Object)"addVal1");
        Assert.assertFalse((boolean)((Boolean)this.client.add("addKey1", 0, (Object)"addVal1New").get()));
        Assert.assertTrue((boolean)((Boolean)this.client.add("addKey2", 0, (Object)"addVal2").get()));
        ClientMemcachedProtocolSelfTest.assertEquals((Object)"addVal1", (Object)this.jcache().get((Object)"addKey1"));
        ClientMemcachedProtocolSelfTest.assertEquals((Object)"addVal2", (Object)this.jcache().get((Object)"addKey2"));
    }

    @Test
    public void testAddWithExpiration() throws Exception {
        Assert.assertTrue((boolean)((Boolean)this.client.add("addKey", 2000, (Object)"addVal").get()));
        ClientMemcachedProtocolSelfTest.assertEquals((Object)"addVal", (Object)this.jcache().get((Object)"addKey"));
        Thread.sleep(2100L);
        Assert.assertNull((Object)this.jcache().get((Object)"addKey"));
    }

    @Test
    public void testReplace() throws Exception {
        Assert.assertFalse((boolean)((Boolean)this.client.replace("replaceKey", 0, (Object)"replaceVal").get()));
        Assert.assertNull((Object)this.jcache().get((Object)"replaceKey"));
        this.jcache().put((Object)"replaceKey", (Object)"replaceVal");
        Assert.assertTrue((boolean)((Boolean)this.client.replace("replaceKey", 0, (Object)"replaceValNew").get()));
        ClientMemcachedProtocolSelfTest.assertEquals((Object)"replaceValNew", (Object)this.jcache().get((Object)"replaceKey"));
    }

    @Test
    public void testReplaceWithExpiration() throws Exception {
        this.jcache().put((Object)"replaceKey", (Object)"replaceVal");
        Assert.assertTrue((boolean)((Boolean)this.client.set("replaceKey", 2000, (Object)"replaceValNew").get()));
        ClientMemcachedProtocolSelfTest.assertEquals((Object)"replaceValNew", (Object)this.jcache().get((Object)"replaceKey"));
        Thread.sleep(2100L);
        Assert.assertNull((Object)this.jcache().get((Object)"replaceKey"));
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertFalse((boolean)((Boolean)this.client.delete("deleteKey").get()));
        this.jcache().put((Object)"deleteKey", (Object)"deleteVal");
        Assert.assertTrue((boolean)((Boolean)this.client.delete("deleteKey").get()));
        Assert.assertNull((Object)this.jcache().get((Object)"deleteKey"));
    }

    @Test
    public void testIncrement() throws Exception {
        Assert.assertEquals((long)5L, (long)this.client.incr("incrKey", 3, 2L));
        ClientMemcachedProtocolSelfTest.assertEquals((long)5L, (long)this.grid(0).atomicLong("incrKey", 0L, true).get());
        Assert.assertEquals((long)15L, (long)this.client.incr("incrKey", 10, 0L));
        ClientMemcachedProtocolSelfTest.assertEquals((long)15L, (long)this.grid(0).atomicLong("incrKey", 0L, true).get());
    }

    @Test
    public void testDecrement() throws Exception {
        Assert.assertEquals((long)5L, (long)this.client.decr("decrKey", 10, 15L));
        ClientMemcachedProtocolSelfTest.assertEquals((long)5L, (long)this.grid(0).atomicLong("decrKey", 0L, true).get());
        Assert.assertEquals((long)2L, (long)this.client.decr("decrKey", 3, 0L));
        ClientMemcachedProtocolSelfTest.assertEquals((long)2L, (long)this.grid(0).atomicLong("decrKey", 0L, true).get());
    }

    @Test
    public void testFlush() throws Exception {
        this.jcache().put((Object)"flushKey1", (Object)"flushVal1");
        this.jcache().put((Object)"flushKey2", (Object)"flushVal2");
        Assert.assertTrue((boolean)((Boolean)this.client.flush().get()));
        Assert.assertNull((Object)this.jcache().get((Object)"flushKey1"));
        Assert.assertNull((Object)this.jcache().get((Object)"flushKey2"));
        Assert.assertTrue((this.jcache().localSize(new CachePeekMode[0]) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStat() throws Exception {
        this.jcache().put((Object)"statKey1", (Object)"statVal1");
        ClientMemcachedProtocolSelfTest.assertEquals((Object)"statVal1", (Object)this.jcache().get((Object)"statKey1"));
        Map map = this.client.getStats();
        Assert.assertEquals((long)1L, (long)map.size());
        Map stats = (Map)F.first(map.values());
        Assert.assertEquals((long)4L, (long)stats.size());
        Assert.assertTrue((Integer.valueOf((String)stats.get("writes")) >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((Integer.valueOf((String)stats.get("reads")) >= 1 ? 1 : 0) != 0);
        this.jcache().put((Object)"statKey2", (Object)"statVal2");
        ClientMemcachedProtocolSelfTest.assertEquals((Object)"statVal2", (Object)this.jcache().get((Object)"statKey2"));
        map = this.client.getStats();
        Assert.assertEquals((long)1L, (long)map.size());
        stats = (Map)F.first(map.values());
        Assert.assertEquals((long)4L, (long)stats.size());
        Assert.assertTrue((Integer.valueOf((String)stats.get("writes")) >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((Integer.valueOf((String)stats.get("reads")) >= 2 ? 1 : 0) != 0);
    }

    @Test
    public void testAppend() throws Exception {
        Assert.assertFalse((boolean)((Boolean)this.client.append(0L, "appendKey", (Object)"_suffix").get()));
        this.jcache().put((Object)"appendKey", (Object)"appendVal");
        Assert.assertTrue((boolean)((Boolean)this.client.append(0L, "appendKey", (Object)"_suffix").get()));
        Assert.assertEquals((Object)"appendVal_suffix", (Object)this.client.get("appendKey"));
        ClientMemcachedProtocolSelfTest.assertEquals((Object)"appendVal_suffix", (Object)this.jcache().get((Object)"appendKey"));
    }

    @Test
    public void testPrepend() throws Exception {
        Assert.assertFalse((boolean)((Boolean)this.client.append(0L, "prependKey", (Object)"_suffix").get()));
        this.jcache().put((Object)"prependKey", (Object)"prependVal");
        Assert.assertTrue((boolean)((Boolean)this.client.append(0L, "prependKey", (Object)"_suffix").get()));
        Assert.assertEquals((Object)"prependVal_suffix", (Object)this.client.get("prependKey"));
        ClientMemcachedProtocolSelfTest.assertEquals((Object)"prependVal_suffix", (Object)this.jcache().get((Object)"prependKey"));
    }

    @Test
    public void testSpecialTypes() throws Exception {
        Assert.assertTrue((boolean)((Boolean)this.client.set("boolKey", 0, (Object)true).get()));
        Assert.assertEquals((Object)true, (Object)this.client.get("boolKey"));
        Assert.assertTrue((boolean)((Boolean)this.client.set("intKey", 0, (Object)10).get()));
        Assert.assertEquals((Object)10, (Object)this.client.get("intKey"));
        Assert.assertTrue((boolean)((Boolean)this.client.set("longKey", 0, (Object)100L).get()));
        Assert.assertEquals((Object)100L, (Object)this.client.get("longKey"));
        Date now = new Date();
        Assert.assertTrue((boolean)((Boolean)this.client.set("dateKey", 0, (Object)now).get()));
        Assert.assertEquals((Object)now, (Object)this.client.get("dateKey"));
        Assert.assertTrue((boolean)((Boolean)this.client.set("byteKey", 0, (Object)1).get()));
        Assert.assertEquals((Object)1, (Object)this.client.get("byteKey"));
        Assert.assertTrue((boolean)((Boolean)this.client.set("floatKey", 0, (Object)1.1).get()));
        Assert.assertEquals((Object)1.1, (Object)this.client.get("floatKey"));
        Assert.assertTrue((boolean)((Boolean)this.client.set("doubleKey", 0, (Object)100.001).get()));
        Assert.assertEquals((Object)100.001, (Object)this.client.get("doubleKey"));
        byte[] arr = new byte[5];
        for (int i = 0; i < arr.length; i = (int)((byte)(i + 1))) {
            arr[i] = i;
        }
        Assert.assertTrue((boolean)((Boolean)this.client.set("arrKey", 0, (Object)arr).get()));
        Assert.assertArrayEquals((byte[])arr, (byte[])((byte[])this.client.get("arrKey")));
        Assert.assertTrue((boolean)((Boolean)this.client.set("shortKey", 0, (Object)1).get()));
        Assert.assertEquals((Object)1, (Object)this.client.get("shortKey"));
    }

    @Test
    public void testComplexObject() throws Exception {
        Assert.assertTrue((boolean)((Boolean)this.client.set("objKey", 0, (Object)new ValueObject(10, "String")).get()));
        Assert.assertEquals((Object)new ValueObject(10, "String"), (Object)this.client.get("objKey"));
    }

    @Test
    public void testCustomPort() throws Exception {
        this.customPort = 11212;
        IgniteEx g = this.startGrid();
        assert (g != null);
        assert (g.cluster().nodes().size() == this.gridCount() + 1);
        MemcachedClientIF c = this.startClient();
        Assert.assertTrue((boolean)((Boolean)c.set("key", 0, (Object)1).get()));
        Assert.assertEquals((Object)1, (Object)c.get("key"));
        c.shutdown();
        this.stopGrid();
    }

    @Test
    public void testVersion() throws Exception {
        Map map = this.client.getVersions();
        Assert.assertEquals((long)1L, (long)map.size());
        String ver = (String)F.first(map.values());
        Assert.assertFalse((boolean)F.isEmpty((String)ver));
    }

    private static class ValueObject
    implements Serializable {
        private int intVal;
        private String strVal;

        private ValueObject(int intVal, String strVal) {
            this.intVal = intVal;
            this.strVal = strVal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValueObject obj = (ValueObject)o;
            return this.intVal == obj.intVal && !(this.strVal == null ? obj.strVal != null : !this.strVal.equals(obj.strVal));
        }

        public int hashCode() {
            int res = this.intVal;
            res = 31 * res + (this.strVal != null ? this.strVal.hashCode() : 0);
            return res;
        }
    }
}

