/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.oom.DiskSpillingAbstractTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class JdbcQueryQuotaTest
extends DiskSpillingAbstractTest {
    private static final String QUERY_1024_TO_2048 = "SELECT DISTINCT id FROM person WHERE id < 8";
    private static final String QUERY_2048_TO_4096 = "SELECT DISTINCT id FROM person WHERE id < 16";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setSqlConfiguration(new SqlConfiguration().setSqlOffloadingEnabled(false).setSqlQueryMemoryQuota("1024").setSqlGlobalMemoryQuota("60%"));
        return cfg;
    }

    protected boolean startClient() {
        return false;
    }

    @Test
    public void testClientQueryQuota() throws Exception {
        try (Connection conn512 = this.createConnection("jdbc-config-query-mem-limit-512.xml");
             Connection conn4096 = this.createConnection("jdbc-config-query-mem-limit-4096.xml");){
            Statement stmt0 = conn4096.createStatement();
            stmt0.execute(QUERY_1024_TO_2048);
            GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                Statement stmt = conn4096.createStatement();
                stmt.execute(QUERY_2048_TO_4096);
            }, IgniteException.class, (String)"SQL query ran out of memory: Query quota was exceeded.");
            GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                Statement stmt = conn512.createStatement();
                stmt.execute(QUERY_1024_TO_2048);
            }, IgniteException.class, (String)"SQL query ran out of memory: Query quota was exceeded.");
        }
    }

    public void runQueryWithMemLimit(String sql, long qryQuota) {
        IgniteEx client = this.grid(1);
        client.cache("default").query(new SqlFieldsQueryEx(sql, Boolean.valueOf(true)).setMaxMemory(qryQuota)).getAll();
    }

    public void runQueryFromClient(String sql, int idx) {
        IgniteEx client = this.grid(idx);
        JdbcQueryQuotaTest.assertTrue((boolean)client.cluster().node().isClient());
        client.cache("default").query(new SqlFieldsQuery(sql)).getAll();
    }

    protected Connection createConnection(String xmlCfg) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:ignite:cfg://modules/clients/src/test/config/" + xmlCfg);
        conn.setSchema("\"PUBLIC\"");
        return conn;
    }
}

