/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.ignite.jdbc.JdbcErrorsAbstractSelfTest;
import org.apache.ignite.lang.IgniteCallable;
import org.junit.Test;

public class JdbcErrorsSelfTest
extends JdbcErrorsAbstractSelfTest {
    private static final String CFG_PATH = "modules/clients/src/test/config/jdbc-config.xml";

    @Override
    protected Connection getConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:ignite:cfg://cache=test@modules/clients/src/test/config/jdbc-config.xml");
    }

    @Test
    public void testConnectionError() throws SQLException {
        String path = "jdbc:ignite:\u0441fg://cache=test@/unknown/path";
        this.checkErrorState(new IgniteCallable<Void>(){

            public Void call() throws Exception {
                DriverManager.getConnection("jdbc:ignite:\u0441fg://cache=test@/unknown/path");
                return null;
            }
        }, "08001", "No suitable driver found for jdbc:ignite:\u0441fg://cache=test@/unknown/path");
    }

    @Test
    public void testInvalidConnectionStringFormat() throws SQLException {
        String cfgPath = "cache=";
        this.checkErrorState(new IgniteCallable<Void>(){

            public Void call() throws Exception {
                DriverManager.getConnection("jdbc:ignite:cfg://cache=");
                return null;
            }
        }, "08001", "Failed to start Ignite node. Spring XML configuration path is invalid: cache=");
    }
}

