/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcEmptyCacheSelfTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache";
    private static final String BASE_URL = "jdbc:ignite:cfg://cache=cache@modules/clients/src/test/config/jdbc-config.xml";
    private Statement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcEmptyCacheSelfTest.defaultCacheConfiguration();
        cache.setName(CACHE_NAME);
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{Byte.class, Byte.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrid();
    }

    protected void beforeTest() throws Exception {
        this.stmt = DriverManager.getConnection(BASE_URL).createStatement();
        assert (this.stmt != null);
        assert (!this.stmt.isClosed());
    }

    protected void afterTest() throws Exception {
        if (this.stmt != null) {
            this.stmt.getConnection().close();
            this.stmt.close();
            assert (this.stmt.isClosed());
        }
    }

    @Test
    public void testSelectNumber() throws Exception {
        ResultSet rs = this.stmt.executeQuery("select 1");
        int cnt = 0;
        while (rs.next()) {
            assert (rs.getInt(1) == 1);
            assert ("1".equals(rs.getString(1)));
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testSelectString() throws Exception {
        ResultSet rs = this.stmt.executeQuery("select 'str'");
        int cnt = 0;
        while (rs.next()) {
            JdbcEmptyCacheSelfTest.assertEquals((String)"str", (String)rs.getString(1));
            ++cnt;
        }
        assert (cnt == 1);
    }
}

