/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public abstract class JdbcAbstractDmlStatementSelfTest
extends GridCommonAbstractTest {
    private static final String UTF_16 = "UTF-16";
    private static final String BASE_URL = "jdbc:ignite:cfg://cache=default@modules/clients/src/test/config/jdbc-config.xml";
    static final String BASE_URL_BIN = "jdbc:ignite:cfg://cache=default@modules/clients/src/test/config/jdbc-bin-config.xml";
    static final String SQL_SELECT = "select _key, id, firstName, lastName, age, data from Person";
    private static final String KEY_ALIAS = "key";
    protected Connection conn;

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
    }

    protected void beforeTest() throws Exception {
        this.ignite(0).context().cache().dynamicStartSqlCache(this.cacheConfig());
        this.conn = DriverManager.getConnection(this.getCfgUrl());
    }

    private CacheConfiguration nonBinCacheConfig() {
        CacheConfiguration cache = JdbcAbstractDmlStatementSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{String.class, Person.class});
        return cache;
    }

    final CacheConfiguration binaryCacheConfig() {
        CacheConfiguration cache = JdbcAbstractDmlStatementSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        QueryEntity e = new QueryEntity();
        e.setKeyType(String.class.getName());
        e.setValueType("Person");
        e.setKeyFieldName(KEY_ALIAS);
        e.addQueryField(KEY_ALIAS, e.getKeyType(), null);
        e.addQueryField("id", Integer.class.getName(), null);
        e.addQueryField("age", Integer.class.getName(), null);
        e.addQueryField("firstName", String.class.getName(), null);
        e.addQueryField("lastName", String.class.getName(), null);
        e.addQueryField("data", byte[].class.getName(), null);
        cache.setQueryEntities(Collections.singletonList(e));
        return cache;
    }

    CacheConfiguration cacheConfig() {
        return this.nonBinCacheConfig();
    }

    protected String getCfgUrl() {
        return BASE_URL;
    }

    protected void afterTest() throws Exception {
        this.ignite(0).context().cache().dynamicDestroyCache("default", true, true, false, null);
        if (this.conn != null) {
            this.conn.close();
            JdbcAbstractDmlStatementSelfTest.assertTrue((boolean)this.conn.isClosed());
        }
        this.cleanUpWorkingDir();
    }

    private void cleanUpWorkingDir() throws Exception {
        String workDir = U.defaultWorkDirectory();
        U.delete((File)U.resolveWorkDirectory((String)workDir, (String)"db/marshaller", (boolean)false));
    }

    static byte[] getBytes(String str) {
        try {
            return str.getBytes(UTF_16);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] getBytes(Blob blob) {
        try {
            return blob.getBytes(1L, (int)blob.length());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static String str(byte[] arr) {
        try {
            return new String(arr, UTF_16);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static class Person
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField
        private final String firstName;
        @QuerySqlField
        private final String lastName;
        @QuerySqlField
        private final int age;
        @QuerySqlField
        private final byte[] data;

        Person(int id, String firstName, String lastName, int age) {
            assert (!F.isEmpty((String)firstName));
            assert (!F.isEmpty((String)lastName));
            assert (age > 0);
            this.id = id;
            this.firstName = firstName;
            this.lastName = lastName;
            this.age = age;
            this.data = JdbcAbstractDmlStatementSelfTest.getBytes(lastName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            if (this.id != person.id) {
                return false;
            }
            if (this.age != person.age) {
                return false;
            }
            if (this.firstName != null ? !this.firstName.equals(person.firstName) : person.firstName != null) {
                return false;
            }
            return this.lastName != null ? this.lastName.equals(person.lastName) : person.lastName == null;
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
            result = 31 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
            result = 31 * result + this.age;
            return result;
        }
    }
}

