/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.router;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.client.integration.ClientAbstractSelfTest;
import org.apache.ignite.internal.client.router.GridTcpRouterConfiguration;
import org.apache.ignite.internal.client.router.impl.GridTcpRouterImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.logger.log4j.Log4JLogger;
import org.junit.Test;

public abstract class TcpRouterAbstractSelfTest
extends ClientAbstractSelfTest {
    private static final int ROUTER_PORT = 11213;
    private static GridTcpRouterImpl router;
    private static long sndCnt;
    private static long rcvCnt;

    @Override
    protected GridClientProtocol protocol() {
        return GridClientProtocol.TCP;
    }

    @Override
    protected String serverAddress() {
        return null;
    }

    @Override
    protected void beforeTest() throws Exception {
        sndCnt = router.getSendCount();
        rcvCnt = router.getReceivedCount();
        super.beforeTest();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        assert (router.getSendCount() > sndCnt) : "Failed to ensure network activity [currCnt=" + router.getSendCount() + ", oldCnt=" + sndCnt + ']';
        assert (router.getReceivedCount() > rcvCnt) : "Failed to ensure network activity [currCnt=" + router.getReceivedCount() + ", oldCnt=" + rcvCnt + ']';
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        router = new GridTcpRouterImpl(this.routerConfiguration());
        router.start();
    }

    protected void afterTestsStopped() throws Exception {
        router.stop();
    }

    @Override
    protected GridClientConfiguration clientConfiguration() throws GridClientException {
        GridClientConfiguration cfg = super.clientConfiguration();
        cfg.setServers(Collections.emptySet());
        cfg.setRouters(Collections.singleton("127.0.0.1:11213"));
        return cfg;
    }

    public GridTcpRouterConfiguration routerConfiguration() throws IgniteCheckedException {
        GridTcpRouterConfiguration cfg = new GridTcpRouterConfiguration();
        cfg.setHost("127.0.0.1");
        cfg.setPort(11213);
        cfg.setPortRange(0);
        cfg.setServers(Collections.singleton("127.0.0.1:11212"));
        cfg.setLogger((IgniteLogger)new Log4JLogger("modules/core/src/test/config/log4j-test.xml"));
        return cfg;
    }

    @Override
    @Test
    public void testConnectable() throws Exception {
        GridClient client = this.client();
        List nodes = client.compute().refreshTopology(false, false);
        TcpRouterAbstractSelfTest.assertFalse((boolean)((GridClientNode)F.first((List)nodes)).connectable());
    }
}

