/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.probe.GridProbeCommandHandler;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.plugin.AbstractTestPluginProvider;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class GridProbeCommandTest
extends GridCommonAbstractTest {
    private static final int JETTY_PORT = 8080;
    private CountDownLatch triggerRestCmdLatch = new CountDownLatch(1);
    private CountDownLatch triggerPluginStartLatch = new CountDownLatch(1);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        if (igniteInstanceName.equals("regular")) {
            return cfg;
        }
        if (igniteInstanceName.equals("delayedStart")) {
            DelayedStartPluginProvider delayedStartPluginProvider = new DelayedStartPluginProvider(this.triggerPluginStartLatch, this.triggerRestCmdLatch);
            cfg.setPluginProviders(new PluginProvider[]{delayedStartPluginProvider});
        }
        return cfg;
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids(false);
    }

    @Test
    public void testRestProbeCommand() throws Exception {
        this.startGrid("regular");
        GridProbeCommandHandler hnd = new GridProbeCommandHandler(this.grid("regular").context());
        GridRestCacheRequest req = new GridRestCacheRequest();
        req.command(GridRestCommand.PROBE);
        IgniteInternalFuture resp = hnd.handleAsync((GridRestRequest)req);
        resp.get();
        GridProbeCommandTest.assertEquals((int)0, (int)((GridRestResponse)resp.result()).getSuccessStatus());
        GridProbeCommandTest.assertEquals((Object)"grid has started", (Object)((GridRestResponse)resp.result()).getResponse());
    }

    @Test
    public void testRestProbeCommandGridNotStarted() throws Exception {
        Map<String, Object> probeRestCommandResponse;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    GridProbeCommandTest.this.startGrid("delayedStart");
                }
                catch (Exception e) {
                    log.error("error when starting delatedStart grid", (Throwable)e);
                }
            }
        }).start();
        log.info("awaiting plugin handler latch");
        this.triggerPluginStartLatch.await();
        log.info("starting rest command url call");
        try {
            probeRestCommandResponse = GridProbeCommandTest.executeProbeRestRequest();
            log.info("finished rest command url call");
        }
        finally {
            this.triggerRestCmdLatch.countDown();
        }
        GridProbeCommandTest.assertTrue((boolean)probeRestCommandResponse.get("error").equals("grid has not started"));
        GridProbeCommandTest.assertEquals((Object)503, (Object)probeRestCommandResponse.get("successStatus"));
    }

    @Test
    public void testRestProbeCommandGridStarted() throws Exception {
        this.startGrid("regular");
        Map<String, Object> probeRestCommandResponse = GridProbeCommandTest.executeProbeRestRequest();
        GridProbeCommandTest.assertTrue((boolean)probeRestCommandResponse.get("response").equals("grid has started"));
        GridProbeCommandTest.assertEquals((Object)0, (Object)probeRestCommandResponse.get("successStatus"));
    }

    public static Map<String, Object> executeProbeRestRequest() throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL("http://localhost:8080/ignite?cmd=probe").openConnection();
        conn.connect();
        boolean isHTTP_OK = conn.getResponseCode() == 200;
        Map restResponse = null;
        try (InputStreamReader streamReader = new InputStreamReader(isHTTP_OK ? conn.getInputStream() : conn.getErrorStream());){
            ObjectMapper objMapper = new ObjectMapper();
            restResponse = (Map)objMapper.readValue((Reader)streamReader, (TypeReference)new TypeReference<Map<String, Object>>(){});
            log.info("probe command response is: " + restResponse);
        }
        catch (Exception e) {
            log.error("error executing probe rest command", (Throwable)e);
        }
        return restResponse;
    }

    public static class DelayedStartPluginProvider
    extends AbstractTestPluginProvider {
        private CountDownLatch triggerRestCmd;
        private CountDownLatch triggerPluginStart;

        public DelayedStartPluginProvider(CountDownLatch triggerPluginStartLatch, CountDownLatch triggerRestCmdLatch) {
            this.triggerPluginStart = triggerPluginStartLatch;
            this.triggerRestCmd = triggerRestCmdLatch;
        }

        public String name() {
            return "DelatedStartPlugin";
        }

        public void onIgniteStart() {
            super.onIgniteStart();
            this.triggerPluginStart.countDown();
            log.info("awaiting rest command latch ...");
            try {
                this.triggerRestCmd.await();
            }
            catch (InterruptedException e) {
                log.error("error in custom plugin", (Throwable)e);
            }
            log.info("finished awaiting rest command latch.");
        }
    }
}

