/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDataConfiguration;
import org.apache.ignite.internal.client.GridClientPartitionAffinity;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.client.balancer.GridClientRandomBalancer;
import org.apache.ignite.internal.client.balancer.GridClientRoundRobinBalancer;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class ClientPropertiesConfigurationSelfTest
extends GridCommonAbstractTest {
    private static final URL GRID_CLIENT_SPRING_CONFIG = U.resolveIgniteUrl((String)"/modules/clients/config/grid-client-spring-config.xml");
    private static final URL GRID_CLIENT_CONFIG = U.resolveIgniteUrl((String)"/modules/clients/config/grid-client-config.properties");

    @Test
    public void testCreation() throws Exception {
        GridClientConfiguration cfg = new GridClientConfiguration();
        cfg.setServers(Arrays.asList("localhost:11211"));
        this.validateConfig(0, cfg);
        cfg = new GridClientConfiguration();
        cfg.setServers(Arrays.asList("localhost:11211"));
        this.validateConfig(0, cfg);
        Properties props = this.loadProperties(1, GRID_CLIENT_CONFIG);
        this.validateConfig(0, new GridClientConfiguration(props));
        Properties props2 = new Properties();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            props2.put("new." + e.getKey(), e.getValue());
        }
        this.validateConfig(0, new GridClientConfiguration("new.ignite.client", props2));
        this.validateConfig(0, new GridClientConfiguration("new.ignite.client.", props2));
        File tmp = this.uncommentProperties(GRID_CLIENT_CONFIG);
        props = this.loadProperties(25, tmp.toURI().toURL());
        this.validateConfig(2, new GridClientConfiguration(props));
        props2 = new Properties();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            props2.put("new." + e.getKey(), e.getValue());
        }
        this.validateConfig(2, new GridClientConfiguration("new.ignite.client", props2));
        this.validateConfig(2, new GridClientConfiguration("new.ignite.client.", props2));
        props2 = new Properties();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            props2.put(e.getKey().toString().replace("ignite.client.", ""), e.getValue());
        }
        this.validateConfig(2, new GridClientConfiguration("", props2));
        this.validateConfig(2, new GridClientConfiguration(".", props2));
    }

    @Test
    public void testSpringConfig() throws Exception {
        GridClientConfiguration cfg = (GridClientConfiguration)new FileSystemXmlApplicationContext(GRID_CLIENT_SPRING_CONFIG.toString()).getBean(GridClientConfiguration.class);
        ClientPropertiesConfigurationSelfTest.assertEquals(Arrays.asList("127.0.0.1:11211"), new ArrayList(cfg.getServers()));
        ClientPropertiesConfigurationSelfTest.assertNull((Object)cfg.getSecurityCredentialsProvider());
        Collection dataCfgs = cfg.getDataConfigurations();
        ClientPropertiesConfigurationSelfTest.assertEquals((int)1, (int)dataCfgs.size());
        GridClientDataConfiguration dataCfg = (GridClientDataConfiguration)dataCfgs.iterator().next();
        ClientPropertiesConfigurationSelfTest.assertEquals((String)"partitioned", (String)dataCfg.getName());
        ClientPropertiesConfigurationSelfTest.assertNotNull((Object)dataCfg.getPinnedBalancer());
        ClientPropertiesConfigurationSelfTest.assertEquals(GridClientRandomBalancer.class, dataCfg.getPinnedBalancer().getClass());
        ClientPropertiesConfigurationSelfTest.assertNotNull((Object)dataCfg.getAffinity());
        ClientPropertiesConfigurationSelfTest.assertEquals(GridClientPartitionAffinity.class, dataCfg.getAffinity().getClass());
    }

    private File uncommentProperties(URL url) throws IOException {
        InputStream in = url.openStream();
        ClientPropertiesConfigurationSelfTest.assertNotNull((Object)in);
        LineIterator it = IOUtils.lineIterator((InputStream)in, (String)"UTF-8");
        ArrayList<String> lines = new ArrayList<String>();
        while (it.hasNext()) {
            lines.add(it.nextLine().replace("#ignite.client.", "ignite.client."));
        }
        IgniteUtils.closeQuiet((AutoCloseable)in);
        File tmp = File.createTempFile(UUID.randomUUID().toString(), "properties");
        tmp.deleteOnExit();
        FileUtils.writeLines((File)tmp, lines);
        return tmp;
    }

    private Properties loadProperties(int expLoaded, URL url) throws IOException {
        InputStream in = url.openStream();
        Properties props = new Properties();
        ClientPropertiesConfigurationSelfTest.assertEquals((int)0, (int)props.size());
        props.load(in);
        ClientPropertiesConfigurationSelfTest.assertEquals((int)expLoaded, (int)props.size());
        IgniteUtils.closeQuiet((AutoCloseable)in);
        return props;
    }

    private void validateConfig(int expDataCfgs, GridClientConfiguration cfg) {
        ClientPropertiesConfigurationSelfTest.assertEquals(GridClientRandomBalancer.class, cfg.getBalancer().getClass());
        ClientPropertiesConfigurationSelfTest.assertEquals((int)10000, (int)cfg.getConnectTimeout());
        ClientPropertiesConfigurationSelfTest.assertEquals(null, (Object)cfg.getSecurityCredentialsProvider());
        ClientPropertiesConfigurationSelfTest.assertEquals((int)expDataCfgs, (int)cfg.getDataConfigurations().size());
        if (expDataCfgs == 2) {
            GridClientDataConfiguration nullCfg = cfg.getDataConfiguration(null);
            ClientPropertiesConfigurationSelfTest.assertEquals(null, (String)nullCfg.getName());
            ClientPropertiesConfigurationSelfTest.assertEquals(null, (Object)nullCfg.getAffinity());
            ClientPropertiesConfigurationSelfTest.assertEquals(GridClientRandomBalancer.class, nullCfg.getPinnedBalancer().getClass());
            GridClientDataConfiguration partCfg = cfg.getDataConfiguration("partitioned");
            ClientPropertiesConfigurationSelfTest.assertEquals((String)"partitioned", (String)partCfg.getName());
            ClientPropertiesConfigurationSelfTest.assertEquals(GridClientPartitionAffinity.class, partCfg.getAffinity().getClass());
            ClientPropertiesConfigurationSelfTest.assertEquals(GridClientRoundRobinBalancer.class, partCfg.getPinnedBalancer().getClass());
        }
        ClientPropertiesConfigurationSelfTest.assertEquals((long)30000L, (long)cfg.getMaxConnectionIdleTime());
        ClientPropertiesConfigurationSelfTest.assertEquals((Object)GridClientProtocol.TCP, (Object)cfg.getProtocol());
        ClientPropertiesConfigurationSelfTest.assertEquals(Arrays.asList("localhost:11211"), new ArrayList(cfg.getServers()));
        ClientPropertiesConfigurationSelfTest.assertEquals((boolean)true, (boolean)cfg.isEnableAttributesCache());
        ClientPropertiesConfigurationSelfTest.assertEquals((boolean)true, (boolean)cfg.isEnableMetricsCache());
        ClientPropertiesConfigurationSelfTest.assertEquals((boolean)true, (boolean)cfg.isTcpNoDelay());
        ClientPropertiesConfigurationSelfTest.assertEquals(null, (Object)cfg.getSslContextFactory(), null);
        ClientPropertiesConfigurationSelfTest.assertEquals((long)2000L, (long)cfg.getTopologyRefreshFrequency());
    }
}

