/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.impl;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFuture;
import org.apache.ignite.internal.client.GridClientFutureTimeoutException;
import org.apache.ignite.internal.client.impl.GridClientFutureAdapter;
import org.apache.ignite.internal.client.impl.GridClientFutureCallback;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ClientFutureAdapterSelfTest
extends GridCommonAbstractTest {
    @Test
    public void testFinished() {
        GridClientFutureAdapter fut = new GridClientFutureAdapter();
        ClientFutureAdapterSelfTest.assertFalse((boolean)fut.isDone());
        fut.onDone((Object)0);
        ClientFutureAdapterSelfTest.assertTrue((boolean)fut.isDone());
        ClientFutureAdapterSelfTest.assertTrue((boolean)new GridClientFutureAdapter((Object)0).isDone());
        ClientFutureAdapterSelfTest.assertTrue((boolean)new GridClientFutureAdapter((Throwable)new GridClientException("Test grid exception.")).isDone());
        ClientFutureAdapterSelfTest.assertTrue((boolean)new GridClientFutureAdapter((Throwable)new RuntimeException("Test runtime exception.")).isDone());
    }

    @Test
    public void testChains() throws GridClientException {
        this.testChains(1, 100L);
        this.testChains(10, 10L);
        this.testChains(100, 1L);
        this.testChains(1000, 0L);
    }

    private void testChains(int chainSize, long waitDelay) throws GridClientException {
        GridClientFutureAdapter fut = new GridClientFutureAdapter();
        ArrayList<GridClientFutureAdapter> chained = new ArrayList<GridClientFutureAdapter>();
        GridClientFutureAdapter cur = fut;
        for (int i = 0; i < chainSize; ++i) {
            cur = cur.chain((GridClientFutureCallback)new GridClientFutureCallback<Integer, Integer>(){

                public Integer onComplete(GridClientFuture<Integer> f) throws GridClientException {
                    ClientFutureAdapterSelfTest.assertTrue((String)"Expects callback future is finished.", (boolean)f.isDone());
                    return (Integer)f.get() + 1;
                }
            });
            chained.add(cur);
        }
        for (GridClientFuture gridClientFuture : chained) {
            ClientFutureAdapterSelfTest.assertFalse((boolean)gridClientFuture.isDone());
            long start = System.currentTimeMillis();
            try {
                gridClientFuture.get(waitDelay, TimeUnit.MILLISECONDS);
                ClientFutureAdapterSelfTest.fail((String)"Expects chained future not finished yet.");
            }
            catch (GridClientFutureTimeoutException gridClientFutureTimeoutException) {
                // empty catch block
            }
            ClientFutureAdapterSelfTest.assertTrue((System.currentTimeMillis() - start >= waitDelay ? 1 : 0) != 0);
        }
        long start = System.currentTimeMillis();
        fut.onDone((Object)0);
        ClientFutureAdapterSelfTest.assertEquals((String)"Check chain-based increment value.", (int)chainSize, (int)((Integer)((GridClientFutureAdapter)chained.get(chainSize - 1)).get()));
        this.info("Time consumption for " + chainSize + " chained futures: " + (System.currentTimeMillis() - start));
    }
}

