/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.Collections;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.client.ClientTcpTask;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ClientTcpTaskExecutionAfterTopologyRestartSelfTest
extends GridCommonAbstractTest {
    private static final int PORT = 11211;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setLocalHost("127.0.0.1");
        assert (cfg.getConnectorConfiguration() == null);
        ConnectorConfiguration clientCfg = new ConnectorConfiguration();
        clientCfg.setPort(11211);
        cfg.setConnectorConfiguration(clientCfg);
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testTaskAfterRestart() throws Exception {
        this.startGrids(1);
        GridClientConfiguration cfg = new GridClientConfiguration();
        cfg.setProtocol(GridClientProtocol.TCP);
        cfg.setServers(Collections.singleton("127.0.0.1:11211"));
        GridClient cli = GridClientFactory.start((GridClientConfiguration)cfg);
        cli.compute().execute(ClientTcpTask.class.getName(), Collections.singletonList("arg"));
        this.stopAllGrids();
        this.startGrid();
        cli.compute().execute(ClientTcpTask.class.getName(), Collections.singletonList("arg"));
    }
}

