/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.client.ClientTestRestServer;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionResetException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Ignore;
import org.junit.Test;

public class ClientReconnectionSelfTest
extends GridCommonAbstractTest {
    public static final String HOST = "127.0.0.1";
    private ClientTestRestServer[] srvs = new ClientTestRestServer[5];

    protected void afterTest() throws Exception {
        for (int i = 0; i < this.srvs.length; ++i) {
            ClientTestRestServer srv = this.srvs[i];
            if (srv != null) {
                srv.stop();
            }
            this.srvs[i] = null;
        }
        super.afterTest();
    }

    private GridClient client() throws GridClientException {
        return this.client(HOST);
    }

    private GridClient client(String host) throws GridClientException {
        GridClientConfiguration cfg = new GridClientConfiguration();
        cfg.setProtocol(GridClientProtocol.TCP);
        ArrayList<String> addrs = new ArrayList<String>();
        for (int port = 11000; port < 11005; ++port) {
            addrs.add(host + ":" + port);
        }
        cfg.setServers(addrs);
        cfg.setTopologyRefreshFrequency(3600000L);
        return GridClientFactory.start((GridClientConfiguration)cfg);
    }

    @Test
    public void testNoFailedReconnection() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.runServer(i, false);
        }
        try (GridClient client = this.client();){
            ClientReconnectionSelfTest.assertEquals((int)1, (int)this.srvs[0].getConnectCount());
            for (int i = 1; i < 5; ++i) {
                ClientReconnectionSelfTest.assertEquals((int)0, (int)this.srvs[i].getConnectCount());
            }
            this.srvs[0].resetCounters();
            int contactedSrv = 0;
            for (int i = 0; i < 100; ++i) {
                int failed = contactedSrv;
                this.srvs[failed].fail();
                while (true) {
                    try {
                        client.compute().refreshTopology(false, false);
                    }
                    catch (GridClientConnectionResetException e) {
                        this.info("Exception caught: " + (Object)((Object)e));
                        continue;
                    }
                    break;
                }
                int connects = 0;
                for (int srv = 0; srv < 5; ++srv) {
                    if (this.srvs[srv].getSuccessfulConnectCount() > 0) {
                        ClientReconnectionSelfTest.assertTrue((String)("Failed server was contacted: " + srv), (srv != failed ? 1 : 0) != 0);
                        contactedSrv = srv;
                    }
                    connects += this.srvs[srv].getSuccessfulConnectCount();
                }
                ClientReconnectionSelfTest.assertEquals((int)1, (int)connects);
                this.srvs[failed].repair();
                this.srvs[contactedSrv].resetCounters();
            }
        }
    }

    @Test
    public void testCorrectInit() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.runServer(i, i == 0);
        }
        try (GridClient ignored = this.client();){
            int i;
            for (i = 0; i < 2; ++i) {
                ClientReconnectionSelfTest.assertEquals((String)("Iteration: " + i), (int)1, (int)this.srvs[i].getConnectCount());
            }
            for (i = 2; i < 5; ++i) {
                ClientReconnectionSelfTest.assertEquals((int)0, (int)this.srvs[i].getConnectCount());
            }
        }
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-46334")
    public void testFailedInit() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.runServer(i, true);
        }
        GridClient c = this.client();
        try {
            c.compute().execute("fake", (Object)"arg");
            ClientReconnectionSelfTest.fail((String)"Client operation should fail when server resets connections.");
        }
        catch (GridClientDisconnectedException e) {
            ClientReconnectionSelfTest.assertTrue((String)("Thrown exception doesn't have an expected cause: " + X.getFullStackTrace((Throwable)e)), (boolean)X.hasCause((Throwable)e, (Class[])new Class[]{GridClientConnectionResetException.class, ClosedChannelException.class}));
        }
        for (int i = 0; i < 5; ++i) {
            ClientReconnectionSelfTest.assertEquals((String)("Server: " + i), (int)3, (int)this.srvs[i].getConnectCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-590")
    @Test
    public void testIdleConnection() throws Exception {
        int srvsCnt = 4;
        for (int i = 0; i < srvsCnt; ++i) {
            this.runServer(i, false);
        }
        GridClient client = this.client();
        try {
            int i;
            ClientReconnectionSelfTest.assertEquals((int)1, (int)this.srvs[0].getConnectCount());
            Thread.sleep(35000L);
            ClientReconnectionSelfTest.assertEquals((int)1, (int)this.srvs[0].getDisconnectCount());
            for (i = 1; i < srvsCnt; ++i) {
                ClientReconnectionSelfTest.assertEquals((int)0, (int)this.srvs[i].getConnectCount());
            }
            this.srvs[0].resetCounters();
            client.compute().refreshTopology(false, false);
            ClientReconnectionSelfTest.assertEquals((int)1, (int)this.srvs[0].getConnectCount());
            for (i = 1; i < srvsCnt; ++i) {
                ClientReconnectionSelfTest.assertEquals((int)0, (int)this.srvs[i].getConnectCount());
            }
        }
        finally {
            GridClientFactory.stop((UUID)client.id());
        }
    }

    private ClientTestRestServer runServer(int idx, boolean failOnConnect) throws IgniteCheckedException {
        ClientTestRestServer srv = new ClientTestRestServer(11000 + idx, failOnConnect, this.log());
        srv.start();
        this.srvs[idx] = srv;
        return srv;
    }
}

