/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.internal.client.TaskSingleJobSplitAdapter;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.resources.IgniteInstanceResource;

public class ClientGetAffinityTask
extends TaskSingleJobSplitAdapter<String, Integer> {
    @IgniteInstanceResource
    private transient Ignite ignite;

    @Override
    protected Object executeJob(int gridSize, String arg) {
        A.notNull((Object)arg, (String)"task argument");
        String[] split = arg.split(":", 2);
        A.ensure((split.length == 2 ? 1 : 0) != 0, (String)"Task argument should have format 'cacheName:affinityKey'.");
        String cacheName = split[0];
        String affKey = split[1];
        if ("null".equals(cacheName)) {
            cacheName = null;
        }
        ClusterNode node = this.ignite.affinity(cacheName).mapKeyToNode((Object)affKey);
        return node.id().toString();
    }

    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        if (res.getException() != null) {
            return ComputeJobResultPolicy.FAILOVER;
        }
        return ComputeJobResultPolicy.WAIT;
    }
}

