/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.common;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.common.ClientSizeCacheCreationDestructionTest;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.testframework.GridTestUtils;

public class ClientSideCacheCreationDestructionWileTopologyChangeTest
extends ClientSizeCacheCreationDestructionTest {
    private static final int MAX_NODES_CNT = 10;
    IgniteInternalFuture topChangeProcFut;
    AtomicBoolean procTopChanges = new AtomicBoolean(true);

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.topChangeProcFut = this.asyncTopologyChanges();
    }

    @Override
    protected void afterTest() throws Exception {
        try {
            this.procTopChanges.set(false);
            if (this.topChangeProcFut != null) {
                this.topChangeProcFut.get();
            }
        }
        finally {
            super.afterTest();
        }
    }

    private IgniteInternalFuture asyncTopologyChanges() {
        return GridTestUtils.runAsync(() -> {
            while (this.procTopChanges.get()) {
                try {
                    if (this.srv.cluster().nodes().size() >= 10) continue;
                    this.startGrid(UUID.randomUUID().toString());
                }
                catch (Exception e) {
                    ClientSideCacheCreationDestructionWileTopologyChangeTest.fail((String)("Unable to add or remove node: " + e));
                }
            }
        });
    }
}

