/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class JdbcThinNoDefaultSchemaTest
extends JdbcThinAbstractSelfTest {
    private static final String CACHE1_NAME = "cache1";
    private static final String CACHE2_NAME = "cache2";
    private static final String URL = "jdbc:ignite:thin://127.0.0.1";
    private static final int GRID_CNT = 2;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration(CACHE1_NAME), this.cacheConfiguration(CACHE2_NAME)});
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String name) throws Exception {
        CacheConfiguration cfg = JdbcThinNoDefaultSchemaTest.defaultCacheConfiguration();
        cfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        cfg.setName(name);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(2);
        IgniteEx ignite = this.ignite(0);
        IgniteCache cache1 = ignite.cache(CACHE1_NAME);
        IgniteCache cache2 = ignite.cache(CACHE2_NAME);
        for (int i = 0; i < 10; ++i) {
            cache1.put((Object)i, (Object)(i * 2));
            cache2.put((Object)i, (Object)(i * 3));
        }
    }

    @Test
    public void testDefaults() throws Exception {
        Connection conn = DriverManager.getConnection(URL);
        Throwable throwable = null;
        if (conn != null) {
            if (throwable != null) {
                try {
                    conn.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                conn.close();
            }
        }
        conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/");
        throwable = null;
        if (conn != null) {
            if (throwable != null) {
                try {
                    conn.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
            } else {
                conn.close();
            }
        }
    }

    @Test
    public void testSchemaNameInQuery() throws Exception {
        Connection conn = DriverManager.getConnection(URL);
        Statement stmt = conn.createStatement();
        JdbcThinNoDefaultSchemaTest.assertNotNull((Object)stmt);
        JdbcThinNoDefaultSchemaTest.assertFalse((boolean)stmt.isClosed());
        stmt.execute("select t._key, t._val from \"cache1\".Integer t");
        ResultSet rs = stmt.getResultSet();
        while (rs.next()) {
            JdbcThinNoDefaultSchemaTest.assertEquals((int)rs.getInt(2), (int)(rs.getInt(1) * 2));
        }
        stmt.execute("select t._key, t._val from \"cache2\".Integer t");
        rs = stmt.getResultSet();
        while (rs.next()) {
            JdbcThinNoDefaultSchemaTest.assertEquals((int)rs.getInt(2), (int)(rs.getInt(1) * 3));
        }
        stmt.execute("select t._key, t._val, v._val from \"cache1\".Integer t join \"cache2\".Integer v on t._key = v._key");
        rs = stmt.getResultSet();
        while (rs.next()) {
            JdbcThinNoDefaultSchemaTest.assertEquals((int)rs.getInt(2), (int)(rs.getInt(1) * 2));
            JdbcThinNoDefaultSchemaTest.assertEquals((int)rs.getInt(3), (int)(rs.getInt(1) * 3));
        }
        stmt.close();
    }

    @Test
    public void testSchemaInUrl() throws Exception {
        ResultSet rs;
        Statement stmt;
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/\"cache1\"");){
            stmt = conn.createStatement();
            stmt.execute("select t._key, t._val from Integer t");
            rs = stmt.getResultSet();
            while (rs.next()) {
                JdbcThinNoDefaultSchemaTest.assertEquals((int)rs.getInt(2), (int)(rs.getInt(1) * 2));
            }
        }
        conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/\"cache2\"");
        var2_2 = null;
        try {
            stmt = conn.createStatement();
            stmt.execute("select t._key, t._val from Integer t");
            rs = stmt.getResultSet();
            while (rs.next()) {
                JdbcThinNoDefaultSchemaTest.assertEquals((int)rs.getInt(2), (int)(rs.getInt(1) * 3));
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testSchemaInUrlAndInQuery() throws Exception {
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/\"cache2\"");){
            Statement stmt = conn.createStatement();
            stmt.execute("select t._key, t._val, v._val from \"cache1\".Integer t join Integer v on t._key = v._key");
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                JdbcThinNoDefaultSchemaTest.assertEquals((int)rs.getInt(2), (int)(rs.getInt(1) * 2));
                JdbcThinNoDefaultSchemaTest.assertEquals((int)rs.getInt(3), (int)(rs.getInt(1) * 3));
            }
        }
    }

    @Test
    public void testSetSchema() throws Exception {
        try (final Connection conn = DriverManager.getConnection(URL);){
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Statement stmt = conn.createStatement();
                    stmt.execute("select t._key, t._val from Integer t");
                    return null;
                }
            }, SQLException.class, (String)"Table \"INTEGER\" not found");
            conn.setSchema("\"cache1\"");
            Statement stmt = conn.createStatement();
            conn.setSchema("invalid_schema");
            stmt.execute("select t._key, t._val from Integer t");
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                JdbcThinNoDefaultSchemaTest.assertEquals((int)rs.getInt(2), (int)(rs.getInt(1) * 2));
            }
        }
    }
}

