/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Before;
import org.junit.Test;

public class JdbcThinMultiStatementSelfTest
extends GridCommonAbstractTest {
    public void beforeTestsStarted() throws Exception {
        System.setProperty("IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK", "false");
        this.startGrids(2);
    }

    @Before
    public void setupTables() throws Exception {
        this.execute("DROP TABLE IF EXISTS TEST_TX; DROP TABLE IF EXISTS public.transactions; DROP TABLE IF EXISTS ONE;DROP TABLE IF EXISTS TWO;");
        this.execute("CREATE TABLE TEST_TX (ID INT PRIMARY KEY, AGE INT, NAME VARCHAR) WITH \"atomicity=transactional_snapshot\";");
        this.execute("INSERT INTO TEST_TX VALUES (1, 17, 'James'), (2, 43, 'Valery'), (3, 25, 'Michel'), (4, 19, 'Nick');");
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    private void execute(String sql) throws Exception {
        try (Connection c = GridTestUtils.connect((IgniteEx)this.grid(0), null);
             Statement stmt = c.createStatement();){
            stmt.executeUpdate(sql);
        }
    }

    @Test
    public void testMixedCommands() throws Exception {
        this.execute("CREATE TABLE public.transactions (pk INT, id INT, k VARCHAR, v VARCHAR, PRIMARY KEY (pk, id)); CREATE INDEX transactions_id_k_v ON public.transactions (id, k, v) INLINE_SIZE 150; INSERT INTO public.transactions VALUES (1,2,'some', 'word') ; CREATE INDEX transactions_k_v_id ON public.transactions (k, v, id) INLINE_SIZE 150; CREATE INDEX transactions_pk_id ON public.transactions (pk, id) INLINE_SIZE 20;");
    }

    @Test
    public void testEmptyStatements() throws Exception {
        this.execute(";; ;;;;");
        this.execute(" ;; ;;;; ");
        this.execute("CREATE TABLE ONE (id INT PRIMARY KEY, VAL VARCHAR);;CREATE INDEX T_IDX ON ONE(val);;UPDATE ONE SET VAL = 'SOME';;;  ");
        this.execute("DROP INDEX T_IDX ;;  ;;UPDATE ONE SET VAL = 'SOME'");
    }

    @Test
    public void testMultiStatementTxWithParams() throws Exception {
        int leoAge = 28;
        String nickolas = "Nickolas";
        int gabAge = 84;
        String gabName = "Gab";
        int delYounger = 19;
        String complexQuery = "INSERT INTO TEST_TX VALUES (5, ?, 'Leo'); ;;;;BEGIN ; UPDATE TEST_TX  SET name = ? WHERE name = 'Nick' ;INSERT INTO TEST_TX VALUES (6, ?, ?); DELETE FROM TEST_TX WHERE age < ?; COMMIT;";
        try (Connection c = GridTestUtils.connect((IgniteEx)this.grid(0), null);){
            try (PreparedStatement p = c.prepareStatement(complexQuery);){
                p.setInt(1, leoAge);
                p.setString(2, nickolas);
                p.setInt(3, gabAge);
                p.setString(4, gabName);
                p.setInt(5, delYounger);
                JdbcThinMultiStatementSelfTest.assertFalse((String)"Expected, that first result is an update count.", (boolean)p.execute());
                JdbcThinMultiStatementSelfTest.assertTrue((String)"Expected update count of the INSERT.", (p.getUpdateCount() != -1 ? 1 : 0) != 0);
                JdbcThinMultiStatementSelfTest.assertTrue((String)"More results are expected.", (boolean)p.getMoreResults());
                JdbcThinMultiStatementSelfTest.assertTrue((String)"Expected update count of an empty statement.", (p.getUpdateCount() != -1 ? 1 : 0) != 0);
                JdbcThinMultiStatementSelfTest.assertTrue((String)"More results are expected.", (boolean)p.getMoreResults());
                JdbcThinMultiStatementSelfTest.assertTrue((String)"Expected update count of an empty statement.", (p.getUpdateCount() != -1 ? 1 : 0) != 0);
                JdbcThinMultiStatementSelfTest.assertTrue((String)"More results are expected.", (boolean)p.getMoreResults());
                JdbcThinMultiStatementSelfTest.assertTrue((String)"Expected update count of an empty statement.", (p.getUpdateCount() != -1 ? 1 : 0) != 0);
                JdbcThinMultiStatementSelfTest.assertTrue((String)"More results are expected.", (boolean)p.getMoreResults());
                JdbcThinMultiStatementSelfTest.assertTrue((String)"Expected update count of an empty statement.", (p.getUpdateCount() != -1 ? 1 : 0) != 0);
                JdbcThinMultiStatementSelfTest.assertTrue((String)"More results are expected.", (boolean)p.getMoreResults());
                JdbcThinMultiStatementSelfTest.assertTrue((String)"Expected update count of the BEGIN", (p.getUpdateCount() != -1 ? 1 : 0) != 0);
                JdbcThinMultiStatementSelfTest.assertTrue((String)"More results are expected.", (boolean)p.getMoreResults());
                JdbcThinMultiStatementSelfTest.assertTrue((String)"Expected update count of the UPDATE", (p.getUpdateCount() != -1 ? 1 : 0) != 0);
                JdbcThinMultiStatementSelfTest.assertTrue((String)"More results are expected.", (boolean)p.getMoreResults());
                JdbcThinMultiStatementSelfTest.assertTrue((String)"Expected update count of the INSERT", (p.getUpdateCount() != -1 ? 1 : 0) != 0);
                JdbcThinMultiStatementSelfTest.assertTrue((String)"More results are expected.", (boolean)p.getMoreResults());
                JdbcThinMultiStatementSelfTest.assertTrue((String)"Expected update count of the DELETE", (p.getUpdateCount() != -1 ? 1 : 0) != 0);
                JdbcThinMultiStatementSelfTest.assertTrue((String)"More results are expected.", (boolean)p.getMoreResults());
                JdbcThinMultiStatementSelfTest.assertTrue((String)"Expected update count of the COMMIT", (p.getUpdateCount() != -1 ? 1 : 0) != 0);
                JdbcThinMultiStatementSelfTest.assertFalse((String)"There should have been no results.", (boolean)p.getMoreResults());
                JdbcThinMultiStatementSelfTest.assertFalse((String)"There should have been no update results.", (p.getUpdateCount() != -1 ? 1 : 0) != 0);
            }
            var10_12 = null;
            try (PreparedStatement sel = c.prepareStatement("SELECT * FROM TEST_TX ORDER BY ID;");
                 ResultSet pers = sel.executeQuery();){
                JdbcThinMultiStatementSelfTest.assertTrue((boolean)pers.next());
                JdbcThinMultiStatementSelfTest.assertEquals((int)43, (int)JdbcThinMultiStatementSelfTest.age(pers));
                JdbcThinMultiStatementSelfTest.assertEquals((String)"Valery", (String)JdbcThinMultiStatementSelfTest.name(pers));
                JdbcThinMultiStatementSelfTest.assertTrue((boolean)pers.next());
                JdbcThinMultiStatementSelfTest.assertEquals((int)25, (int)JdbcThinMultiStatementSelfTest.age(pers));
                JdbcThinMultiStatementSelfTest.assertEquals((String)"Michel", (String)JdbcThinMultiStatementSelfTest.name(pers));
                JdbcThinMultiStatementSelfTest.assertTrue((boolean)pers.next());
                JdbcThinMultiStatementSelfTest.assertEquals((int)19, (int)JdbcThinMultiStatementSelfTest.age(pers));
                JdbcThinMultiStatementSelfTest.assertEquals((String)"Nickolas", (String)JdbcThinMultiStatementSelfTest.name(pers));
                JdbcThinMultiStatementSelfTest.assertTrue((boolean)pers.next());
                JdbcThinMultiStatementSelfTest.assertEquals((int)28, (int)JdbcThinMultiStatementSelfTest.age(pers));
                JdbcThinMultiStatementSelfTest.assertEquals((String)"Leo", (String)JdbcThinMultiStatementSelfTest.name(pers));
                JdbcThinMultiStatementSelfTest.assertTrue((boolean)pers.next());
                JdbcThinMultiStatementSelfTest.assertEquals((int)84, (int)JdbcThinMultiStatementSelfTest.age(pers));
                JdbcThinMultiStatementSelfTest.assertEquals((String)"Gab", (String)JdbcThinMultiStatementSelfTest.name(pers));
                JdbcThinMultiStatementSelfTest.assertFalse((boolean)pers.next());
            }
            catch (Throwable throwable) {
                var10_12 = throwable;
                throw throwable;
            }
        }
    }

    private static String name(ResultSet rs) throws SQLException {
        return rs.getString("NAME");
    }

    private static int age(ResultSet rs) throws SQLException {
        return rs.getInt("AGE");
    }
}

