/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcThinMetadataPrimaryKeysSelfTest
extends GridCommonAbstractTest {
    private static final String URL = "jdbc:ignite:thin://127.0.0.1";
    private static final int COL_NAME_IDX = 4;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid(1);
    }

    /*
     * Exception decompiling
     */
    private int executeUpdate(String sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void afterTest() throws Exception {
        this.executeUpdate("DROP TABLE IF EXISTS TEST;");
    }

    @Test
    public void testSingleUnwrappedKey() throws Exception {
        this.executeUpdate("CREATE TABLE TEST (ID LONG PRIMARY KEY, NAME VARCHAR);");
        this.checkPKFields("TEST", "ID");
    }

    @Test
    public void testSingleWrappedKey() throws Exception {
        this.executeUpdate("CREATE TABLE TEST (ID LONG PRIMARY KEY, NAME VARCHAR) WITH \"wrap_key=true\";");
        this.checkPKFields("TEST", "ID");
    }

    @Test
    public void testCompositeKey() throws Exception {
        this.executeUpdate("CREATE TABLE TEST (ID LONG, SEC_ID LONG, NAME VARCHAR, PRIMARY KEY (ID, SEC_ID));");
        this.checkPKFields("TEST", "ID", "SEC_ID");
    }

    @Test
    public void testCompositeKeyWithAK() throws Exception {
        String tpl = "CREATE TABLE TEST (ID LONG, SEC_ID LONG, NAME VARCHAR, PRIMARY KEY (ID, SEC_ID)) WITH \"affinity_key=%s\";";
        this.executeUpdate(String.format("CREATE TABLE TEST (ID LONG, SEC_ID LONG, NAME VARCHAR, PRIMARY KEY (ID, SEC_ID)) WITH \"affinity_key=%s\";", "ID"));
        this.checkPKFields("TEST", "ID", "SEC_ID");
        this.executeUpdate("DROP TABLE TEST;");
        this.executeUpdate(String.format("CREATE TABLE TEST (ID LONG, SEC_ID LONG, NAME VARCHAR, PRIMARY KEY (ID, SEC_ID)) WITH \"affinity_key=%s\";", "SEC_ID"));
        this.checkPKFields("TEST", "ID", "SEC_ID");
    }

    private void checkPKFields(String tabName, String ... expPKFields) throws Exception {
        try (Connection conn = DriverManager.getConnection(URL);){
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs = md.getPrimaryKeys(conn.getCatalog(), null, tabName);
            ArrayList<String> colNames = new ArrayList<String>();
            while (rs.next()) {
                colNames.add(rs.getString(4));
            }
            JdbcThinMetadataPrimaryKeysSelfTest.assertEquals((String)"Field names in the primary key are not correct", Arrays.asList(expPKFields), colNames);
        }
    }
}

