/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import javax.cache.configuration.Factory;
import javax.net.ssl.SSLContext;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.security.impl.TestAdditionalSecurityPluginProvider;
import org.apache.ignite.internal.processors.security.impl.TestSecurityData;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSetBuilder;
import org.apache.ignite.ssl.SslContextFactory;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class JdbcThinConnectionAdditionalSecurityTest
extends JdbcThinAbstractSelfTest {
    private static final String CLI_KEY_STORE_PATH = U.getIgniteHome() + "/modules/clients/src/test/keystore/client.jks";
    private static final String SRV_KEY_STORE_PATH = U.getIgniteHome() + "/modules/clients/src/test/keystore/server.jks";
    private static final String TRUST_KEY_STORE_PATH = U.getIgniteHome() + "/modules/clients/src/test/keystore/trust-one.jks";
    private static Factory<SSLContext> sslCtxFactory;
    private static boolean setSslCtxFactoryToCli;
    private static boolean setSslCtxFactoryToIgnite;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        cfg.setPluginProviders(new PluginProvider[]{new TestAdditionalSecurityPluginProvider("srv_" + igniteInstanceName, null, SecurityPermissionSetBuilder.ALLOW_ALL, false, true, this.clientData())});
        cfg.setClientConnectorConfiguration(new ClientConnectorConfiguration().setSslEnabled(true).setUseIgniteSslContextFactory(setSslCtxFactoryToIgnite).setSslClientAuth(true).setSslContextFactory(setSslCtxFactoryToCli ? sslCtxFactory : null));
        cfg.setSslContextFactory(setSslCtxFactoryToIgnite ? sslCtxFactory : null);
        return cfg;
    }

    protected TestSecurityData[] clientData() {
        return new TestSecurityData[]{new TestSecurityData("client", "pwd", SecurityPermissionSetBuilder.create().defaultAllowAll(false).appendSystemPermissions(new SecurityPermission[]{SecurityPermission.ADMIN_OPS}).build())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnection() throws Exception {
        setSslCtxFactoryToCli = true;
        sslCtxFactory = JdbcThinConnectionAdditionalSecurityTest.getTestSslContextFactory();
        this.startGrids(1);
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&user=client_admin_oper&password=pwd&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456&userAttributesFactory=org.apache.ignite.internal.processors.security.UserAttributesFactory");){
            this.checkConnection(conn);
        }
        finally {
            this.stopAllGrids();
        }
    }

    @Test
    public void testConnectionNoClientVersion() throws Exception {
        setSslCtxFactoryToIgnite = true;
        sslCtxFactory = JdbcThinConnectionAdditionalSecurityTest.getTestSslContextFactory();
        this.startGrids(1);
        try {
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&user=client_admin_oper&password=pwd&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");
                    return null;
                }
            }, SQLException.class, (String)"Client version is not found.");
        }
        finally {
            this.stopAllGrids();
        }
    }

    @Test
    public void testConnectionWrongLogin() throws Exception {
        setSslCtxFactoryToIgnite = true;
        sslCtxFactory = JdbcThinConnectionAdditionalSecurityTest.getTestSslContextFactory();
        this.startGrids(1);
        try {
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&user=server&password=pwd&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456&userAttributesFactory=org.apache.ignite.internal.processors.security.UserAttributesFactory");
                    return null;
                }
            }, SQLException.class, (String)"User isn't allowed to use client");
        }
        finally {
            this.stopAllGrids();
        }
    }

    @Test
    public void testConnectionUseIgniteFactory() throws Exception {
        setSslCtxFactoryToIgnite = true;
        sslCtxFactory = JdbcThinConnectionAdditionalSecurityTest.getTestSslContextFactory();
        this.startGrids(1);
        try {
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?sslMode=require&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + TRUST_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456&userAttributesFactory=org.apache.ignite.internal.processors.security.UserAttributesFactory");
                    return null;
                }
            }, SQLException.class, (String)"User isn't allowed to use client");
        }
        finally {
            this.stopAllGrids();
        }
    }

    public void checkConnection(Connection conn) throws SQLException {
        JdbcThinConnectionAdditionalSecurityTest.assertEquals((String)"PUBLIC", (String)conn.getSchema());
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT 1");
            JdbcThinConnectionAdditionalSecurityTest.assertTrue((boolean)rs.next());
            JdbcThinConnectionAdditionalSecurityTest.assertEquals((int)1, (int)rs.getInt(1));
        }
    }

    private static Factory<SSLContext> getTestSslContextFactory() {
        SslContextFactory factory = new SslContextFactory();
        factory.setKeyStoreFilePath(SRV_KEY_STORE_PATH);
        factory.setKeyStorePassword("123456".toCharArray());
        factory.setTrustStoreFilePath(TRUST_KEY_STORE_PATH);
        factory.setTrustStorePassword("123456".toCharArray());
        return factory;
    }
}

