/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class JdbcThinComplexDmlDdlSelfTest
extends GridCommonAbstractTest {
    private final CacheMode cacheMode = CacheMode.PARTITIONED;
    private final CacheAtomicityMode atomicityMode = CacheAtomicityMode.ATOMIC;
    private static final List<String> COMPANIES = Arrays.asList("ASF", "GNU", "BSD");
    private static final List<String> CITIES = Arrays.asList("St. Petersburg", "Boston", "Berkeley", "London");
    private Connection conn;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("default")});
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String name) {
        CacheConfiguration cfg = JdbcThinComplexDmlDdlSelfTest.defaultCacheConfiguration();
        cfg.setName(name);
        return cfg;
    }

    protected Connection createConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1");
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(2);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
    }

    protected void afterTest() throws Exception {
        this.conn.close();
        for (String cacheName : this.grid(0).cacheNames()) {
            DynamicCacheDescriptor cacheDesc = this.grid(0).context().cache().cacheDescriptor(cacheName);
            if (cacheDesc == null || !cacheDesc.sql()) continue;
            this.grid(0).destroyCache0(cacheName, true);
        }
        super.afterTest();
    }

    @Test
    public void testCreateSelectDrop() throws Exception {
        this.conn = this.createConnection();
        this.sql(new UpdateChecker(0), "CREATE TABLE person (id int, name varchar, age int, company varchar, city varchar, primary key (id, name, city)) WITH \"template=" + this.cacheMode.name() + ",atomicity=" + this.atomicityMode.name() + ",affinity_key=city\"", new Object[0]);
        this.sql(new UpdateChecker(0), "CREATE INDEX idx on person (city asc, name asc)", new Object[0]);
        this.sql(new UpdateChecker(0), "CREATE TABLE city (name varchar, population int, primary key (name)) WITH \"template=" + this.cacheMode.name() + ",atomicity=" + this.atomicityMode.name() + ",affinity_key=name\"", new Object[0]);
        this.sql(new UpdateChecker(3), "INSERT INTO city (name, population) values(?, ?), (?, ?), (?, ?)", "St. Petersburg", 6000000, "Boston", 2000000, "London", 8000000);
        this.sql(new ResultColumnChecker("id", "name", "age", "comp"), "SELECT id, name, age, company as comp FROM person where id < 50", new Object[0]);
        for (int i = 0; i < 100; ++i) {
            this.sql(new UpdateChecker(1), "INSERT INTO person (id, name, age, company, city) values (?, ?, ?, ?, ?)", i, "Person " + i, 20 + i % 10, COMPANIES.get(i % COMPANIES.size()), CITIES.get(i % CITIES.size()));
        }
        final int[] cnt = new int[]{0};
        this.sql(new ResultPredicateChecker(new IgnitePredicate<Object[]>(){

            public boolean apply(Object[] objs) {
                int id = (Integer)objs[0];
                if (id >= 50) {
                    return false;
                }
                if (20 + id % 10 != (Integer)objs[2]) {
                    return false;
                }
                if (!("Person " + id).equals(objs[1])) {
                    return false;
                }
                cnt[0] = cnt[0] + 1;
                return true;
            }
        }), "SELECT id, name, age FROM person where id < 50", new Object[0]);
        assert (cnt[0] == 50) : "Invalid rows count";
        this.sql(new ResultChecker(new Object[][]{{75L}}), "SELECT COUNT(*) from Person p inner join City c on p.city = c.name", new Object[0]);
        this.sql(new UpdateChecker(34), "UPDATE Person SET company = 'New Company', age = CASE WHEN MOD(id, 2) <> 0 THEN age + 5 ELSE age + 1 END WHERE company = 'ASF'", new Object[0]);
        cnt[0] = 0;
        this.sql(new ResultPredicateChecker(new IgnitePredicate<Object[]>(){

            public boolean apply(Object[] objs) {
                int id = (Integer)objs[0];
                int age = (Integer)objs[2];
                if (id % 2 == 0 ? age != 20 + id % 10 + 1 : age != 20 + id % 10 + 5) {
                    return false;
                }
                cnt[0] = cnt[0] + 1;
                return true;
            }
        }), "SELECT * FROM person where company = 'New Company'", new Object[0]);
        assert (cnt[0] == 34) : "Invalid rows count";
        this.sql(new UpdateChecker(0), "DROP INDEX idx", new Object[0]);
        this.sql(new UpdateChecker(0), "DROP TABLE city", new Object[0]);
        this.sql(new UpdateChecker(0), "DROP TABLE person", new Object[0]);
    }

    protected void sql(SingleStatementChecker checker, String sql, Object ... args) throws SQLException {
        Statement stmt;
        if (args.length > 0) {
            stmt = this.conn.prepareStatement(sql);
            PreparedStatement pstmt = (PreparedStatement)stmt;
            for (int i = 0; i < args.length; ++i) {
                pstmt.setObject(i + 1, args[i]);
            }
            pstmt.execute();
        } else {
            stmt = this.conn.createStatement();
            stmt.execute(sql);
        }
        this.checkResults(stmt, checker);
    }

    private void checkResults(Statement stmt, SingleStatementChecker checker) throws SQLException {
        ResultSet rs = stmt.getResultSet();
        if (rs != null) {
            checker.check(rs);
        } else {
            int updCnt = stmt.getUpdateCount();
            assert (updCnt != -1) : "Invalid results. Result set is null and update count is -1";
            checker.check(updCnt);
        }
    }

    private static class Row {
        private final Object[] row;

        private Row(Object[] row) {
            this.row = row;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Row row1 = (Row)o;
            return Arrays.equals(this.row, row1.row);
        }

        public int hashCode() {
            return Arrays.hashCode(this.row);
        }

        public String toString() {
            return Arrays.toString(this.row);
        }
    }

    static class ResultPredicateChecker
    implements SingleStatementChecker {
        private IgnitePredicate<Object[]> rowPredicate;

        ResultPredicateChecker(IgnitePredicate<Object[]> rowPredicate) {
            this.rowPredicate = rowPredicate;
        }

        @Override
        public void check(ResultSet rs) throws SQLException {
            int cols = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                Object[] rowObjs = new Object[cols];
                for (int i = 0; i < cols; ++i) {
                    rowObjs[i] = rs.getObject(i + 1);
                }
                assert (this.rowPredicate.apply((Object)rowObjs)) : "Invalid row. [row=" + Arrays.toString(rowObjs) + ']';
            }
        }

        @Override
        public void check(int updateCount) {
            JdbcThinComplexDmlDdlSelfTest.fail((String)("Results set is expected. [updateCount=" + updateCount + ']'));
        }
    }

    static class ResultColumnChecker
    extends ResultChecker {
        private final String[] expColLabels;

        ResultColumnChecker(String ... expColLabels) {
            super(new Object[0][]);
            this.expColLabels = expColLabels;
        }

        @Override
        public void check(ResultSet rs) throws SQLException {
            ResultSetMetaData meta = rs.getMetaData();
            int cols = meta.getColumnCount();
            assert (cols == this.expColLabels.length) : "Invalid columns count: [expected=" + this.expColLabels.length + ", actual=" + cols + ']';
            for (int i = 0; i < cols; ++i) {
                assert (this.expColLabels[i].equalsIgnoreCase(meta.getColumnName(i + 1)));
            }
            super.check(rs);
        }
    }

    static class ResultChecker
    implements SingleStatementChecker {
        private final Set<Row> expRs = new HashSet<Row>();

        ResultChecker(Object[][] expRs) {
            for (Object[] row : expRs) {
                this.expRs.add(new Row(row));
            }
        }

        @Override
        public void check(ResultSet rs) throws SQLException {
            int cols = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                Object[] rowObjs = new Object[cols];
                for (int i = 0; i < cols; ++i) {
                    rowObjs[i] = rs.getObject(i + 1);
                }
                Row row = new Row(rowObjs);
                assert (this.expRs.remove(row)) : "Invalid row. [row=" + row + ", remainedRows=" + this.printRemainedExpectedResult() + ']';
            }
            assert (this.expRs.isEmpty()) : "Expected results has rows that aren't contained at the result set. [remainedRows=" + this.printRemainedExpectedResult() + ']';
        }

        @Override
        public void check(int updateCount) {
            JdbcThinComplexDmlDdlSelfTest.fail((String)("Results set is expected. [updateCount=" + updateCount + ']'));
        }

        private String printRemainedExpectedResult() {
            StringBuilder sb = new StringBuilder();
            for (Row r : this.expRs) {
                sb.append('\n').append(r.toString());
            }
            return sb.toString();
        }
    }

    static class UpdateChecker
    implements SingleStatementChecker {
        private final int expUpdCnt;

        UpdateChecker(int expUpdCnt) {
            this.expUpdCnt = expUpdCnt;
        }

        @Override
        public void check(ResultSet rs) {
            JdbcThinComplexDmlDdlSelfTest.fail((String)("Update results are expected. [rs=" + rs + ']'));
        }

        @Override
        public void check(int updateCount) {
            JdbcThinComplexDmlDdlSelfTest.assertEquals((int)this.expUpdCnt, (int)updateCount);
        }
    }

    static interface SingleStatementChecker {
        public void check(ResultSet var1) throws SQLException;

        public void check(int var1);
    }
}

