/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.AbstractDataTypesCoverageTest;
import org.apache.ignite.internal.processors.cache.GridCacheDataTypesCoverageTest;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.lang.GridAbsPredicateX;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JdbcThinCacheToJdbcDataTypesCoverageTest
extends GridCacheDataTypesCoverageTest {
    public static boolean affinityAwareness;
    private static final Map<Class, IgniteBiTuple<Integer, Class>> javaClsToSqlTypeMap;
    private boolean asPreparedParam;
    private String url = affinityAwareness ? "jdbc:ignite:thin://127.0.0.1:10800..10802?affinityAwareness=true" : "jdbc:ignite:thin://127.0.0.1?affinityAwareness=false";
    private Connection conn;
    @Rule
    public ExpectedException expEx = ExpectedException.none();

    @Before
    public void init() throws Exception {
        super.init();
        this.asPreparedParam = false;
    }

    @After
    public void tearDown() throws Exception {
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.close();
            assert (this.conn.isClosed());
        }
    }

    @Test
    public void testFloatDataType() throws Exception {
        this.checkBasicCacheOperations(new Serializable[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), new AbstractDataTypesCoverageTest.Quoted((Object)Float.valueOf(Float.NaN)), new AbstractDataTypesCoverageTest.Quoted((Object)Float.valueOf(Float.NEGATIVE_INFINITY)), new AbstractDataTypesCoverageTest.Quoted((Object)Float.valueOf(Float.POSITIVE_INFINITY)), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.1f)});
    }

    @Test
    public void testDoubleDataType() throws Exception {
        this.checkBasicCacheOperations(new Serializable[]{Double.valueOf(Double.MIN_VALUE), Double.valueOf(Double.MAX_VALUE), new AbstractDataTypesCoverageTest.Quoted((Object)Double.NaN), new AbstractDataTypesCoverageTest.Quoted((Object)Double.NEGATIVE_INFINITY), new AbstractDataTypesCoverageTest.Quoted((Object)Double.POSITIVE_INFINITY), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(1.0), Double.valueOf(1.1)});
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-23662")
    @Test
    public void testCharacterDataType() throws Exception {
        this.checkBasicCacheOperations(new Serializable[]{new AbstractDataTypesCoverageTest.Quoted((Object)Character.valueOf('a')), new AbstractDataTypesCoverageTest.Quoted((Object)Character.valueOf('A'))});
    }

    @Test
    public void testStringDataType() throws Exception {
        this.checkBasicCacheOperations(new Serializable[]{new AbstractDataTypesCoverageTest.Quoted((Object)"aAbB"), new AbstractDataTypesCoverageTest.Quoted((Object)"")});
    }

    @Test
    public void testByteArrayDataType() throws Exception {
        this.checkBasicCacheOperations(new Serializable[]{new AbstractDataTypesCoverageTest.ByteArrayed(new byte[0]), new AbstractDataTypesCoverageTest.ByteArrayed(new byte[]{1, 2, 3}), new AbstractDataTypesCoverageTest.ByteArrayed(new byte[]{3, 2, 1})});
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-28896")
    @Test
    public void testObjectArrayDataType() throws Exception {
        super.testObjectArrayDataType();
    }

    @Test
    public void testListDataType() throws Exception {
        this.asPreparedParam = true;
        this.checkBasicCacheOperations(new ArrayList());
        this.checkBasicCacheOperations((Serializable)((Object)Collections.singletonList("Aaa")));
        this.checkBasicCacheOperations((Serializable)((Object)Arrays.asList("String", Boolean.TRUE, Character.valueOf('A'), 1)));
    }

    @Test
    public void testSetDataType() throws Exception {
        this.asPreparedParam = true;
        this.checkBasicCacheOperations(new HashSet());
        this.checkBasicCacheOperations((Serializable)((Object)Collections.singleton("Aaa")));
        this.checkBasicCacheOperations((Serializable)((Object)Arrays.asList("String", Boolean.TRUE, Character.valueOf('A'), 1)));
    }

    @Test
    public void testObjectBasedOnPrimitivesDataType() throws Exception {
        this.asPreparedParam = true;
        super.testObjectBasedOnPrimitivesDataType();
    }

    @Test
    public void testObjectBasedOnPrimitivesAndCollectionsDataType() throws Exception {
        this.asPreparedParam = true;
        super.testObjectBasedOnPrimitivesAndCollectionsDataType();
    }

    @Test
    public void testObjectBasedOnPrimitivesAndCollectionsAndNestedObjectsDataType() throws Exception {
        this.asPreparedParam = true;
        super.testObjectBasedOnPrimitivesAndCollectionsAndNestedObjectsDataType();
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-23659")
    @Test
    public void testDateDataType() throws Exception {
        this.checkBasicCacheOperations((T d) -> new Timestamp(((java.util.Date)d).getTime()), new Serializable[]{new AbstractDataTypesCoverageTest.Dated(new java.util.Date()), new AbstractDataTypesCoverageTest.Dated(new java.util.Date(Long.MIN_VALUE)), new AbstractDataTypesCoverageTest.Dated(new java.util.Date(Long.MAX_VALUE))});
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-23665")
    @Test
    public void testSqlDateDataType() throws Exception {
        super.testSqlDateDataType();
    }

    @Test
    public void testInstantDataType() throws Exception {
        this.asPreparedParam = true;
        super.testInstantDataType();
    }

    @Test
    public void testCalendarDataType() throws Exception {
        this.asPreparedParam = true;
        super.testCalendarDataType();
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-23664, https://ggsystems.atlassian.net/browse/GG-23665")
    @Test
    public void testLocalDateDataType() throws Exception {
        this.checkBasicCacheOperations((T ld) -> Date.valueOf((LocalDate)ld), new Serializable[]{new AbstractDataTypesCoverageTest.Dated(LocalDate.of(2015, 2, 20)), new AbstractDataTypesCoverageTest.Dated(LocalDate.now().plusDays(1L))});
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-23664")
    @Test
    public void testLocalDateTimeDataType() throws Exception {
        this.checkBasicCacheOperations((T ldt) -> Timestamp.valueOf((LocalDateTime)ldt), new Serializable[]{new AbstractDataTypesCoverageTest.Dated(LocalDateTime.of(2015, 2, 20, 9, 4, 30)), new AbstractDataTypesCoverageTest.Dated(LocalDateTime.now().plusDays(1L))});
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-23664")
    @Test
    public void testLocalTimeDataType() throws Exception {
        this.checkBasicCacheOperations((T lt) -> Time.valueOf((LocalTime)lt), new Serializable[]{new AbstractDataTypesCoverageTest.Timed(LocalTime.of(9, 4, 40)), new AbstractDataTypesCoverageTest.Timed(LocalTime.now())});
    }

    @Test
    public void testSQLTimestampDataType() throws Exception {
        this.checkBasicCacheOperations(new Serializable[]{new AbstractDataTypesCoverageTest.Dated(Timestamp.valueOf(LocalDateTime.now().truncatedTo(ChronoUnit.MILLIS)), "yyyy-MM-dd HH:mm:ss.SSS"), new AbstractDataTypesCoverageTest.Dated(Timestamp.valueOf(LocalDateTime.now().truncatedTo(ChronoUnit.MILLIS)), "yyyy-MM-dd HH:mm:ss.SSSS"), new AbstractDataTypesCoverageTest.Dated(Timestamp.valueOf(LocalDateTime.now().truncatedTo(ChronoUnit.MILLIS)), "yyyy-MM-dd HH:mm:ss.SSSSSS")});
    }

    @Test
    public void testBigIntegerDataType() throws Exception {
        this.asPreparedParam = true;
        super.testBigIntegerDataType();
    }

    protected void checkBasicCacheOperations(Serializable ... valsToCheck) throws Exception {
        this.checkBasicCacheOperations((T o) -> o, valsToCheck);
    }

    private void checkBasicCacheOperations(Function converterToSqlExpVal, Serializable ... valsToCheck) throws Exception {
        assert (valsToCheck.length > 0);
        Serializable originalValItem = valsToCheck[0] instanceof AbstractDataTypesCoverageTest.SqlStrConvertedValHolder ? ((AbstractDataTypesCoverageTest.SqlStrConvertedValHolder)valsToCheck[0]).originalVal() : valsToCheck[0];
        BiFunction<Object, Object, Boolean> equalsProcessor = originalValItem instanceof BigDecimal || originalValItem instanceof BigInteger ? Objects::equals : (lhs, rhs) -> EqualsBuilder.reflectionEquals((Object)lhs, (Object)rhs, (boolean)false, lhs.getClass(), (boolean)true, (String[])new String[0]);
        String uuidPostfix = UUID.randomUUID().toString().replaceAll("-", "_");
        String cacheName = "cache" + uuidPostfix;
        String tblName = "table" + uuidPostfix;
        Class<?> dataType = originalValItem.getClass();
        IgniteEx ignite = this.cacheMode == CacheMode.LOCAL || this.writeSyncMode == CacheWriteSynchronizationMode.PRIMARY_SYNC ? this.grid(0) : this.grid(new Random().nextInt(3));
        IgniteCache cache = ignite.createCache(new CacheConfiguration().setName(cacheName).setAtomicityMode(this.atomicityMode).setCacheMode(this.cacheMode).setExpiryPolicyFactory(this.ttlFactory).setBackups(this.backups).setEvictionPolicyFactory(this.evictionFactory).setOnheapCacheEnabled(this.evictionFactory != null || this.onheapCacheEnabled).setWriteSynchronizationMode(this.writeSyncMode).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16)).setQueryEntities(Collections.singletonList(new QueryEntity(dataType, dataType).setTableName(tblName))));
        HashMap<Serializable, Serializable> keyValMap = new HashMap<Serializable, Serializable>();
        for (int i = 0; i < valsToCheck.length; ++i) {
            keyValMap.put(valsToCheck[i], valsToCheck[valsToCheck.length - i - 1]);
        }
        for (Map.Entry keyValEntry : keyValMap.entrySet()) {
            Object sqlStrKey;
            Object originalKey;
            if (keyValEntry.getKey() instanceof AbstractDataTypesCoverageTest.SqlStrConvertedValHolder) {
                originalKey = ((AbstractDataTypesCoverageTest.SqlStrConvertedValHolder)keyValEntry.getKey()).originalVal();
                sqlStrKey = ((AbstractDataTypesCoverageTest.SqlStrConvertedValHolder)keyValEntry.getKey()).sqlStrVal();
            } else {
                originalKey = keyValEntry.getKey();
                sqlStrKey = keyValEntry.getKey();
            }
            Object originalVal = keyValEntry.getValue() instanceof AbstractDataTypesCoverageTest.SqlStrConvertedValHolder ? ((AbstractDataTypesCoverageTest.SqlStrConvertedValHolder)keyValEntry.getValue()).originalVal() : keyValEntry.getValue();
            cache.put(originalKey, originalVal);
            try (PreparedStatement stmt = this.prepareStatement(cacheName, "SELECT * FROM " + tblName);){
                this.checkQuery(converterToSqlExpVal, equalsProcessor, originalVal.getClass(), originalKey, originalVal, stmt);
            }
            if (this.asPreparedParam) {
                stmt = this.prepareStatement(cacheName, "SELECT * FROM " + tblName + " WHERE _key = ?");
                var18_19 = null;
                try {
                    if (originalKey.getClass().isArray()) {
                        stmt.setArray(1, this.conn.createArrayOf("OTHER", (Object[])originalKey));
                    } else {
                        stmt.setObject(1, originalKey);
                    }
                    this.checkQuery(converterToSqlExpVal, equalsProcessor, originalVal.getClass(), originalKey, originalVal, stmt);
                }
                catch (Throwable throwable) {
                    var18_19 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var18_19 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var18_19.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            stmt = this.prepareStatement(cacheName, "SELECT * FROM " + tblName + " WHERE _key = " + sqlStrKey);
            var18_19 = null;
            try {
                this.checkQuery(converterToSqlExpVal, equalsProcessor, originalVal.getClass(), originalKey, originalVal, stmt);
            }
            catch (Throwable throwable) {
                var18_19 = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (var18_19 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            var18_19.addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            this.checkDelete(tblName, (IgniteCache<Object, Object>)cache, originalKey);
        }
    }

    private PreparedStatement prepareStatement(String cacheName, String qry) throws SQLException {
        this.conn = DriverManager.getConnection(this.url);
        this.conn.setSchema('\"' + cacheName + '\"');
        return this.conn.prepareStatement(qry);
    }

    private void checkDelete(String tblName, IgniteCache<Object, Object> cache, Object originalKey) throws IgniteCheckedException, SQLException {
        cache.remove(originalKey);
        try (final PreparedStatement stmt = this.prepareStatement(cache.getName(), "SELECT * FROM " + tblName);){
            try {
                if (this.writeSyncMode == CacheWriteSynchronizationMode.FULL_ASYNC && !GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicateX(){

                    public boolean applyx() throws IgniteCheckedException {
                        try {
                            return !stmt.executeQuery().next();
                        }
                        catch (SQLException e) {
                            throw new IgniteCheckedException((Throwable)e);
                        }
                    }
                }, (long)4000L)) {
                    JdbcThinCacheToJdbcDataTypesCoverageTest.fail((String)"Deleted data are still retrievable via SELECT.");
                }
            }
            catch (GridClosureException e) {
                throw (SQLException)e.getCause().getCause();
            }
            ResultSet rs = stmt.executeQuery();
            JdbcThinCacheToJdbcDataTypesCoverageTest.assertNotNull((Object)rs);
            JdbcThinCacheToJdbcDataTypesCoverageTest.assertFalse((String)"Unexpected rows count.", (boolean)rs.next());
        }
    }

    private void checkQuery(Function converterToSqlExpVal, BiFunction<Object, Object, Boolean> equalsProcessor, Class<?> dataType, Object originalKey, Object originalVal, final PreparedStatement stmt) throws IgniteCheckedException, SQLException {
        try {
            if (this.writeSyncMode == CacheWriteSynchronizationMode.FULL_ASYNC && !GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicateX(){

                public boolean applyx() throws IgniteCheckedException {
                    try {
                        return stmt.executeQuery().next();
                    }
                    catch (SQLException e) {
                        throw new IgniteCheckedException((Throwable)e);
                    }
                }
            }, (long)4000L)) {
                JdbcThinCacheToJdbcDataTypesCoverageTest.fail((String)"Unable to retrieve data via SELECT.");
            }
        }
        catch (GridClosureException e) {
            throw (SQLException)e.getCause().getCause();
        }
        ResultSet rs = stmt.executeQuery();
        JdbcThinCacheToJdbcDataTypesCoverageTest.assertNotNull((Object)rs);
        ResultSetMetaData meta = rs.getMetaData();
        JdbcThinCacheToJdbcDataTypesCoverageTest.assertNotNull((Object)meta);
        IgniteBiTuple<Integer, Class> typeClsPair = javaClsToSqlTypeMap.getOrDefault(dataType, (IgniteBiTuple<Integer, Class>)new IgniteBiTuple((Object)1111, originalVal.getClass()));
        int metaType = (Integer)typeClsPair.get1();
        Object expJavaDataType = typeClsPair.get2();
        JdbcThinCacheToJdbcDataTypesCoverageTest.assertEquals((String)"Unexpected metadata data type name for key.", (int)metaType, (int)meta.getColumnType(1));
        JdbcThinCacheToJdbcDataTypesCoverageTest.assertEquals((String)"Unexpected metadata data type name for value.", (int)metaType, (int)meta.getColumnType(2));
        JdbcThinCacheToJdbcDataTypesCoverageTest.assertEquals((String)"Unexpected columns count.", (int)2, (int)meta.getColumnCount());
        int cnt = 0;
        while (rs.next()) {
            Object gotKey = rs.getObject(1);
            Object gotVal = rs.getObject(2);
            JdbcThinCacheToJdbcDataTypesCoverageTest.assertEquals((String)"Unexpected key data type.", (Object)expJavaDataType, gotKey.getClass());
            JdbcThinCacheToJdbcDataTypesCoverageTest.assertEquals((String)"Unexpected value data type.", (Object)expJavaDataType, gotVal.getClass());
            JdbcThinCacheToJdbcDataTypesCoverageTest.assertTrue((boolean)equalsProcessor.apply(converterToSqlExpVal.apply(originalKey), gotKey));
            JdbcThinCacheToJdbcDataTypesCoverageTest.assertTrue((boolean)equalsProcessor.apply(converterToSqlExpVal.apply(originalVal), gotVal));
            ++cnt;
        }
        JdbcThinCacheToJdbcDataTypesCoverageTest.assertEquals((String)"Unexpected rows count.", (int)1, (int)cnt);
    }

    static {
        HashMap<Class, IgniteBiTuple> innerMap = new HashMap<Class, IgniteBiTuple>();
        innerMap.put(Boolean.class, new IgniteBiTuple((Object)16, Boolean.class));
        innerMap.put(Integer.class, new IgniteBiTuple((Object)4, Integer.class));
        innerMap.put(Byte.class, new IgniteBiTuple((Object)-6, Byte.class));
        innerMap.put(Short.class, new IgniteBiTuple((Object)5, Short.class));
        innerMap.put(Long.class, new IgniteBiTuple((Object)-5, Long.class));
        innerMap.put(BigDecimal.class, new IgniteBiTuple((Object)3, BigDecimal.class));
        innerMap.put(Double.class, new IgniteBiTuple((Object)8, Double.class));
        innerMap.put(Float.class, new IgniteBiTuple((Object)6, Float.class));
        innerMap.put(Time.class, new IgniteBiTuple((Object)92, Time.class));
        innerMap.put(Date.class, new IgniteBiTuple((Object)91, Date.class));
        innerMap.put(Timestamp.class, new IgniteBiTuple((Object)93, Timestamp.class));
        innerMap.put(String.class, new IgniteBiTuple((Object)12, String.class));
        innerMap.put(Character.class, new IgniteBiTuple((Object)1111, Character.class));
        innerMap.put(byte[].class, new IgniteBiTuple((Object)-2, byte[].class));
        innerMap.put(java.util.Date.class, new IgniteBiTuple((Object)93, Timestamp.class));
        innerMap.put(LocalDate.class, new IgniteBiTuple((Object)91, Date.class));
        innerMap.put(LocalDateTime.class, new IgniteBiTuple((Object)93, Timestamp.class));
        innerMap.put(LocalTime.class, new IgniteBiTuple((Object)92, Time.class));
        javaClsToSqlTypeMap = Collections.unmodifiableMap(innerMap);
    }
}

