/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractDmlStatementSelfTest;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.ComparisonFailure;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JdbcThinBulkLoadSelfTest
extends JdbcThinAbstractDmlStatementSelfTest {
    private static final String CSV_FILE_SUBDIR = "/modules/clients/src/test/resources/";
    private static final String TBL_NAME = "Person";
    private static final String BULKLOAD_EMPTY_CSV_FILE = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload0.csv")).getAbsolutePath();
    private static final String BULKLOAD_ONE_LINE_CSV_FILE = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload1.csv")).getAbsolutePath();
    private static final String BULKLOAD_TWO_LINES_CSV_FILE = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload2.csv")).getAbsolutePath();
    private static final String BULKLOAD_UTF8_CSV_FILE = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload2_utf8.csv")).getAbsolutePath();
    private static final String BULKLOAD_CP1251_CSV_FILE = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload2_windows1251.csv")).getAbsolutePath();
    private static final String BULKLOAD_RFC4180_COMMA_CSV_FILE = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload_rfc4180_comma.csv")).getAbsolutePath();
    private static final String BULKLOAD_RFC4180_PIPE_CSV_FILE_ = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload_rfc4180_pipe.csv")).getAbsolutePath();
    private static final String BULKLOAD_ONE_LINE_CSV_FILE_UNMATCHED_QUOTE1 = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload1_unmatched1.csv")).getAbsolutePath();
    private static final String BULKLOAD_ONE_LINE_CSV_FILE_UNMATCHED_QUOTE2 = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload1_unmatched2.csv")).getAbsolutePath();
    private static final String BULKLOAD_ONE_LINE_CSV_FILE_UNMATCHED_QUOTE3 = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload1_unmatched3.csv")).getAbsolutePath();
    private static final String BULKLOAD_ONE_LINE_CSV_FILE_UNMATCHED_QUOTE4 = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload1_unmatched4.csv")).getAbsolutePath();
    private static final String BULKLOAD_ONE_LINE_CSV_FILE_UNMATCHED_QUOTE5 = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload1_unmatched5.csv")).getAbsolutePath();
    private static final String BULKLOAD_THREE_LINE_CSV_FILE_EMPTY_NUMERIC = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload_empty_numeric.csv")).getAbsolutePath();
    private static final String BULKLOAD_WITH_NULL_STRING = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload_empty_numeric_with_null_string.csv")).getAbsolutePath();
    private static final String BULKLOAD_WITH_TRIM_OFF = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload_empty_numeric_with_trim_off.csv")).getAbsolutePath();
    public static final String BASIC_SQL_COPY_STMT = "copy from '" + BULKLOAD_TWO_LINES_CSV_FILE + "' into " + "Person" + " (_key, age, firstName, lastName) format csv";
    private Statement stmt;
    @Parameterized.Parameter(value=0)
    public CacheMode cacheMode;
    @Parameterized.Parameter(value=1)
    public CacheAtomicityMode atomicityMode;
    @Parameterized.Parameter(value=2)
    public Boolean isNear;
    @Parameterized.Parameter(value=3)
    public Boolean serverBulkloadEnabled;

    @Parameterized.Parameters(name="cacheMode={0}, atomicityMode={1}, isNear={2}, serverBulkloadEnabled={3}")
    public static Collection<Object[]> runConfig() {
        return Arrays.asList({CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true, false}, {CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true, true}, {CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false, false}, {CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false, true}, {CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true, false}, {CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true, true}, {CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false, false}, {CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false, true}, {CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false, false}, {CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false, true}, {CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false, false}, {CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false, true});
    }

    @Override
    protected CacheConfiguration cacheConfig() {
        return this.cacheConfigWithIndexedTypes();
    }

    private CacheConfiguration cacheConfigWithIndexedTypes() {
        CacheConfiguration cache = JdbcThinBulkLoadSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(this.cacheMode);
        cache.setAtomicityMode(this.atomicityMode);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        if (this.cacheMode == CacheMode.PARTITIONED) {
            cache.setBackups(1);
        }
        if (this.isNear.booleanValue()) {
            cache.setNearConfiguration(new NearCacheConfiguration());
        }
        cache.setIndexedTypes(new Class[]{String.class, JdbcThinAbstractDmlStatementSelfTest.Person.class});
        return cache;
    }

    @Override
    protected Connection createConnection() throws SQLException {
        String baseConnectionString = "jdbc:ignite:thin://127.0.0.1/";
        if (!this.serverBulkloadEnabled.booleanValue()) {
            return DriverManager.getConnection(baseConnectionString + "?disabledFeatures=SERVER_BULK_LOAD");
        }
        return DriverManager.getConnection(baseConnectionString);
    }

    private CacheConfiguration cacheConfigWithQueryEntity() {
        CacheConfiguration cache = JdbcThinBulkLoadSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        QueryEntity e = new QueryEntity();
        e.setKeyType(String.class.getName());
        e.setValueType(TBL_NAME);
        e.addQueryField("id", Integer.class.getName(), null);
        e.addQueryField("age", Integer.class.getName(), null);
        e.addQueryField("firstName", String.class.getName(), null);
        e.addQueryField("lastName", String.class.getName(), null);
        cache.setQueryEntities(Collections.singletonList(e));
        return cache;
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stmt = this.conn.createStatement();
        JdbcThinBulkLoadSelfTest.assertNotNull((Object)this.stmt);
        JdbcThinBulkLoadSelfTest.assertFalse((boolean)this.stmt.isClosed());
    }

    @Override
    protected void afterTest() throws Exception {
        if (this.stmt != null && !this.stmt.isClosed()) {
            this.stmt.close();
        }
        JdbcThinBulkLoadSelfTest.assertTrue((boolean)this.stmt.isClosed());
        super.afterTest();
    }

    @Test
    public void testBasicStatement() throws SQLException {
        int updatesCnt = this.stmt.executeUpdate(BASIC_SQL_COPY_STMT);
        JdbcThinBulkLoadSelfTest.assertEquals((int)2, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, true, 2);
    }

    @Test
    public void testEmptyFile() throws SQLException {
        int updatesCnt = this.stmt.executeUpdate("copy from '" + BULKLOAD_EMPTY_CSV_FILE + "' into " + TBL_NAME + " (_key, age, firstName, lastName) format csv");
        JdbcThinBulkLoadSelfTest.assertEquals((int)0, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, true, 0);
    }

    @Test
    public void testOneLineFile() throws SQLException {
        int updatesCnt = this.stmt.executeUpdate("copy from '" + BULKLOAD_ONE_LINE_CSV_FILE + "' into " + TBL_NAME + " (_key, age, firstName, lastName) format csv");
        JdbcThinBulkLoadSelfTest.assertEquals((int)1, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, true, 1);
    }

    @Test
    public void testThreeLineFileWithEmptyNumericColumn() throws SQLException {
        int updatesCnt = this.stmt.executeUpdate("copy from '" + BULKLOAD_THREE_LINE_CSV_FILE_EMPTY_NUMERIC + "' into " + TBL_NAME + " (_key, age, firstName, lastName) format csv");
        JdbcThinBulkLoadSelfTest.assertEquals((int)3, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, true, 3);
    }

    @Test
    public void testThreeLineFileWithEmptyNumericColumnWithNullString() throws SQLException {
        int updatesCnt = this.stmt.executeUpdate("copy from '" + BULKLOAD_WITH_NULL_STRING + "' into " + TBL_NAME + " (_key, age, firstName, lastName) format csv nullstring 'a'");
        JdbcThinBulkLoadSelfTest.assertEquals((int)3, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, true, 3);
    }

    @Test
    public void testThreeLineFileWithEmptyNumericColumnWithEmptyNullString() throws SQLException {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from '" + BULKLOAD_WITH_NULL_STRING + "' into " + JdbcThinBulkLoadSelfTest.TBL_NAME + " (_key, age, firstName, lastName) format csv");
                return null;
            }
        }, SQLException.class, (String)"Value conversion failed");
        this.checkCacheContents(TBL_NAME, true, 1);
    }

    @Test
    public void testThreeLineFileWithEmptyNumericColumnWithNullStringAndTrimOff() throws SQLException {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from '" + BULKLOAD_WITH_NULL_STRING + "' into " + JdbcThinBulkLoadSelfTest.TBL_NAME + " (_key, age, firstName, lastName) format csv nullstring 'a' trim off");
                return null;
            }
        }, SQLException.class, (String)"Value conversion failed");
    }

    @Test
    public void testThreeLineFileWithEmptyNumericColumnWithNullStringAndTrimOn() throws SQLException {
        int updatesCnt = this.stmt.executeUpdate("copy from '" + BULKLOAD_WITH_NULL_STRING + "' into " + TBL_NAME + " (_key, age, firstName, lastName) format csv nullstring 'a' trim on");
        JdbcThinBulkLoadSelfTest.assertEquals((int)3, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, true, 3);
    }

    @Test
    public void testThreeLineFileWithEmptyNumericColumnWithTrimOff() throws SQLException {
        int updatesCnt = this.stmt.executeUpdate("copy from '" + BULKLOAD_WITH_TRIM_OFF + "' into " + TBL_NAME + " (_key, age, firstName, lastName) format csv nullstring 'a' trim off");
        JdbcThinBulkLoadSelfTest.assertEquals((int)3, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, true, 3);
    }

    @Test
    public void testThreeLineFileWithEmptyNumericColumnWithTrimOn() throws SQLException {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                int updatesCnt = JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from '" + BULKLOAD_WITH_TRIM_OFF + "' into " + JdbcThinBulkLoadSelfTest.TBL_NAME + " (_key, age, firstName, lastName) format csv nullstring 'a' trim on");
                JdbcThinBulkLoadSelfTest.assertEquals((int)3, (int)updatesCnt);
                JdbcThinBulkLoadSelfTest.this.checkCacheContents(JdbcThinBulkLoadSelfTest.TBL_NAME, true, 3);
                return null;
            }
        }, ComparisonFailure.class, (String)"expected:<[ ]FirstName104");
    }

    @Test
    public void testOneLineFileForUnmatchedStartQuote() throws SQLException {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from '" + BULKLOAD_ONE_LINE_CSV_FILE_UNMATCHED_QUOTE1 + "' into " + JdbcThinBulkLoadSelfTest.TBL_NAME + " (_key, age, firstName, lastName) format csv");
                return null;
            }
        }, SQLException.class, (String)"Unmatched quote found at the end of line");
        this.checkCacheContents(TBL_NAME, true, 0);
    }

    @Test
    public void testOneLineFileForUnmatchedEndQuote() throws SQLException {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from '" + BULKLOAD_ONE_LINE_CSV_FILE_UNMATCHED_QUOTE2 + "' into " + JdbcThinBulkLoadSelfTest.TBL_NAME + " (_key, age, firstName, lastName) format csv");
                return null;
            }
        }, SQLException.class, (String)"Unexpected quote in the field, line");
        this.checkCacheContents(TBL_NAME, true, 0);
    }

    @Test
    public void testOneLineFileForSingleEndQuote() throws SQLException {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from '" + BULKLOAD_ONE_LINE_CSV_FILE_UNMATCHED_QUOTE3 + "' into " + JdbcThinBulkLoadSelfTest.TBL_NAME + " (_key, age, firstName, lastName) format csv");
                return null;
            }
        }, SQLException.class, (String)"Unmatched quote found at the end of line");
        this.checkCacheContents(TBL_NAME, true, 0);
    }

    @Test
    public void testOneLineFileForQuoteInContent() throws SQLException {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from '" + BULKLOAD_ONE_LINE_CSV_FILE_UNMATCHED_QUOTE4 + "' into " + JdbcThinBulkLoadSelfTest.TBL_NAME + " (_key, age, firstName, lastName) format csv");
                return null;
            }
        }, SQLException.class, (String)"Unmatched quote found at the end of line");
        this.checkCacheContents(TBL_NAME, true, 0);
    }

    @Test
    public void testOneLineFileForQuoteInQuotedContent() throws SQLException {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from '" + BULKLOAD_ONE_LINE_CSV_FILE_UNMATCHED_QUOTE5 + "' into " + JdbcThinBulkLoadSelfTest.TBL_NAME + " (_key, age, firstName, lastName) format csv");
                return null;
            }
        }, SQLException.class, (String)"Unexpected quote in the field, line");
        this.checkCacheContents(TBL_NAME, true, 0);
    }

    @Test
    public void testEmptyCharset() {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from 'any.file' into Person (_key, age, firstName, lastName) format csv charset ''");
                return null;
            }
        }, SQLException.class, (String)"Unknown charset name: ''");
    }

    @Test
    public void testNotSupportedCharset() {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from 'any.file' into Person (_key, age, firstName, lastName) format csv charset 'nonexistent'");
                return null;
            }
        }, SQLException.class, (String)"Charset is not supported: 'nonexistent'");
    }

    @Test
    public void testUnknownCharset() {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from 'any.file' into Person (_key, age, firstName, lastName) format csv charset '8^)'");
                return null;
            }
        }, SQLException.class, (String)"Unknown charset name: '8^)'");
    }

    @Test
    public void testAsciiCharset() throws SQLException {
        int updatesCnt = this.stmt.executeUpdate("copy from '" + BULKLOAD_TWO_LINES_CSV_FILE + "' into " + TBL_NAME + " (_key, age, firstName, lastName) format csv charset 'ascii'");
        JdbcThinBulkLoadSelfTest.assertEquals((int)2, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, true, 2);
    }

    @Test
    public void testCsvLoadWithDefaultDelimiter() throws SQLException {
        int updatesCnt = this.stmt.executeUpdate("copy from '" + BULKLOAD_RFC4180_COMMA_CSV_FILE + "' into " + TBL_NAME + " (_key, age, firstName, lastName) format csv");
        JdbcThinBulkLoadSelfTest.assertEquals((int)7, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, true, 7);
    }

    @Test
    public void testCsvLoadWithCommaDelimiter() throws SQLException {
        int updatesCnt = this.stmt.executeUpdate("copy from '" + BULKLOAD_RFC4180_COMMA_CSV_FILE + "' into " + TBL_NAME + " (_key, age, firstName, lastName) format csv delimiter ','");
        JdbcThinBulkLoadSelfTest.assertEquals((int)7, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, true, 7, ',');
    }

    @Test
    public void testCsvLoadWithPipeDelimiter() throws SQLException {
        int updatesCnt = this.stmt.executeUpdate("copy from '" + BULKLOAD_RFC4180_PIPE_CSV_FILE_ + "' into " + TBL_NAME + " (_key, age, firstName, lastName) format csv delimiter '|'");
        JdbcThinBulkLoadSelfTest.assertEquals((int)7, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, true, 7, '|');
    }

    @Test
    public void testUtf8Charset() throws SQLException {
        this.checkBulkLoadWithCharset(BULKLOAD_UTF8_CSV_FILE, "utf-8");
    }

    @Test
    public void testWin1251Charset() throws SQLException {
        this.checkBulkLoadWithCharset(BULKLOAD_CP1251_CSV_FILE, "windows-1251");
    }

    private void checkBulkLoadWithCharset(String fileName, String charsetName) throws SQLException {
        int updatesCnt = this.stmt.executeUpdate("copy from '" + fileName + "' into " + TBL_NAME + " (_key, age, firstName, lastName) format csv charset '" + charsetName + "'");
        JdbcThinBulkLoadSelfTest.assertEquals((int)2, (int)updatesCnt);
        this.checkNationalCacheContents(TBL_NAME);
    }

    @Test
    public void testWrongCharset_Utf8AsWin1251() throws SQLException {
        this.checkBulkLoadWithWrongCharset(BULKLOAD_UTF8_CSV_FILE, "UTF-8", "windows-1251");
    }

    @Test
    public void testWrongCharset_Win1251AsUtf8() throws SQLException {
        this.checkBulkLoadWithWrongCharset(BULKLOAD_CP1251_CSV_FILE, "windows-1251", "UTF-8");
    }

    @Test
    public void testWrongCharset_Utf8AsAscii() throws SQLException {
        this.checkBulkLoadWithWrongCharset(BULKLOAD_UTF8_CSV_FILE, "UTF-8", "ascii");
    }

    @Test
    public void testWrongCharset_Win1251AsAscii() throws SQLException {
        this.checkBulkLoadWithWrongCharset(BULKLOAD_CP1251_CSV_FILE, "windows-1251", "ascii");
    }

    @Test
    public void testPacketSize_1() throws SQLException {
        int updatesCnt = this.stmt.executeUpdate(BASIC_SQL_COPY_STMT + " packet_size 1");
        JdbcThinBulkLoadSelfTest.assertEquals((int)2, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, true, 2);
    }

    @Test
    public void testDefaultCharset() throws SQLException {
        int updatesCnt = this.stmt.executeUpdate("copy from '" + BULKLOAD_UTF8_CSV_FILE + "' into " + TBL_NAME + " (_key, age, firstName, lastName) format csv");
        JdbcThinBulkLoadSelfTest.assertEquals((int)2, (int)updatesCnt);
        this.checkNationalCacheContents(TBL_NAME);
    }

    @Test
    public void testBulkLoadToNonAffinityNode() throws Exception {
        IgniteEx client = this.startGrid(this.getConfiguration("client").setClientMode(true));
        try (Connection con = this.connect(client, null);){
            con.setSchema("\"default\"");
            try (Statement stmt = con.createStatement();){
                int updatesCnt = stmt.executeUpdate("copy from '" + BULKLOAD_UTF8_CSV_FILE + "' into " + TBL_NAME + " (_key, age, firstName, lastName) format csv");
                JdbcThinBulkLoadSelfTest.assertEquals((int)2, (int)updatesCnt);
                this.checkNationalCacheContents(TBL_NAME);
            }
        }
        this.stopGrid(client.name());
    }

    @Test
    public void testDefaultCharsetPacketSize1() throws SQLException {
        int updatesCnt = this.stmt.executeUpdate("copy from '" + BULKLOAD_UTF8_CSV_FILE + "' into " + TBL_NAME + " (_key, age, firstName, lastName) format csv packet_size 1");
        JdbcThinBulkLoadSelfTest.assertEquals((int)2, (int)updatesCnt);
        this.checkNationalCacheContents(TBL_NAME);
    }

    @Test
    public void testWrongFileName() {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from 'nonexistent' into Person (_key, age, firstName, lastName) format csv");
                return null;
            }
        }, SQLException.class, (String)"Failed to read file: 'nonexistent'");
    }

    @Test
    public void testMissingTable() {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from '" + BULKLOAD_TWO_LINES_CSV_FILE + "' into Peterson (_key, age, firstName, lastName) format csv");
                return null;
            }
        }, SQLException.class, (String)"Table does not exist: PETERSON");
    }

    @Test
    public void testWrongColumnName() {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from '" + BULKLOAD_TWO_LINES_CSV_FILE + "' into Person (_key, age, firstName, lostName) format csv");
                return null;
            }
        }, SQLException.class, (String)"Column \"LOSTNAME\" not found");
    }

    @Test
    public void testWrongColumnType() {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from '" + BULKLOAD_TWO_LINES_CSV_FILE + "' into Person (_key, firstName, age, lastName) format csv");
                return null;
            }
        }, SQLException.class, (String)"Value conversion failed [column=AGE, from=java.lang.String, to=java.lang.Integer]");
    }

    @Test
    public void testFieldsSubset() throws SQLException {
        int updatesCnt = this.stmt.executeUpdate("copy from '" + BULKLOAD_TWO_LINES_CSV_FILE + "' into " + TBL_NAME + " (_key, age, firstName) format csv");
        JdbcThinBulkLoadSelfTest.assertEquals((int)2, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, false, 2);
    }

    @Test
    public void testCreateAndBulkLoadTable() throws SQLException {
        String tblName = "PUBLIC.\"PersonTbl\"";
        this.execute(this.conn, "create table " + tblName + " (id int primary key, age int, firstName varchar(30), lastName varchar(30))", new Object[0]);
        try {
            int updatesCnt = this.stmt.executeUpdate("copy from '" + BULKLOAD_TWO_LINES_CSV_FILE + "' into " + tblName + "(_key, age, firstName, lastName) format csv");
            JdbcThinBulkLoadSelfTest.assertEquals((int)2, (int)updatesCnt);
            this.checkCacheContents(tblName, true, 2);
        }
        finally {
            this.execute(this.conn, "drop table " + tblName, new Object[0]);
        }
    }

    @Test
    public void testConfigureQueryEntityAndBulkLoad() throws SQLException {
        this.ignite(0).getOrCreateCache(this.cacheConfigWithQueryEntity());
        int updatesCnt = this.stmt.executeUpdate(BASIC_SQL_COPY_STMT);
        JdbcThinBulkLoadSelfTest.assertEquals((int)2, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, true, 2);
    }

    @Test
    public void testMultipleStatement() throws SQLException {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.addBatch(BASIC_SQL_COPY_STMT);
                JdbcThinBulkLoadSelfTest.this.stmt.addBatch("copy from '" + BULKLOAD_ONE_LINE_CSV_FILE + "' into " + JdbcThinBulkLoadSelfTest.TBL_NAME + " (_key, age, firstName, lastName) format csv");
                JdbcThinBulkLoadSelfTest.this.stmt.addBatch("copy from '" + BULKLOAD_UTF8_CSV_FILE + "' into " + JdbcThinBulkLoadSelfTest.TBL_NAME + " (_key, age, firstName, lastName) format csv");
                JdbcThinBulkLoadSelfTest.this.stmt.executeBatch();
                return null;
            }
        }, BatchUpdateException.class, (String)"COPY command cannot be executed in batch mode.");
    }

    @Test
    public void testExecuteQuery() throws SQLException {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeQuery(BASIC_SQL_COPY_STMT);
                return null;
            }
        }, SQLException.class, (String)"Given statement type does not match that declared by JDBC driver");
    }

    @Test
    public void testExecute() throws SQLException {
        boolean isRowSet = this.stmt.execute(BASIC_SQL_COPY_STMT);
        JdbcThinBulkLoadSelfTest.assertFalse((boolean)isRowSet);
        this.checkCacheContents(TBL_NAME, true, 2);
    }

    @Test
    public void testPreparedStatementWithExecuteUpdate() throws SQLException {
        PreparedStatement pstmt = this.conn.prepareStatement(BASIC_SQL_COPY_STMT);
        int updatesCnt = pstmt.executeUpdate();
        JdbcThinBulkLoadSelfTest.assertEquals((int)2, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, true, 2);
    }

    @Test
    public void testPreparedStatementWithParameter() throws SQLException {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                PreparedStatement pstmt = JdbcThinBulkLoadSelfTest.this.conn.prepareStatement("copy from '" + BULKLOAD_TWO_LINES_CSV_FILE + "' into " + JdbcThinBulkLoadSelfTest.TBL_NAME + " (_key, age, firstName, lastName) format ?");
                pstmt.setString(1, "csv");
                pstmt.executeUpdate();
                return null;
            }
        }, SQLException.class, (String)"Unexpected token: \"?\" (expected: \"[identifier]\"");
    }

    @Test
    public void testPreparedStatementWithExecute() throws SQLException {
        PreparedStatement pstmt = this.conn.prepareStatement(BASIC_SQL_COPY_STMT);
        boolean isRowSet = pstmt.execute();
        JdbcThinBulkLoadSelfTest.assertFalse((boolean)isRowSet);
        this.checkCacheContents(TBL_NAME, true, 2);
    }

    @Test
    public void testPreparedStatementWithExecuteQuery() {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                PreparedStatement pstmt = JdbcThinBulkLoadSelfTest.this.conn.prepareStatement(BASIC_SQL_COPY_STMT);
                pstmt.executeQuery();
                return null;
            }
        }, SQLException.class, (String)"Given statement type does not match that declared by JDBC driver");
    }

    @Test
    public void testExportIsNotSupportedInCommunityEdition() {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from Person (_key, age, firstName, lastName) into '/path/any.file' format csv");
                return null;
            }
        }, SQLException.class, (String)"To use export feature, enable gridgain-bulkload module (requires Enterprise or Ultimate Edition)");
    }

    @Test
    public void testParquetNotSupportedInCommunityEdition() {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from '/path/any.file' into Person(_key, age, firstName, lastName) format parquet");
                return null;
            }
        }, SQLException.class, (String)"To use Parquet format, enable gridgain-bulkload module (requires Enterprise or Ultimate Edition)");
    }

    @Test
    public void testIcebergNotSupportedInCommunityEdition() {
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinBulkLoadSelfTest.this.stmt.executeUpdate("copy from '/path/any.file' into Person(_key, age, firstName, lastName) format iceberg");
                return null;
            }
        }, SQLException.class, (String)"To use Iceberg format, enable gridgain-bulkload module (requires Enterprise or Ultimate Edition)");
    }

    private void checkCacheContents(String tblName, boolean checkLastName, int recCnt) throws SQLException {
        this.checkCacheContents(tblName, checkLastName, recCnt, ',');
    }

    private void checkCacheContents(String tblName, boolean checkLastName, int recCnt, char delimiter) throws SQLException {
        ResultSet rs = this.stmt.executeQuery("select _key, age, firstName, lastName from " + tblName);
        assert (rs != null);
        int cnt = 0;
        while (rs.next()) {
            int id = rs.getInt("_key");
            SyntheticPerson sp = new SyntheticPerson(rs.getInt("age"), rs.getString("firstName"), rs.getString("lastName"));
            if (id == 101) {
                sp.validateValues(0, "FirstName101 MiddleName101", "LastName101", checkLastName);
            } else if (id == 102) {
                sp.validateValues(0, "FirstName102 MiddleName102", "LastName102", checkLastName);
            } else if (id == 103) {
                sp.validateValues(0, "FirstName103 MiddleName103", "LastName103", checkLastName);
            } else if (id == 104) {
                sp.validateValues(0, " FirstName104 MiddleName104", "LastName104", checkLastName);
            } else if (id == 123) {
                sp.validateValues(12, "FirstName123 MiddleName123", "LastName123", checkLastName);
            } else if (id == 234) {
                sp.validateValues(23, "FirstName|234", null, checkLastName);
            } else if (id == 345) {
                sp.validateValues(34, "FirstName,345", null, checkLastName);
            } else if (id == 456) {
                sp.validateValues(45, "FirstName456", "LastName456", checkLastName);
            } else if (id == 567) {
                sp.validateValues(56, null, null, checkLastName);
            } else if (id == 678) {
                sp.validateValues(67, null, null, checkLastName);
            } else if (id == 789) {
                sp.validateValues(78, "FirstName789 plus \"quoted\"", "LastName 789", checkLastName);
            } else if (id == 101112) {
                sp.validateValues(1011, "FirstName 101112", "LastName\"" + delimiter + "\" 1011" + delimiter + " 12", checkLastName);
            } else {
                JdbcThinBulkLoadSelfTest.fail((String)("Wrong ID: " + id));
            }
            ++cnt;
        }
        JdbcThinBulkLoadSelfTest.assertEquals((int)recCnt, (int)cnt);
    }

    private void checkNationalCacheContents(String tblName) throws SQLException {
        this.checkRecodedNationalCacheContents(tblName, null, null);
    }

    private void checkRecodedNationalCacheContents(String tblName, String csvCharsetName, String stmtCharsetName) throws SQLException {
        assert (csvCharsetName != null == (stmtCharsetName != null));
        ResultSet rs = this.stmt.executeQuery("select _key, age, firstName, lastName from " + tblName);
        assert (rs != null);
        WrongCharsetRecoder recoder = csvCharsetName != null ? new WrongCharsetRecoder(csvCharsetName, stmtCharsetName) : new IgniteClosure<String, String>(){

            public String apply(String input) {
                return input;
            }
        };
        int cnt = 0;
        while (rs.next()) {
            int id = rs.getInt("_key");
            if (id == 123) {
                JdbcThinBulkLoadSelfTest.assertEquals((int)12, (int)rs.getInt("age"));
                JdbcThinBulkLoadSelfTest.assertEquals((String)((String)recoder.apply("\u0418\u043c\u044f123 \u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e123")), (String)rs.getString("firstName"));
                JdbcThinBulkLoadSelfTest.assertEquals((String)((String)recoder.apply("\u0424\u0430\u043c\u0438\u043b\u0438\u044f123")), (String)rs.getString("lastName"));
            } else if (id == 456) {
                JdbcThinBulkLoadSelfTest.assertEquals((int)45, (int)rs.getInt("age"));
                JdbcThinBulkLoadSelfTest.assertEquals((String)((String)recoder.apply("\u0418\u043c\u044f456")), (String)rs.getString("firstName"));
                JdbcThinBulkLoadSelfTest.assertEquals((String)((String)recoder.apply("\u0424\u0430\u043c\u0438\u043b\u0438\u044f456")), (String)rs.getString("lastName"));
            } else {
                JdbcThinBulkLoadSelfTest.fail((String)("Wrong ID: " + id));
            }
            ++cnt;
        }
        JdbcThinBulkLoadSelfTest.assertEquals((int)2, (int)cnt);
    }

    private void checkBulkLoadWithWrongCharset(String csvFileName, String csvCharsetName, String stmtCharsetName) throws SQLException {
        int updatesCnt = this.stmt.executeUpdate("copy from '" + csvFileName + "' into " + TBL_NAME + " (_key, age, firstName, lastName) format csv charset '" + stmtCharsetName + "'");
        JdbcThinBulkLoadSelfTest.assertEquals((int)2, (int)updatesCnt);
        this.checkRecodedNationalCacheContents(TBL_NAME, csvCharsetName, stmtCharsetName);
    }

    private class SyntheticPerson {
        int age;
        String firstName;
        String lastName;

        public SyntheticPerson(int age, String firstName, String lastName) {
            this.age = age;
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public void validateValues(int age, String firstName, String lastName, boolean checkLastName) {
            JdbcThinBulkLoadSelfTest.assertEquals((int)age, (int)this.age);
            JdbcThinBulkLoadSelfTest.assertEquals((String)firstName, (String)this.firstName);
            if (checkLastName) {
                JdbcThinBulkLoadSelfTest.assertEquals((String)lastName, (String)this.lastName);
            }
        }
    }

    private static class WrongCharsetRecoder
    implements IgniteClosure<String, String> {
        private final Charset actualCharset;
        private final Charset appliedCharset;

        WrongCharsetRecoder(String actualCharset, String appliedCharset) {
            this.actualCharset = Charset.forName(actualCharset);
            this.appliedCharset = Charset.forName(appliedCharset);
        }

        public String apply(String input) {
            ByteBuffer encodedBuf = this.actualCharset.encode(input);
            return this.appliedCharset.decode(encodedBuf).toString();
        }
    }
}

