/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcVersionMismatchSelfTest
extends GridCommonAbstractTest {
    protected void beforeTest() throws Exception {
        this.startGrid();
        try (Connection conn = this.connect();){
            JdbcVersionMismatchSelfTest.executeUpdate(conn, "CREATE TABLE test (a INT PRIMARY KEY, b INT, c VARCHAR) WITH \"atomicity=TRANSACTIONAL_SNAPSHOT, cache_name=TEST\"");
            JdbcVersionMismatchSelfTest.executeUpdate(conn, "INSERT INTO test VALUES (1, 1, 'test_1')");
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testVersionMismatchJdbc() throws Exception {
        try (Connection conn1 = this.connect();
             Connection conn2 = this.connect();){
            conn1.setAutoCommit(false);
            conn2.setAutoCommit(false);
            JdbcVersionMismatchSelfTest.assertEquals((int)1, (int)JdbcVersionMismatchSelfTest.executeQuery(conn1, "SELECT * FROM test").size());
            JdbcVersionMismatchSelfTest.executeUpdate(conn2, "INSERT INTO test VALUES (2, 2, 'test_2')");
            JdbcVersionMismatchSelfTest.executeUpdate(conn2, "COMMIT");
            JdbcVersionMismatchSelfTest.assertEquals((int)2, (int)JdbcVersionMismatchSelfTest.executeQuery(conn2, "SELECT * FROM test").size());
            try {
                JdbcVersionMismatchSelfTest.executeUpdate(conn1, "INSERT INTO test VALUES (2, 2, 'test_2')");
                JdbcVersionMismatchSelfTest.fail();
            }
            catch (SQLException e) {
                JdbcVersionMismatchSelfTest.assertEquals((String)"40001", (String)e.getSQLState());
                JdbcVersionMismatchSelfTest.assertEquals((int)5005, (int)e.getErrorCode());
                JdbcVersionMismatchSelfTest.assertNotNull((Object)e.getMessage());
                JdbcVersionMismatchSelfTest.assertTrue((boolean)e.getMessage().contains("Cannot serialize transaction due to write conflict"));
            }
            try {
                JdbcVersionMismatchSelfTest.executeQuery(conn1, "SELECT * FROM test").size();
                JdbcVersionMismatchSelfTest.fail();
            }
            catch (SQLException e) {
                JdbcVersionMismatchSelfTest.assertEquals((String)"25000", (String)e.getSQLState());
                JdbcVersionMismatchSelfTest.assertEquals((int)5004, (int)e.getErrorCode());
                JdbcVersionMismatchSelfTest.assertNotNull((Object)e.getMessage());
                JdbcVersionMismatchSelfTest.assertTrue((boolean)e.getMessage().contains("Transaction is already completed"));
            }
            try {
                conn1.commit();
                JdbcVersionMismatchSelfTest.fail();
            }
            catch (SQLException e) {
                JdbcVersionMismatchSelfTest.assertEquals((String)"50000", (String)e.getSQLState());
                JdbcVersionMismatchSelfTest.assertEquals((int)1, (int)e.getErrorCode());
                JdbcVersionMismatchSelfTest.assertNotNull((Object)e.getMessage());
                JdbcVersionMismatchSelfTest.assertTrue((boolean)e.getMessage().contains("Failed to finish transaction because it has been rolled back"));
            }
            conn1.rollback();
            JdbcVersionMismatchSelfTest.assertEquals((int)2, (int)JdbcVersionMismatchSelfTest.executeQuery(conn2, "SELECT * FROM test").size());
        }
    }

    private Connection connect() throws Exception {
        return DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800");
    }

    private static void executeUpdate(Connection conn, String sql) throws Exception {
        try (Statement stmt = conn.createStatement();){
            stmt.executeUpdate(sql);
        }
    }

    private static List<List<Object>> executeQuery(Connection conn, String sql) throws Exception {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            int colCnt = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                ArrayList<Object> row = new ArrayList<Object>(colCnt);
                for (int i = 0; i < colCnt; ++i) {
                    row.add(rs.getObject(i + 1));
                }
                rows.add(row);
            }
        }
        return rows;
    }
}

