/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcPreparedStatementSelfTest
extends GridCommonAbstractTest {
    private static final String URL = "jdbc:ignite://127.0.0.1/";
    private Connection conn;
    private PreparedStatement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcPreparedStatementSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{Integer.class, TestObject.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
        IgniteCache cache = this.grid(0).cache("default");
        assert (cache != null);
        TestObject o = new TestObject(1);
        o.boolVal = true;
        o.byteVal = (byte)1;
        o.shortVal = (short)1;
        o.intVal = 1;
        o.longVal = 1L;
        o.floatVal = Float.valueOf(1.0f);
        o.doubleVal = 1.0;
        o.bigVal = new BigDecimal(1);
        o.strVal = "str";
        TestObject.access$1002(o, new byte[]{1});
        o.dateVal = new Date(1L);
        o.timeVal = new Time(1L);
        o.tsVal = new Timestamp(1L);
        o.urlVal = new URL("http://abc.com/");
        cache.put((Object)1, (Object)o);
        cache.put((Object)2, (Object)new TestObject(2));
    }

    protected void beforeTest() throws Exception {
        this.conn = DriverManager.getConnection(URL);
        assert (this.conn != null);
        assert (!this.conn.isClosed());
    }

    protected void afterTest() throws Exception {
        if (this.stmt != null) {
            this.stmt.close();
            assert (this.stmt.isClosed());
        }
        if (this.conn != null) {
            this.conn.close();
            assert (this.conn.isClosed());
        }
    }

    @Test
    public void testRepeatableUsage() throws Exception {
        this.stmt = this.conn.prepareStatement("select * from TestObject where id = ?");
        this.stmt.setInt(1, 1);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                JdbcPreparedStatementSelfTest.assertEquals((int)1, (int)rs.getInt(1));
            }
            ++cnt;
        }
        JdbcPreparedStatementSelfTest.assertEquals((int)1, (int)cnt);
        cnt = 0;
        rs = this.stmt.executeQuery();
        while (rs.next()) {
            if (cnt == 0) {
                JdbcPreparedStatementSelfTest.assertEquals((int)1, (int)rs.getInt(1));
            }
            ++cnt;
        }
        JdbcPreparedStatementSelfTest.assertEquals((int)1, (int)cnt);
    }

    @Test
    public void testBoolean() throws Exception {
        this.stmt = this.conn.prepareStatement("select * from TestObject where boolVal is not distinct from ?");
        this.stmt.setBoolean(1, true);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 16);
        rs = this.stmt.executeQuery();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testByte() throws Exception {
        this.stmt = this.conn.prepareStatement("select * from TestObject where byteVal is not distinct from ?");
        this.stmt.setByte(1, (byte)1);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, -6);
        rs = this.stmt.executeQuery();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testShort() throws Exception {
        this.stmt = this.conn.prepareStatement("select * from TestObject where shortVal is not distinct from ?");
        this.stmt.setShort(1, (short)1);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 5);
        rs = this.stmt.executeQuery();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testInteger() throws Exception {
        this.stmt = this.conn.prepareStatement("select * from TestObject where intVal is not distinct from ?");
        this.stmt.setInt(1, 1);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 4);
        rs = this.stmt.executeQuery();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testLong() throws Exception {
        this.stmt = this.conn.prepareStatement("select * from TestObject where longVal is not distinct from ?");
        this.stmt.setLong(1, 1L);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, -5);
        rs = this.stmt.executeQuery();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testFloat() throws Exception {
        this.stmt = this.conn.prepareStatement("select * from TestObject where floatVal is not distinct from ?");
        this.stmt.setFloat(1, 1.0f);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 6);
        rs = this.stmt.executeQuery();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testDouble() throws Exception {
        this.stmt = this.conn.prepareStatement("select * from TestObject where doubleVal is not distinct from ?");
        this.stmt.setDouble(1, 1.0);
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 8);
        rs = this.stmt.executeQuery();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testBigDecimal() throws Exception {
        this.stmt = this.conn.prepareStatement("select * from TestObject where bigVal is not distinct from ?");
        this.stmt.setBigDecimal(1, new BigDecimal(1));
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 1111);
        rs = this.stmt.executeQuery();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testString() throws Exception {
        this.stmt = this.conn.prepareStatement("select * from TestObject where strVal is not distinct from ?");
        this.stmt.setString(1, "str");
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 12);
        rs = this.stmt.executeQuery();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testArray() throws Exception {
        this.stmt = this.conn.prepareStatement("select * from TestObject where arrVal is not distinct from ?");
        this.stmt.setBytes(1, new byte[]{1});
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, -2);
        rs = this.stmt.executeQuery();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testDate() throws Exception {
        this.stmt = this.conn.prepareStatement("select * from TestObject where dateVal is not distinct from ?");
        this.stmt.setObject(1, new Date(1L));
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 91);
        rs = this.stmt.executeQuery();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testTime() throws Exception {
        this.stmt = this.conn.prepareStatement("select * from TestObject where timeVal is not distinct from ?");
        this.stmt.setTime(1, new Time(1L));
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 92);
        rs = this.stmt.executeQuery();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testTimestamp() throws Exception {
        this.stmt = this.conn.prepareStatement("select * from TestObject where tsVal is not distinct from ?");
        this.stmt.setTimestamp(1, new Timestamp(1L));
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 93);
        rs = this.stmt.executeQuery();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    @Test
    public void testUrl() throws Exception {
        this.stmt = this.conn.prepareStatement("select * from TestObject where urlVal is not distinct from ?");
        this.stmt.setURL(1, new URL("http://abc.com/"));
        ResultSet rs = this.stmt.executeQuery();
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 1);
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setNull(1, 70);
        rs = this.stmt.executeQuery();
        cnt = 0;
        while (rs.next()) {
            if (cnt == 0) assert (rs.getInt("id") == 2);
            ++cnt;
        }
        assert (cnt == 1);
    }

    private static class TestObject
    implements Serializable {
        @QuerySqlField(index=false)
        private final int id;
        @QuerySqlField
        private Boolean boolVal;
        @QuerySqlField
        private Byte byteVal;
        @QuerySqlField
        private Short shortVal;
        @QuerySqlField
        private Integer intVal;
        @QuerySqlField
        private Long longVal;
        @QuerySqlField
        private Float floatVal;
        @QuerySqlField
        private Double doubleVal;
        @QuerySqlField
        private BigDecimal bigVal;
        @QuerySqlField
        private String strVal;
        @QuerySqlField
        private byte[] arrVal;
        @QuerySqlField
        private Date dateVal;
        @QuerySqlField
        private Time timeVal;
        @QuerySqlField
        private Timestamp tsVal;
        @QuerySqlField
        private URL urlVal;

        private TestObject(int id) {
            this.id = id;
        }

        static /* synthetic */ byte[] access$1002(TestObject x0, byte[] x1) {
            x0.arrVal = x1;
            return x1;
        }
    }
}

