/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class JdbcNoDefaultCacheTest
extends GridCommonAbstractTest {
    private static final String CACHE1_NAME = "cache1";
    private static final String CACHE2_NAME = "cache2";
    private static final String URL = "jdbc:ignite://127.0.0.1/";
    private static final int GRID_CNT = 2;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration(CACHE1_NAME), this.cacheConfiguration(CACHE2_NAME)});
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String name) throws Exception {
        CacheConfiguration cfg = JdbcNoDefaultCacheTest.defaultCacheConfiguration();
        cfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        cfg.setName(name);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(2);
        IgniteEx ignite = this.ignite(0);
        IgniteCache cache1 = ignite.cache(CACHE1_NAME);
        IgniteCache cache2 = ignite.cache(CACHE2_NAME);
        for (int i = 0; i < 10; ++i) {
            cache1.put((Object)i, (Object)(i * 2));
            cache2.put((Object)i, (Object)(i * 3));
        }
    }

    protected String getUrl() {
        return URL;
    }

    @Test
    public void testDefaults() throws Exception {
        String url = this.getUrl();
        try (Connection conn = DriverManager.getConnection(url);){
            JdbcNoDefaultCacheTest.assertNotNull((Object)conn);
        }
        conn = DriverManager.getConnection(url + '/');
        var3_3 = null;
        try {
            JdbcNoDefaultCacheTest.assertNotNull((Object)conn);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testNoCacheNameQuery() throws Exception {
        try (Connection conn = DriverManager.getConnection(this.getUrl());){
            Statement stmt = conn.createStatement();
            JdbcNoDefaultCacheTest.assertNotNull((Object)stmt);
            JdbcNoDefaultCacheTest.assertFalse((boolean)stmt.isClosed());
            stmt.execute("select t._key, t._val from \"cache1\".Integer t");
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                JdbcNoDefaultCacheTest.assertEquals((int)rs.getInt(2), (int)(rs.getInt(1) * 2));
            }
            stmt.execute("select t._key, t._val from \"cache2\".Integer t");
            rs = stmt.getResultSet();
            while (rs.next()) {
                JdbcNoDefaultCacheTest.assertEquals((int)rs.getInt(2), (int)(rs.getInt(1) * 3));
            }
            stmt.execute("select t._key, t._val, v._val from \"cache1\".Integer t join \"cache2\".Integer v on t._key = v._key");
            rs = stmt.getResultSet();
            while (rs.next()) {
                JdbcNoDefaultCacheTest.assertEquals((int)rs.getInt(2), (int)(rs.getInt(1) * 2));
                JdbcNoDefaultCacheTest.assertEquals((int)rs.getInt(3), (int)(rs.getInt(1) * 3));
            }
            stmt.close();
        }
    }
}

