/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class JdbcConnectionSelfTest
extends GridCommonAbstractTest {
    private static final String CUSTOM_CACHE_NAME = "custom-cache";
    private static final int CUSTOM_PORT = 11212;
    private static final String URL_PREFIX = "jdbc:ignite://";
    private static final String HOST = "127.0.0.1";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("default"), this.cacheConfiguration(CUSTOM_CACHE_NAME)});
        assert (cfg.getConnectorConfiguration() == null);
        ConnectorConfiguration clientCfg = new ConnectorConfiguration();
        if (!igniteInstanceName.endsWith("0")) {
            clientCfg.setPort(11212);
        }
        cfg.setConnectorConfiguration(clientCfg);
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String name) throws Exception {
        CacheConfiguration cfg = JdbcConnectionSelfTest.defaultCacheConfiguration();
        cfg.setName(name);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(2);
    }

    @Test
    public void testDefaults() throws Exception {
        String url = "jdbc:ignite://127.0.0.1";
        assert (DriverManager.getConnection(url) != null);
        assert (DriverManager.getConnection(url + "/") != null);
    }

    @Test
    public void testNodeId() throws Exception {
        String url = "jdbc:ignite://127.0.0.1/?nodeId=" + this.grid(0).localNode().id();
        assert (DriverManager.getConnection(url) != null);
        url = "jdbc:ignite://127.0.0.1/custom-cache?nodeId=" + this.grid(0).localNode().id();
        assert (DriverManager.getConnection(url) != null);
    }

    @Test
    public void testCustomCache() throws Exception {
        String url = "jdbc:ignite://127.0.0.1/custom-cache";
        assert (DriverManager.getConnection(url) != null);
    }

    @Test
    public void testCustomPort() throws Exception {
        String url = "jdbc:ignite://127.0.0.1:11212";
        assert (DriverManager.getConnection(url) != null);
        assert (DriverManager.getConnection(url + "/") != null);
    }

    @Test
    public void testCustomCacheNameAndPort() throws Exception {
        String url = "jdbc:ignite://127.0.0.1:11212/custom-cache";
        assert (DriverManager.getConnection(url) != null);
    }

    @Test
    public void testWrongCache() throws Exception {
        String url = "jdbc:ignite://127.0.0.1/wrongCacheName";
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DriverManager.getConnection("jdbc:ignite://127.0.0.1/wrongCacheName");
                return null;
            }
        }, SQLException.class, (String)"Client is invalid. Probably cache name is wrong.");
    }

    @Test
    public void testWrongPort() throws Exception {
        String url = "jdbc:ignite://127.0.0.1:33333";
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DriverManager.getConnection("jdbc:ignite://127.0.0.1:33333");
                return null;
            }
        }, SQLException.class, (String)"Failed to establish connection.");
    }

    @Test
    public void testClose() throws Exception {
        String url = "jdbc:ignite://127.0.0.1";
        final Connection conn = DriverManager.getConnection(url);
        assert (conn != null);
        assert (!conn.isClosed());
        conn.close();
        assert (conn.isClosed());
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                conn.isValid(2);
                return null;
            }
        }, SQLException.class, (String)"Connection is closed.");
    }
}

