/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.processors.authentication.IgniteAccessControlException;
import org.apache.ignite.internal.processors.authentication.IgniteAuthenticationProcessor;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.JettyRestProcessorUnsignedSelfTest;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public abstract class JettyRestProcessorAuthenticationAbstractTest
extends JettyRestProcessorUnsignedSelfTest {
    protected static final String DFLT_USER = "ignite";
    protected static final String DFLT_PWD = "ignite";

    @Override
    protected void beforeTestsStarted() throws Exception {
        U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db", (boolean)true);
        super.beforeTestsStarted();
    }

    @Override
    protected boolean securityEnabled() {
        return true;
    }

    @Override
    protected void initCache() {
        this.grid(0).cluster().active(true);
        super.initCache();
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setAuthenticationEnabled(true);
        DataStorageConfiguration dsCfg = cfg.getDataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L)).setWalMode(WALMode.NONE);
        DataRegionConfiguration testDataRegionCfg = new DataRegionConfiguration();
        testDataRegionCfg.setName("testDataRegion");
        testDataRegionCfg.setMaxSize(0x1200000L);
        DataRegionConfiguration authDataRegionCfg = new DataRegionConfiguration();
        authDataRegionCfg.setName("authDataRegion").setMaxSize(0x1200000L).setPersistenceEnabled(true);
        dsCfg.setDataRegionConfigurations(new DataRegionConfiguration[]{testDataRegionCfg, authDataRegionCfg});
        cfg.setDataStorageConfiguration(dsCfg);
        return cfg;
    }

    @Test
    public void testAuthenticationCommand() throws Exception {
        String ret = this.content(null, GridRestCommand.AUTHENTICATE, new String[0]);
        this.assertResponseSucceeded(ret, false);
    }

    @Test
    public void testAddUpdateRemoveUser() throws Exception {
        String ret = this.content(null, GridRestCommand.ADD_USER, "user", "user1", "password", "password1");
        JsonNode res = this.validateJsonResponse(ret);
        JettyRestProcessorAuthenticationAbstractTest.assertTrue((boolean)res.asBoolean());
        IgniteAuthenticationProcessor auth = this.grid(0).context().authentication();
        JettyRestProcessorAuthenticationAbstractTest.assertNotNull((Object)auth.authenticate("user1", "password1"));
        ret = this.content(null, GridRestCommand.UPDATE_USER, "user", "user1", "password", "password2");
        res = this.validateJsonResponse(ret);
        JettyRestProcessorAuthenticationAbstractTest.assertTrue((boolean)res.asBoolean());
        JettyRestProcessorAuthenticationAbstractTest.assertNotNull((Object)auth.authenticate("user1", "password2"));
        ret = this.content(null, GridRestCommand.REMOVE_USER, "user", "user1");
        res = this.validateJsonResponse(ret);
        JettyRestProcessorAuthenticationAbstractTest.assertTrue((boolean)res.asBoolean());
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JettyRestProcessorAuthenticationAbstractTest.this.grid(0).context().authentication().authenticate("user1", "password1");
                return null;
            }
        }, IgniteAccessControlException.class, (String)"The user name or password is incorrect");
    }
}

