/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WarmUpConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.processors.cache.warmup.BlockedWarmUpConfiguration;
import org.apache.ignite.internal.processors.cache.warmup.BlockedWarmUpStrategy;
import org.apache.ignite.internal.processors.cache.warmup.WarmUpTestPluginProvider;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.TestRestClient;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.AbstractTestPluginProvider;
import org.apache.ignite.plugin.PluginContext;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

@WithSystemProperty(key="IGNITE_JETTY_PORT", value="8091")
public class JettyRestBeforeNodeStartTest
extends GridCommonAbstractTest {
    private final TestRestClient restClient = new TestRestClient(() -> null);

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.beforeTest();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicDuringWarmup() throws Exception {
        WarmUpTestPluginProvider provider = new WarmUpTestPluginProvider();
        String consistentId = this.getTestIgniteInstanceName(0);
        IgniteConfiguration cfg = this.getConfiguration(consistentId).setPluginProviders(new PluginProvider[]{provider});
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)).setDefaultWarmUpConfiguration((WarmUpConfiguration)new BlockedWarmUpConfiguration()));
        cfg.setConnectorConfiguration(new ConnectorConfiguration().setHost("localhost"));
        IgniteInternalFuture startFut = GridTestUtils.runAsync(() -> this.startGrid(cfg));
        BlockedWarmUpStrategy blockedWarmUpStgy = (BlockedWarmUpStrategy)provider.strats.get(1);
        try {
            U.await((CountDownLatch)blockedWarmUpStgy.startLatch, (long)60L, (TimeUnit)TimeUnit.SECONDS);
            GridTestUtils.assertContains((IgniteLogger)log, (String)this.restClient.content(null, GridRestCommand.NAME, new String[0]), (String)consistentId);
            GridTestUtils.assertContains((IgniteLogger)log, (String)this.restClient.content(null, GridRestCommand.VERSION, new String[0]), (String)IgniteVersionUtils.VER_STR);
            GridTestUtils.assertContains((IgniteLogger)log, (String)this.restClient.content(null, GridRestCommand.NODE_STATE_BEFORE_START, new String[0]), (String)"\"successStatus\":0");
        }
        finally {
            blockedWarmUpStgy.stopLatch.countDown();
            startFut.get(60000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicDuringPluginStart() throws Exception {
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch stopLatch = new CountDownLatch(1);
        AbstractTestPluginProvider provider = new AbstractTestPluginProvider(){

            public String name() {
                return "BlockNodeStartPluginProvider";
            }

            public void start(PluginContext ctx) throws IgniteCheckedException {
                super.start(ctx);
                startLatch.countDown();
                U.await((CountDownLatch)stopLatch, (long)30L, (TimeUnit)TimeUnit.SECONDS);
            }
        };
        String consistentId = this.getTestIgniteInstanceName(0);
        IgniteConfiguration cfg = this.getConfiguration(consistentId).setPluginProviders(new PluginProvider[]{provider});
        cfg.setConnectorConfiguration(new ConnectorConfiguration().setHost("localhost"));
        IgniteInternalFuture startFut = GridTestUtils.runAsync(() -> this.startGrid(cfg));
        try {
            U.await((CountDownLatch)startLatch, (long)60L, (TimeUnit)TimeUnit.SECONDS);
            GridTestUtils.assertContains((IgniteLogger)log, (String)this.restClient.content(null, GridRestCommand.NAME, new String[0]), (String)consistentId);
            GridTestUtils.assertContains((IgniteLogger)log, (String)this.restClient.content(null, GridRestCommand.VERSION, new String[0]), (String)IgniteVersionUtils.VER_STR);
            GridTestUtils.assertContains((IgniteLogger)log, (String)this.restClient.content(null, GridRestCommand.NODE_STATE_BEFORE_START, new String[0]), (String)"\"successStatus\":0");
        }
        finally {
            stopLatch.countDown();
            startFut.get(60000L);
        }
    }
}

