/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcStatementSelfTest
extends GridCommonAbstractTest {
    private static final String BASE_URL = "jdbc:ignite:cfg://cache=default:multipleStatementsAllowed=true@modules/clients/src/test/config/jdbc-config.xml";
    private static final String SQL = "select * from Person where age > 30";
    private Connection conn;
    private Statement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcStatementSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{String.class, Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3);
        IgniteCache cache = this.grid(0).cache("default");
        assert (cache != null);
        cache.put((Object)"p1", (Object)new Person(1, "John", "White", 25));
        cache.put((Object)"p2", (Object)new Person(2, "Joe", "Black", 35));
        cache.put((Object)"p3", (Object)new Person(3, "Mike", "Green", 40));
    }

    protected void beforeTest() throws Exception {
        this.conn = DriverManager.getConnection(BASE_URL);
        this.stmt = this.conn.createStatement();
        JdbcStatementSelfTest.assertNotNull((Object)this.stmt);
        JdbcStatementSelfTest.assertFalse((boolean)this.stmt.isClosed());
    }

    protected void afterTest() throws Exception {
        if (this.stmt != null && !this.stmt.isClosed()) {
            this.stmt.close();
        }
        this.conn.close();
        JdbcStatementSelfTest.assertTrue((boolean)this.stmt.isClosed());
        JdbcStatementSelfTest.assertTrue((boolean)this.conn.isClosed());
    }

    @Test
    public void testExecuteQuery() throws Exception {
        ResultSet rs = this.stmt.executeQuery(SQL);
        assert (rs != null);
        int cnt = 0;
        while (rs.next()) {
            int id = rs.getInt("id");
            if (id == 2) {
                assert ("Joe".equals(rs.getString("firstName")));
                assert ("Black".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 35);
            } else if (id == 3) {
                assert ("Mike".equals(rs.getString("firstName")));
                assert ("Green".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 40);
            } else assert (false) : "Wrong ID: " + id;
            ++cnt;
        }
        assert (cnt == 2);
    }

    @Test
    public void testExecute() throws Exception {
        assert (this.stmt.execute(SQL));
        ResultSet rs = this.stmt.getResultSet();
        assert (rs != null);
        int cnt = 0;
        while (rs.next()) {
            int id = rs.getInt("id");
            if (id == 2) {
                assert ("Joe".equals(rs.getString("firstName")));
                assert ("Black".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 35);
            } else if (id == 3) {
                assert ("Mike".equals(rs.getString("firstName")));
                assert ("Green".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 40);
            } else assert (false) : "Wrong ID: " + id;
            ++cnt;
        }
        assert (cnt == 2);
    }

    @Test
    public void testMaxRows() throws Exception {
        int id;
        this.stmt.setMaxRows(1);
        ResultSet rs = this.stmt.executeQuery(SQL);
        assert (rs != null);
        int cnt = 0;
        while (rs.next()) {
            id = rs.getInt("id");
            if (id == 2) {
                assert ("Joe".equals(rs.getString("firstName")));
                assert ("Black".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 35);
            } else if (id == 3) {
                assert ("Mike".equals(rs.getString("firstName")));
                assert ("Green".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 40);
            } else assert (false) : "Wrong ID: " + id;
            ++cnt;
        }
        assert (cnt == 1);
        this.stmt.setMaxRows(0);
        rs = this.stmt.executeQuery(SQL);
        assert (rs != null);
        cnt = 0;
        while (rs.next()) {
            id = rs.getInt("id");
            if (id == 2) {
                assert ("Joe".equals(rs.getString("firstName")));
                assert ("Black".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 35);
            } else if (id == 3) {
                assert ("Mike".equals(rs.getString("firstName")));
                assert ("Green".equals(rs.getString("lastName")));
                assert (rs.getInt("age") == 40);
            } else assert (false) : "Wrong ID: " + id;
            ++cnt;
        }
        assert (cnt == 2);
    }

    @Test
    public void testExecuteQueryMultipleOnlyResultSets() throws Exception {
        int i;
        assert (this.conn.getMetaData().supportsMultipleResultSets());
        int stmtCnt = 10;
        StringBuilder sql = new StringBuilder();
        for (i = 0; i < stmtCnt; ++i) {
            sql.append("select ").append(i).append("; ");
        }
        assert (this.stmt.execute(sql.toString()));
        for (i = 0; i < stmtCnt; ++i) {
            assert (this.stmt.getMoreResults());
            ResultSet rs = this.stmt.getResultSet();
            assert (rs.next());
            assert (rs.getInt(1) == i);
            assert (!rs.next());
        }
        assert (!this.stmt.getMoreResults());
    }

    @Test
    public void testExecuteQueryMultipleOnlyDml() throws Exception {
        int i;
        assert (this.conn.getMetaData().supportsMultipleResultSets());
        this.conn.setSchema(null);
        int stmtCnt = 10;
        StringBuilder sql = new StringBuilder("drop table if exists test; create table test(ID int primary key, NAME varchar(20)); ");
        for (i = 0; i < stmtCnt; ++i) {
            sql.append("insert into test (ID, NAME) values (" + i + ", 'name_" + i + "'); ");
        }
        assert (!this.stmt.execute(sql.toString()));
        assert (this.stmt.getResultSet() == null);
        assert (this.stmt.getUpdateCount() == 0);
        assert (this.stmt.getResultSet() == null);
        assert (this.stmt.getUpdateCount() == 0);
        for (i = 0; i < stmtCnt; ++i) {
            assert (this.stmt.getMoreResults());
            assert (this.stmt.getResultSet() == null);
            assert (this.stmt.getUpdateCount() == 1);
        }
        assert (!this.stmt.getMoreResults());
    }

    @Test
    public void testExecuteQueryMultipleMixed() throws Exception {
        assert (this.conn.getMetaData().supportsMultipleResultSets());
        this.conn.setSchema(null);
        int stmtCnt = 10;
        StringBuilder sql = new StringBuilder("drop table if exists test; create table test(ID int primary key, NAME varchar(20)); ");
        for (int i = 0; i < stmtCnt; ++i) {
            if (i % 2 == 0) {
                sql.append(" insert into test (ID, NAME) values (" + i + ", 'name_" + i + "'); ");
                continue;
            }
            sql.append(" select * from test where id < " + i + "; ");
        }
        assert (!this.stmt.execute(sql.toString()));
        assert (this.stmt.getResultSet() == null);
        assert (this.stmt.getUpdateCount() == 0);
        assert (this.stmt.getResultSet() == null);
        assert (this.stmt.getUpdateCount() == 0);
        boolean notEmptyResult = false;
        for (int i = 0; i < stmtCnt; ++i) {
            assert (this.stmt.getMoreResults());
            if (i % 2 == 0) {
                assert (this.stmt.getResultSet() == null);
                assert (this.stmt.getUpdateCount() == 1);
                continue;
            }
            assert (this.stmt.getUpdateCount() == -1);
            ResultSet rs = this.stmt.getResultSet();
            assert (rs.getMetaData().getColumnCount() == 2);
            int rowsCnt = 0;
            while (rs.next()) {
                ++rowsCnt;
            }
            assert (rowsCnt <= (i + 1) / 2);
            if (rowsCnt != (i + 1) / 2) continue;
            notEmptyResult = true;
        }
        assert (notEmptyResult);
        assert (!this.stmt.getMoreResults());
    }

    private static class Person
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField(index=false)
        private final String firstName;
        @QuerySqlField(index=false)
        private final String lastName;
        @QuerySqlField
        private final int age;

        private Person(int id, String firstName, String lastName, int age) {
            assert (!F.isEmpty((String)firstName));
            assert (!F.isEmpty((String)lastName));
            assert (age > 0);
            this.id = id;
            this.firstName = firstName;
            this.lastName = lastName;
            this.age = age;
        }
    }
}

