/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.jdbc2.JdbcConnection;
import org.apache.ignite.internal.jdbc2.JdbcConnectionSelfTest;
import org.apache.ignite.internal.processors.resource.GridResourceIoc;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.resources.SpringApplicationContextResource;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class JdbcSpringSelfTest
extends JdbcConnectionSelfTest {
    private static final int GRID_CNT = 2;

    @Override
    protected String configURL() {
        return "modules/clients/src/test/config/jdbc-config-cache-store.xml";
    }

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setMarshaller(null);
        return cfg;
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        this.startGridsWithSpringCtx(2, false, this.configURL());
    }

    @Override
    @Test
    public void testClientNodeId() throws Exception {
        IgniteEx client = (IgniteEx)this.startGridWithSpringCtx(this.getTestIgniteInstanceName(), true, this.configURL());
        UUID clientId = client.localNode().id();
        final String url = "jdbc:ignite:cfg://nodeId=" + clientId + '@' + this.configURL();
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try (Connection conn = DriverManager.getConnection(url);){
                    Connection connection = conn;
                    return connection;
                }
            }
        }, SQLException.class, (String)("Failed to establish connection with node (is it a server node?): " + clientId));
    }

    @Test
    public void testSpringBean() throws Exception {
        String url = "jdbc:ignite:cfg://" + this.configURL();
        try (Connection conn = DriverManager.getConnection(url);){
            JdbcSpringSelfTest.assertNotNull((Object)conn);
            TestInjectTarget target = new TestInjectTarget();
            IgniteKernal kernal = ((JdbcConnection)conn).ignite();
            kernal.context().resource().inject((Object)target, GridResourceIoc.AnnotationSet.GENERIC, new Object[0]);
            JdbcSpringSelfTest.assertNotNull((Object)target.appCtx);
            IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
            DataSource ds = (DataSource)spring.loadBeanFromAppContext(target.appCtx, "dsTest");
            JdbcSpringSelfTest.assertNotNull((Object)ds);
        }
    }

    private static class TestInjectTarget {
        @SpringApplicationContextResource
        private Object appCtx;

        private TestInjectTarget() {
        }
    }
}

