/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.query.oom.QueryMemoryTrackerSelfTest;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.GridAbstractTest;
import org.junit.Test;

public class JdbcQueryMemoryTrackerSelfTest
extends QueryMemoryTrackerSelfTest {
    protected boolean startClient() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalQuota() throws Exception {
        this.maxMem = 0x800000L;
        this.useJdbcV2GlobalQuotaCfg = true;
        List<ResultSet> results = Collections.synchronizedList(new ArrayList());
        List<Statement> statements = Collections.synchronizedList(new ArrayList());
        ArrayList<IgniteInternalFuture> futs = new ArrayList<IgniteInternalFuture>();
        try {
            for (int i = 0; i < 10; ++i) {
                futs.add(GridTestUtils.runAsync(() -> {
                    Connection conn = this.createConnection(true);
                    Statement stmt = conn.createStatement();
                    statements.add(stmt);
                    ResultSet rs = stmt.executeQuery("select * from T as T0, T as T1 where T0.id < 2 UNION select * from T as T2, T as T3 where T2.id >= 1 AND T2.id < 2");
                    results.add(rs);
                    rs.next();
                    return null;
                }));
            }
            SQLException ex = (SQLException)GridTestUtils.assertThrows((IgniteLogger)GridAbstractTest.log, () -> {
                SQLException sqlEx = null;
                for (IgniteInternalFuture f : futs) {
                    try {
                        f.get(5000L);
                    }
                    catch (IgniteCheckedException e) {
                        if (!e.hasCause(new Class[]{SQLException.class})) continue;
                        sqlEx = (SQLException)e.getCause(SQLException.class);
                    }
                }
                if (sqlEx != null) {
                    throw sqlEx;
                }
                return null;
            }, SQLException.class, (String)"SQL query ran out of memory: Global quota was exceeded.");
            JdbcQueryMemoryTrackerSelfTest.assertEquals((int)3015, (int)ex.getErrorCode());
            JdbcQueryMemoryTrackerSelfTest.assertEquals((String)IgniteQueryErrorCode.codeToSqlState((int)3015), (String)ex.getSQLState());
        }
        finally {
            for (ResultSet rs : results) {
                IgniteUtils.closeQuiet((AutoCloseable)rs);
            }
            for (Statement stmt : statements) {
                IgniteUtils.closeQuiet((AutoCloseable)stmt.getConnection());
                IgniteUtils.closeQuiet((AutoCloseable)stmt);
            }
        }
    }

    protected List<List<?>> execQuery(String sql, boolean lazy) throws Exception {
        try (Connection conn = this.createConnection(lazy);
             Statement stmt = conn.createStatement();){
            assert (stmt != null && !stmt.isClosed());
            try (ResultSet rs = stmt.executeQuery(sql);){
                while (rs.next()) {
                }
            }
        }
        return Collections.emptyList();
    }

    protected void checkQueryExpectOOM(String sql, boolean lazy) {
        try {
            this.execQuery(sql, lazy);
            JdbcQueryMemoryTrackerSelfTest.fail((String)"Exception is not thrown.");
        }
        catch (SQLException e) {
            JdbcQueryMemoryTrackerSelfTest.assertTrue((boolean)e.getMessage().contains("SQL query ran out of memory: Query quota was exceeded."));
            JdbcQueryMemoryTrackerSelfTest.assertEquals((int)3015, (int)e.getErrorCode());
            JdbcQueryMemoryTrackerSelfTest.assertEquals((String)IgniteQueryErrorCode.codeToSqlState((int)3015), (String)e.getSQLState());
        }
        catch (Exception e) {
            JdbcQueryMemoryTrackerSelfTest.fail((String)("Wrong exception: " + X.getFullStackTrace((Throwable)e)));
        }
    }

    protected Connection createConnection(boolean lazy) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:ignite:cfg://queryMaxMemory=" + this.maxMem + ":lazy=" + lazy + (this.useJdbcV2GlobalQuotaCfg ? "@modules/clients/src/test/config/jdbc-config-mem-limit.xml" : "@modules/clients/src/test/config/jdbc-config.xml"));
        conn.setSchema("\"PUBLIC\"");
        return conn;
    }
}

