/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ClientJavaHasherSelfTest
extends GridCommonAbstractTest {
    @Test
    public void testPredefined() {
        LinkedHashMap<Object, Integer> map = new LinkedHashMap<Object, Integer>();
        long max = 0x1000000000000L;
        for (long i = 1L; i < max; i *= -3L) {
            map.put((byte)i, Integer.valueOf((byte)i));
            map.put(Character.valueOf((char)i), Integer.valueOf((char)i));
            map.put((int)i, (int)i);
            map.put(i, (int)(i ^ i >>> 32));
        }
        map.put(0.0, 0);
        map.put(1.0, 0x3FF00000);
        map.put(-1.0, -1074790400);
        map.put(3.1415E200, 1130072580);
        map.put(3.1415E-200, -819810675);
        map.put("", 0);
        map.put("asdf", 3003444);
        map.put("Hadoop\u3092\u6bba\u3059", 2113729932);
        map.put("224ea4cd-f449-4dcb-869a-5317c63bd619", 258755163);
        map.put("fdc9ec54-ff53-4fdb-8239-5a3ac1fb31bd", -863611257);
        map.put("0f9c9b94-02ae-45a6-9d5c-a066dbdf2636", -1499939567);
        map.put("d8f1f916-4357-4cfe-a7df-49d4721690bf", 2041432124);
        map.put(UUID.fromString("224ea4cd-f449-4dcb-869a-5317c63bd619"), -1767478264);
        map.put(UUID.fromString("fdc9ec54-ff53-4fdb-8239-5a3ac1fb31bd"), 1096337416);
        map.put(UUID.fromString("0f9c9b94-02ae-45a6-9d5c-a066dbdf2636"), 1269913698);
        map.put(UUID.fromString("d8f1f916-4357-4cfe-a7df-49d4721690bf"), 1315925123);
        boolean ok = true;
        for (Map.Entry entry : map.entrySet()) {
            int act = entry.getKey().hashCode();
            int exp = (Integer)entry.getValue();
            if (exp == act) continue;
            ok = false;
            this.info("Validation of hash code for '" + entry.getKey() + "' failed [expected=" + exp + ", actual=" + act + ".");
        }
        if (ok) {
            return;
        }
        ClientJavaHasherSelfTest.fail((String)"Java hash codes validation fails.");
    }
}

