/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.router;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.client.integration.ClientAbstractMultiNodeSelfTest;
import org.apache.ignite.internal.client.router.GridTcpRouterConfiguration;
import org.apache.ignite.internal.client.router.impl.GridTcpRouterImpl;
import org.apache.ignite.logger.log4j.Log4JLogger;

public class TcpRouterMultiNodeSelfTest
extends ClientAbstractMultiNodeSelfTest {
    private static final int ROUTERS_CNT = 5;
    private static final int ROUTER_TCP_PORT_BASE = 12350;
    private static Collection<GridTcpRouterImpl> routers = new ArrayList<GridTcpRouterImpl>(5);

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        for (int i = 0; i < 5; ++i) {
            routers.add(new GridTcpRouterImpl(this.routerConfiguration(i++)));
        }
        for (GridTcpRouterImpl r : routers) {
            r.start();
        }
    }

    protected void afterTestsStopped() throws Exception {
        this.info("Stopping routers...");
        for (GridTcpRouterImpl r : routers) {
            r.stop();
        }
        this.info("Routers stopped.");
        routers.clear();
    }

    @Override
    protected GridClientProtocol protocol() {
        return GridClientProtocol.TCP;
    }

    @Override
    protected String serverAddress() {
        return null;
    }

    private GridTcpRouterConfiguration routerConfiguration(int i) throws IgniteCheckedException {
        GridTcpRouterConfiguration cfg = new GridTcpRouterConfiguration();
        cfg.setHost("127.0.0.1");
        cfg.setPort(12350 + i);
        cfg.setPortRange(0);
        cfg.setServers(Collections.singleton("127.0.0.1:12345"));
        cfg.setLogger((IgniteLogger)new Log4JLogger("modules/core/src/test/config/log4j-test.xml"));
        return cfg;
    }

    @Override
    protected GridClientConfiguration clientConfiguration() throws GridClientException {
        GridClientConfiguration cfg = super.clientConfiguration();
        cfg.setServers(Collections.emptySet());
        ArrayList<String> rtrs = new ArrayList<String>(5);
        for (int i = 0; i < 5; ++i) {
            rtrs.add("127.0.0.1:" + (12350 + i));
        }
        cfg.setRouters(rtrs);
        return cfg;
    }
}

