/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskSplitAdapter;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.balancer.GridClientLoadBalancer;
import org.apache.ignite.internal.client.balancer.GridClientRandomBalancer;
import org.apache.ignite.internal.client.balancer.GridClientRoundRobinBalancer;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ClientPreferDirectSelfTest
extends GridCommonAbstractTest {
    private static final int NODES_CNT = 6;

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(6);
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        c.setLocalHost("127.0.0.1");
        assert (c.getConnectorConfiguration() == null);
        ConnectorConfiguration clientCfg = new ConnectorConfiguration();
        clientCfg.setPort(12345);
        c.setConnectorConfiguration(clientCfg);
        return c;
    }

    @Test
    public void testRandomBalancer() throws Exception {
        GridClientRandomBalancer b = new GridClientRandomBalancer();
        b.setPreferDirectNodes(true);
        this.executeTest((GridClientLoadBalancer)b);
    }

    @Test
    public void testRoundRobinBalancer() throws Exception {
        GridClientRoundRobinBalancer b = new GridClientRoundRobinBalancer();
        b.setPreferDirectNodes(true);
        this.executeTest((GridClientLoadBalancer)b);
    }

    private void executeTest(GridClientLoadBalancer b) throws Exception {
        try (GridClient c = this.client(b);){
            int i;
            HashSet<Object> executions = new HashSet<Object>();
            for (i = 0; i < 60; ++i) {
                executions.add(c.compute().execute(TestTask.class.getName(), null));
            }
            ClientPreferDirectSelfTest.assertEquals((int)3, (int)executions.size());
            for (i = 0; i < 3; ++i) {
                executions.contains(this.grid(i).localNode().id().toString());
            }
        }
    }

    private GridClient client(GridClientLoadBalancer b) throws Exception {
        GridClientConfiguration cfg = new GridClientConfiguration();
        cfg.setBalancer(b);
        cfg.setTopologyRefreshFrequency(2500L);
        ArrayList<String> rtrs = new ArrayList<String>(3);
        for (int i = 0; i < 3; ++i) {
            rtrs.add("127.0.0.1:" + (12345 + i));
        }
        cfg.setRouters(rtrs);
        return GridClientFactory.start((GridClientConfiguration)cfg);
    }

    private static class TestTask
    extends ComputeTaskSplitAdapter<Object, String> {
        @IgniteInstanceResource
        private Ignite ignite;
        private int gridSize;

        private TestTask() {
        }

        protected Collection<? extends ComputeJob> split(int gridSize, Object arg) {
            ArrayList<1> jobs = new ArrayList<1>(gridSize);
            this.gridSize = gridSize;
            for (int i = 0; i < gridSize; ++i) {
                jobs.add(new ComputeJobAdapter(){

                    public Object execute() {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                        }
                        return "OK";
                    }
                });
            }
            return jobs;
        }

        public String reduce(List<ComputeJobResult> results) {
            int sum = 0;
            for (ComputeJobResult res : results) {
                ClientPreferDirectSelfTest.assertNotNull((Object)res.getData());
                ++sum;
            }
            assert (this.gridSize == sum);
            return this.ignite.cluster().localNode().id().toString();
        }
    }
}

