/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.cache.configuration.Factory;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.ssl.GridSslBasicContextFactory;
import org.apache.ignite.internal.client.ssl.GridSslContextFactory;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.ssl.SslContextFactory;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class ClientSslParametersTest
extends GridCommonAbstractTest {
    public static final String TEST_CACHE_NAME = "TEST";
    private volatile String[] cipherSuites;
    private volatile String[] protocols;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setSslContextFactory((Factory)this.createSslFactory());
        cfg.setConnectorConfiguration(new ConnectorConfiguration().setSslEnabled(true).setSslClientAuth(true));
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration(TEST_CACHE_NAME)});
        return cfg;
    }

    protected GridClientConfiguration getClientConfiguration() {
        GridClientConfiguration cfg = new GridClientConfiguration();
        cfg.setServers(Collections.singleton("127.0.0.1:11211"));
        cfg.setSslContextFactory((GridSslContextFactory)this.createOldSslFactory());
        return cfg;
    }

    @NotNull
    private SslContextFactory createSslFactory() {
        SslContextFactory factory = (SslContextFactory)GridTestUtils.sslFactory();
        factory.setCipherSuites(this.cipherSuites);
        factory.setProtocols(this.protocols);
        return factory;
    }

    @NotNull
    private GridSslBasicContextFactory createOldSslFactory() {
        GridSslBasicContextFactory factory = (GridSslBasicContextFactory)GridTestUtils.sslContextFactory();
        factory.setCipherSuites(this.cipherSuites);
        factory.setProtocols(this.protocols);
        return factory;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.protocols = null;
        this.cipherSuites = null;
    }

    @Test
    public void testSameCipherSuite() throws Exception {
        this.cipherSuites = new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"};
        this.startGrid();
        this.checkSuccessfulClientStart(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"}, null);
    }

    @Test
    public void testOneCommonCipherSuite() throws Exception {
        this.cipherSuites = new String[]{"TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"};
        this.startGrid();
        this.checkSuccessfulClientStart(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"}, null);
    }

    @Test
    public void testNoCommonCipherSuite() throws Exception {
        this.cipherSuites = new String[]{"TLS_RSA_WITH_AES_128_GCM_SHA256"};
        this.startGrid();
        this.checkClientStartFailure(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"}, null);
    }

    @Test
    public void testNonExistentCipherSuite() throws Exception {
        this.cipherSuites = new String[]{"TLS_RSA_WITH_AES_128_GCM_SHA256"};
        this.startGrid();
        this.checkClientStartFailure(new String[]{"TLC_FAKE_CIPHER", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"}, null);
    }

    @Test
    public void testNoCommonProtocols() throws Exception {
        this.protocols = new String[]{"TLSv1.1", "SSLv3"};
        this.startGrid();
        this.checkClientStartFailure(null, new String[]{"TLSv1", "TLSv1.2"});
    }

    @Test
    public void testNonExistentProtocol() throws Exception {
        this.protocols = new String[]{"SSLv3"};
        this.startGrid();
        this.checkClientStartFailure(null, new String[]{"SSLv3", "SSLvDoesNotExist"});
    }

    @Test
    public void testSameProtocols() throws Exception {
        this.protocols = new String[]{"TLSv1.1", "TLSv1.2"};
        this.startGrid();
        this.checkSuccessfulClientStart(null, new String[]{"TLSv1.1", "TLSv1.2"});
    }

    @Test
    public void testOneCommonProtocol() throws Exception {
        this.protocols = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
        this.startGrid();
        this.checkSuccessfulClientStart(null, new String[]{"TLSv1.2", "SSLv3"});
    }

    private void checkSuccessfulClientStart(String[] cipherSuites, String[] protocols) throws Exception {
        this.cipherSuites = F.isEmpty((Object[])cipherSuites) ? null : cipherSuites;
        this.protocols = F.isEmpty((Object[])protocols) ? null : protocols;
        try (GridClient client = GridClientFactory.start((GridClientConfiguration)this.getClientConfiguration());){
            List top = client.compute().refreshTopology(false, false);
            ClientSslParametersTest.assertEquals((int)1, (int)top.size());
        }
    }

    private void checkClientStartFailure(String[] cipherSuites, String[] protocols) {
        this.checkClientStartFailure(cipherSuites, protocols, "Latest topology update failed.");
    }

    private void checkClientStartFailure(String[] cipherSuites, String[] protocols, String msg) {
        this.cipherSuites = F.isEmpty((Object[])cipherSuites) ? null : cipherSuites;
        this.protocols = F.isEmpty((Object[])protocols) ? null : protocols;
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                GridClient client = GridClientFactory.start((GridClientConfiguration)ClientSslParametersTest.this.getClientConfiguration());
                client.compute().refreshTopology(false, false);
                return null;
            }
        }, GridClientException.class, (String)msg);
    }
}

