/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ClientDefaultCacheSelfTest
extends GridCommonAbstractTest {
    private static final String REST_JETTY_CFG = "modules/clients/src/test/resources/jetty/rest-jetty.xml";
    private static final String HOST = "127.0.0.1";
    private UUID locNodeId;
    private static final int HTTP_PORT = 8081;
    private static final String TEST_URL = "http://127.0.0.1:8081/ignite?";
    private static final String CHARSET = StandardCharsets.UTF_8.name();
    private static final String LOCAL_CACHE = "local";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    protected void beforeTestsStarted() throws Exception {
        System.setProperty("IGNITE_JETTY_PORT", String.valueOf(8081));
        this.startGrid();
    }

    protected void afterTestsStopped() throws Exception {
        System.clearProperty("IGNITE_JETTY_PORT");
    }

    protected void beforeTest() throws Exception {
        this.locNodeId = this.grid().localNode().id();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        assert (cfg.getConnectorConfiguration() == null);
        ConnectorConfiguration clientCfg = new ConnectorConfiguration();
        clientCfg.setJettyPath(REST_JETTY_CFG);
        cfg.setConnectorConfiguration(clientCfg);
        CacheConfiguration cLoc = new CacheConfiguration("default");
        cLoc.setName(LOCAL_CACHE);
        cLoc.setCacheMode(CacheMode.LOCAL);
        cLoc.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ClientDefaultCacheSelfTest.defaultCacheConfiguration(), cLoc});
        return cfg;
    }

    private String content(Map<String, String> params) throws IOException {
        SB sb = new SB(TEST_URL);
        for (Map.Entry<String, String> e : params.entrySet()) {
            sb.a(e.getKey()).a('=').a(e.getValue()).a('&');
        }
        String qry = sb.toString();
        try {
            URL url = new URL(qry);
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("Accept-Charset", CHARSET);
            InputStream in = conn.getInputStream();
            StringBuilder buf = new StringBuilder(256);
            try (LineNumberReader rdr = new LineNumberReader(new InputStreamReader(in, "UTF-8"));){
                String line = rdr.readLine();
                while (line != null) {
                    buf.append(line);
                    line = rdr.readLine();
                }
            }
            return buf.toString();
        }
        catch (IOException e) {
            this.error("Failed to send HTTP request: http://127.0.0.1:8081/ignite??" + qry, e);
            throw e;
        }
    }

    private JsonNode jsonResponse(String content) throws IOException {
        ClientDefaultCacheSelfTest.assertNotNull((Object)content);
        ClientDefaultCacheSelfTest.assertFalse((boolean)content.isEmpty());
        JsonNode node = JSON_MAPPER.readTree(content);
        ClientDefaultCacheSelfTest.assertFalse((boolean)node.get("affinityNodeId").asText().isEmpty());
        ClientDefaultCacheSelfTest.assertEquals((int)0, (int)node.get("successStatus").asInt());
        ClientDefaultCacheSelfTest.assertTrue((boolean)node.get("error").isNull());
        ClientDefaultCacheSelfTest.assertTrue((boolean)node.get("sessionToken").isNull());
        return node.get("response");
    }

    @Test
    public void testSkipString2JsonTransformation() throws Exception {
        String val = "{\"v\":\"my Value\",\"t\":1422559650154}";
        String ret = this.content(F.asMap((Object)"cmd", (Object)GridRestCommand.CACHE_PUT.key(), (Object)"cacheName", (Object)LOCAL_CACHE, (Object)"key", (Object)"a", (Object)"val", (Object)URLEncoder.encode(val, CHARSET)));
        JsonNode res = this.jsonResponse(ret);
        ClientDefaultCacheSelfTest.assertEquals((String)"Incorrect put response", (boolean)true, (boolean)res.asBoolean());
        ret = this.content(F.asMap((Object)"cmd", (Object)GridRestCommand.CACHE_GET.key(), (Object)"cacheName", (Object)LOCAL_CACHE, (Object)"key", (Object)"a"));
        res = this.jsonResponse(ret);
        ClientDefaultCacheSelfTest.assertEquals((String)"Incorrect get response", (String)val, (String)res.asText());
    }
}

