/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.qa.query;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.jdbc.JdbcTestUtils;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.TestJavaProcess;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class JdbcThinTimezoneTest
extends AbstractIndexingCommonTest {
    private static final String URL = "jdbc:ignite:thin://127.0.0.1";
    private static final String URL_TZ_DISABLE = "jdbc:ignite:thin://127.0.0.1/?disabledFeatures=time_zone";
    private static final String[] TIME_ZONES = new String[]{"EST5EDT", "IST", "Europe/Moscow"};
    private static final String[] NODE_TIME_ZONES = new String[]{"CST", "EST"};
    private String tzId;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
        this.startGrid(0);
        for (String nodeTz : NODE_TIME_ZONES) {
            this.startRemoteGrid("node-" + nodeTz, nodeTz);
        }
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        JdbcTestUtils.sql(URL, "DROP TABLE IF EXISTS TZ_TEST", Collections.emptyList());
        JdbcTestUtils.sql(URL, "CREATE TABLE IF NOT EXISTS TZ_TEST (tz VARCHAR, label VARCHAR, dateVal DATE, timeVal TIME, tsVal TIMESTAMP, PRIMARY KEY (tz, label))", Collections.emptyList());
    }

    @Test
    public void testEnableTimezone() throws Exception {
        for (String tz : TIME_ZONES) {
            this.insertObjectByLegacyApi(URL, TimeZone.getTimeZone(tz));
            this.insertObjectByModernApi(URL, TimeZone.getTimeZone(tz));
            this.insertLiteral(URL, TimeZone.getTimeZone(tz));
        }
        this.checkResults(this.selectResultsForAllTimeZones("SELECT tz, label, dateVal, timeVal, tsVal FROM TZ_TEST", true));
        this.checkResults(this.selectResultsForAllTimeZones("SELECT tz, label, CAST(dateVal AS VARCHAR), CAST(timeVal AS VARCHAR), CAST(tsVal AS VARCHAR) FROM TZ_TEST", false));
    }

    @Test
    public void testSelectWithConditions() throws Exception {
        for (String tz : TIME_ZONES) {
            this.insertObjectByLegacyApi(URL, TimeZone.getTimeZone(tz));
            this.insertObjectByModernApi(URL, TimeZone.getTimeZone(tz));
            this.insertLiteral(URL, TimeZone.getTimeZone(tz));
        }
        this.checkResults(this.selectResultsForAllTimeZones("SELECT tz, label, dateVal, timeVal, tsVal FROM TZ_TEST WHERE dateVal = CAST('2019-09-09' AS DATE) AND timeVal = CAST('09:09:09' AS TIME) AND tsVal = CAST('2019-09-09 09:09:09.909' AS TIMESTAMP)", true));
        HashMap<String, List<String>> resMap = new HashMap<String, List<String>>();
        for (String tz : TIME_ZONES) {
            List<String> res = this.selectWithCondition(TimeZone.getTimeZone(tz));
            res.sort(String::compareTo);
            resMap.put(tz, res);
        }
        this.checkResults(resMap);
    }

    @Test
    public void testDisableTimezone() throws Exception {
        for (String tz : TIME_ZONES) {
            this.insertObjectByLegacyApi(URL_TZ_DISABLE, TimeZone.getTimeZone(tz));
            this.insertObjectByModernApi(URL_TZ_DISABLE, TimeZone.getTimeZone(tz));
            this.insertLiteral(URL_TZ_DISABLE, TimeZone.getTimeZone(tz));
        }
        HashMap<String, List<String>> resMap = new HashMap<String, List<String>>();
        for (String tz : TIME_ZONES) {
            List<String> res = this.selectAndPrintMilliseconds("SELECT tz, label, dateVal, timeVal, tsVal FROM TZ_TEST", TimeZone.getTimeZone(tz));
            res.sort(String::compareTo);
            resMap.put(tz, res);
        }
        this.checkResults(resMap);
    }

    @NotNull
    private Map<String, List<String>> selectResultsForAllTimeZones(String sql, boolean fetchDateObjs) throws Exception {
        HashMap<String, List<String>> resMap = new HashMap<String, List<String>>();
        for (String tz : TIME_ZONES) {
            List<String> res = this.select(sql, TimeZone.getTimeZone(tz), fetchDateObjs);
            res.sort(String::compareTo);
            resMap.put(tz, res);
        }
        return resMap;
    }

    private void checkResults(Map<String, List<String>> resMap) {
        for (String tz : TIME_ZONES) {
            List<String> res = resMap.get(tz);
            JdbcThinTimezoneTest.assertFalse((boolean)res.isEmpty());
            resMap.forEach((key, value) -> {
                if (!value.equals(res)) {
                    for (String s : res) {
                        System.err.println(tz + ", " + s);
                    }
                    for (String s : value) {
                        System.err.println(key + ", " + s);
                    }
                    JdbcThinTimezoneTest.fail((String)"Not equal select result for date/time fields. Need investigate");
                }
            });
        }
    }

    private void insertObjectByLegacyApi(String url, TimeZone tz) throws Exception {
        TestJavaProcess.exec((GridTestUtils.IgniteRunnableX & Serializable)() -> JdbcTestUtils.sql(url, "INSERT INTO TZ_TEST (tz, label, dateVal, timeVal, tsVal) VALUES (?, 'obj_legacy', ?, ?, ?)", Arrays.asList(tz.getID(), new Date(119, 8, 9), new Time(9, 9, 9), new Timestamp(119, 8, 9, 9, 9, 9, 909000000))), (String[])new String[]{"-Duser.timezone=" + tz.getID()});
    }

    private void insertObjectByModernApi(String url, TimeZone tz) throws Exception {
        TestJavaProcess.exec((GridTestUtils.IgniteRunnableX & Serializable)() -> {
            Calendar dateCal = Calendar.getInstance();
            dateCal.set(2019, 8, 9);
            Calendar timeCal = Calendar.getInstance();
            timeCal.set(11, 9);
            timeCal.set(12, 9);
            timeCal.set(13, 9);
            timeCal.set(14, 0);
            Calendar tsCal = Calendar.getInstance();
            tsCal.set(2019, 8, 9, 9, 9, 9);
            tsCal.set(14, 909);
            JdbcTestUtils.sql(url, "INSERT INTO TZ_TEST (tz, label, dateVal, timeVal, tsVal) VALUES (?, 'obj_modern', ?, ?, ?)", Arrays.asList(tz.getID(), new Date(dateCal.getTimeInMillis()), new Time(timeCal.getTimeInMillis()), new Timestamp(tsCal.getTimeInMillis())));
        }, (String[])new String[]{"-Duser.timezone=" + tz.getID()});
    }

    private void insertLiteral(String url, TimeZone tz) throws Exception {
        TestJavaProcess.exec((GridTestUtils.IgniteRunnableX & Serializable)() -> JdbcTestUtils.sql(url, "INSERT INTO TZ_TEST (tz, label, dateVal, timeVal, tsVal) VALUES (?, 'literal', CAST(? AS DATE), CAST(? AS TIME), CAST(? AS TIMESTAMP))", Arrays.asList(tz.getID(), "2019-09-09", "09:09:09", "2019-09-09 09:09:09.909")), (String[])new String[]{"-Duser.timezone=" + tz.getID()});
    }

    private List<String> select(String sql, TimeZone tz, boolean fetchDateObjs) throws Exception {
        return (List)TestJavaProcess.exec((IgniteCallable & Serializable)() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.getAnalysis(Method.java:520)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:351)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, (String[])new String[]{"-Duser.timezone=" + tz.getID()});
    }

    private List<String> selectWithCondition(TimeZone tz) throws Exception {
        return (List)TestJavaProcess.exec((IgniteCallable & Serializable)() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.getAnalysis(Method.java:520)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:351)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, (String[])new String[]{"-Duser.timezone=" + tz.getID()});
    }

    private List<String> selectAndPrintMilliseconds(String sql, TimeZone tz) throws Exception {
        return (List)TestJavaProcess.exec((IgniteCallable & Serializable)() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.getAnalysis(Method.java:520)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:351)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, (String[])new String[]{"-Duser.timezone=" + tz.getID()});
    }

    protected List<String> additionalRemoteJvmArgs() {
        return Collections.singletonList("-Duser.timezone=" + this.tzId);
    }

    private void startRemoteGrid(String name, String tzId) throws Exception {
        this.tzId = tzId;
        this.startRemoteGrid(name, this.optimize(this.getConfiguration(name)), null);
    }
}

