/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class JdbcThinSelectAfterAlterTable
extends GridCommonAbstractTest {
    private int cliPort = 10800;
    private Connection conn;
    private Statement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("default")});
        cfg.setClientConnectorConfiguration(new ClientConnectorConfiguration().setPort(this.cliPort++));
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String name) throws Exception {
        CacheConfiguration cfg = JdbcThinSelectAfterAlterTable.defaultCacheConfiguration();
        cfg.setName(name);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(2);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1");
        this.stmt = this.conn.createStatement();
        this.stmt.executeUpdate("CREATE TABLE person (id LONG, name VARCHAR, city_id LONG, PRIMARY KEY (id, city_id))");
        this.stmt.executeUpdate("INSERT INTO person (id, name, city_id) values (1, 'name_1', 11)");
        this.stmt.executeQuery("select * from person");
    }

    protected void afterTest() throws Exception {
        this.stmt.close();
        this.conn.close();
        for (String cacheName : this.grid(0).cacheNames()) {
            DynamicCacheDescriptor cacheDesc = this.grid(0).context().cache().cacheDescriptor(cacheName);
            if (cacheDesc == null || !cacheDesc.sql()) continue;
            this.grid(0).destroyCache0(cacheName, true);
        }
        super.afterTest();
    }

    @Test
    public void testSelectAfterAlterTableSingleNode() throws Exception {
        this.stmt.executeUpdate("alter table person add age int");
        this.checkNewColumn(this.stmt);
    }

    @Test
    public void testSelectAfterAlterTableMultiNode() throws Exception {
        try (Connection conn2 = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10801");
             Statement stmt2 = conn2.createStatement();){
            stmt2.executeUpdate("alter table person add age int");
        }
        this.checkNewColumn(this.stmt);
    }

    public void checkNewColumn(Statement stmt) throws SQLException {
        ResultSet rs = stmt.executeQuery("select * from person");
        ResultSetMetaData meta = rs.getMetaData();
        JdbcThinSelectAfterAlterTable.assertEquals((int)4, (int)meta.getColumnCount());
        boolean newColExists = false;
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            if (!"age".equalsIgnoreCase(meta.getColumnName(i))) continue;
            newColExists = true;
            break;
        }
        JdbcThinSelectAfterAlterTable.assertTrue((boolean)newColExists);
    }
}

