/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.jdbc2.JdbcQueryMemoryTrackerSelfTest;
import org.apache.ignite.internal.processors.query.h2.H2LocalResultFactory;
import org.apache.ignite.internal.processors.query.h2.H2ManagedLocalResult;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.result.LocalResult;
import org.gridgain.internal.h2.result.LocalResultImpl;
import org.junit.Test;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class JdbcThinQueryMemoryTrackerSelfTest
extends JdbcQueryMemoryTrackerSelfTest {
    private static final AtomicReference<Throwable> localResultErr = new AtomicReference();
    private static final AtomicInteger closedResultCntr = new AtomicInteger();

    protected Class<?> localResultFactory() {
        return TestH2LocalResultFactory.class;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        closedResultCntr.set(0);
    }

    @Test
    public void testPartialResultRead() throws Throwable {
        this.maxMem = 0x800000L;
        try (Connection conn = this.createConnection(false);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("select * from k");){
            for (int i = 0; i < 10; ++i) {
                if (rs.next()) continue;
                JdbcThinQueryMemoryTrackerSelfTest.fail();
            }
        }
        boolean success = GridTestUtils.waitForCondition(() -> localResults.size() == closedResultCntr.get(), (long)10000L);
        JdbcThinQueryMemoryTrackerSelfTest.assertTrue((boolean)success);
        Throwable err = localResultErr.get();
        if (err != null) {
            JdbcThinQueryMemoryTrackerSelfTest.fail((String)err.getMessage());
        }
    }

    @Override
    protected Connection createConnection(boolean lazy) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800..10802?queryMaxMemory=" + this.maxMem + "&lazy=" + lazy);
        conn.setSchema("\"PUBLIC\"");
        return conn;
    }

    public static class TestH2LocalResultFactory
    extends H2LocalResultFactory {
        public LocalResult create(Session ses, Expression[] expressions, int visibleColCnt, boolean system) {
            if (system) {
                return new LocalResultImpl(ses, expressions, visibleColCnt);
            }
            if (ses.memoryTracker() != null) {
                H2ManagedLocalResult res = new H2ManagedLocalResult(ses, expressions, visibleColCnt){

                    public void close() {
                        try {
                            closedResultCntr.incrementAndGet();
                            super.close();
                        }
                        catch (Throwable t) {
                            if (!localResultErr.compareAndSet(null, t)) {
                                ((Throwable)localResultErr.get()).addSuppressed(t);
                            }
                            throw t;
                        }
                    }
                };
                localResults.add(res);
                return res;
            }
            return new H2ManagedLocalResult(ses, expressions, visibleColCnt);
        }

        public LocalResult create() {
            throw new NotImplementedException();
        }
    }
}

