/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractDmlStatementSelfTest;
import org.junit.Test;

public class JdbcThinMergeStatementSelfTest
extends JdbcThinAbstractDmlStatementSelfTest {
    private static final String SQL = "merge into Person(_key, id, firstName, lastName, age) values ('p1', 1, 'John', 'White', 25), ('p2', 2, 'Joe', 'Black', 35), ('p3', 3, 'Mike', 'Green', 40)";
    protected static final String SQL_PREPARED = "merge into Person(_key, id, firstName, lastName, age) values (?, ?, ?, ?, ?), (?, ?, ?, ?, ?)";
    protected Statement stmt;
    protected PreparedStatement prepStmt;

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stmt = this.conn.createStatement();
        this.prepStmt = this.conn.prepareStatement(SQL_PREPARED);
        JdbcThinMergeStatementSelfTest.assertNotNull((Object)this.stmt);
        JdbcThinMergeStatementSelfTest.assertFalse((boolean)this.stmt.isClosed());
        JdbcThinMergeStatementSelfTest.assertNotNull((Object)this.prepStmt);
        JdbcThinMergeStatementSelfTest.assertFalse((boolean)this.prepStmt.isClosed());
    }

    @Override
    protected void afterTest() throws Exception {
        try (Statement selStmt = this.conn.createStatement();){
            JdbcThinMergeStatementSelfTest.assertTrue((boolean)selStmt.execute("select _key, id, firstName, lastName, age from Person"));
            ResultSet rs = selStmt.getResultSet();
            assert (rs != null);
            block15: while (rs.next()) {
                int id = rs.getInt("id");
                switch (id) {
                    case 1: {
                        JdbcThinMergeStatementSelfTest.assertEquals((String)"p1", (String)rs.getString("_key"));
                        JdbcThinMergeStatementSelfTest.assertEquals((String)"John", (String)rs.getString("firstName"));
                        JdbcThinMergeStatementSelfTest.assertEquals((String)"White", (String)rs.getString("lastName"));
                        JdbcThinMergeStatementSelfTest.assertEquals((int)25, (int)rs.getInt("age"));
                        continue block15;
                    }
                    case 2: {
                        JdbcThinMergeStatementSelfTest.assertEquals((String)"p2", (String)rs.getString("_key"));
                        JdbcThinMergeStatementSelfTest.assertEquals((String)"Joe", (String)rs.getString("firstName"));
                        JdbcThinMergeStatementSelfTest.assertEquals((String)"Black", (String)rs.getString("lastName"));
                        JdbcThinMergeStatementSelfTest.assertEquals((int)35, (int)rs.getInt("age"));
                        continue block15;
                    }
                    case 3: {
                        JdbcThinMergeStatementSelfTest.assertEquals((String)"p3", (String)rs.getString("_key"));
                        JdbcThinMergeStatementSelfTest.assertEquals((String)"Mike", (String)rs.getString("firstName"));
                        JdbcThinMergeStatementSelfTest.assertEquals((String)"Green", (String)rs.getString("lastName"));
                        JdbcThinMergeStatementSelfTest.assertEquals((int)40, (int)rs.getInt("age"));
                        continue block15;
                    }
                    case 4: {
                        JdbcThinMergeStatementSelfTest.assertEquals((String)"p4", (String)rs.getString("_key"));
                        JdbcThinMergeStatementSelfTest.assertEquals((String)"Leah", (String)rs.getString("firstName"));
                        JdbcThinMergeStatementSelfTest.assertEquals((String)"Grey", (String)rs.getString("lastName"));
                        JdbcThinMergeStatementSelfTest.assertEquals((int)22, (int)rs.getInt("age"));
                        continue block15;
                    }
                }
                assert (false) : "Invalid ID: " + id;
            }
        }
        if (this.stmt != null && !this.stmt.isClosed()) {
            this.stmt.close();
        }
        if (this.prepStmt != null && !this.prepStmt.isClosed()) {
            this.prepStmt.close();
        }
        JdbcThinMergeStatementSelfTest.assertTrue((boolean)this.prepStmt.isClosed());
        JdbcThinMergeStatementSelfTest.assertTrue((boolean)this.stmt.isClosed());
        super.afterTest();
    }

    @Test
    public void testExecuteUpdate() throws SQLException {
        JdbcThinMergeStatementSelfTest.assertEquals((int)3, (int)this.stmt.executeUpdate(SQL));
    }

    @Test
    public void testExecute() throws SQLException {
        JdbcThinMergeStatementSelfTest.assertFalse((boolean)this.stmt.execute(SQL));
    }
}

