/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.jdbc.thin.JdbcThinConnection;
import org.apache.ignite.internal.processors.odbc.ClientListenerProcessor;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.mxbean.ClientProcessorMXBean;
import org.apache.ignite.testframework.GridTestUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class JdbcThinConnectionMultipleAddressesTest
extends JdbcThinAbstractSelfTest {
    private static final int NODES_CNT = 3;
    private static final String URL_PORT_RANGE = "jdbc:ignite:thin://127.0.0.1:10800..10810";
    private static final String URL_SINGLE_PORT = "jdbc:ignite:thin://127.0.0.1:10800";
    private static final String STATEMENT_CLOSED_ON_DISCONNECT_MESSAGE = "Statement was closed due to a disconnection from the server";
    private static final String FAILED_CONNECT_TO_CLUSTER_MESSAGE = "Failed to communicate with Ignite cluster";
    private static final ArrayList<Integer> jdbcPorts = new ArrayList();

    private static String url() {
        StringBuilder sb = new StringBuilder("jdbc:ignite:thin://");
        for (int i = 0; i < 3; ++i) {
            sb.append("127.0.0.1:").append(jdbcPorts.get(i)).append(',');
        }
        return sb.toString();
    }

    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("default")});
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        cfg.setClientConnectorConfiguration(new ClientConnectorConfiguration().setPort(jdbcPorts.get(this.getTestIgniteInstanceIndex(name)).intValue()));
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String name) throws Exception {
        CacheConfiguration cfg = JdbcThinConnectionMultipleAddressesTest.defaultCacheConfiguration();
        cfg.setName(name);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        jdbcPorts.clear();
        for (int i = 0; i < 3; ++i) {
            jdbcPorts.add(10800 + i);
        }
        this.startGrids(3);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testMultipleAddressesConnect() throws Exception {
        try (Connection conn = DriverManager.getConnection(JdbcThinConnectionMultipleAddressesTest.url());
             Statement stmt = conn.createStatement();){
            stmt.execute("SELECT 1");
            ResultSet rs = stmt.getResultSet();
            JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)rs.next());
            JdbcThinConnectionMultipleAddressesTest.assertEquals((int)1, (int)rs.getInt(1));
        }
    }

    @Test
    public void testPortRangeConnect() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL_PORT_RANGE);
             Statement stmt = conn.createStatement();){
            stmt.execute("SELECT 1");
            ResultSet rs = stmt.getResultSet();
            JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)rs.next());
            JdbcThinConnectionMultipleAddressesTest.assertEquals((int)1, (int)rs.getInt(1));
        }
    }

    @Test
    public void testMultipleAddressesOneNodeFailoverOnStatementExecute() throws Exception {
        this.checkReconnectOnStatementExecute(JdbcThinConnectionMultipleAddressesTest.url(), false);
    }

    @Test
    public void testMultipleAddressesAllNodesFailoverOnStatementExecute() throws Exception {
        this.checkReconnectOnStatementExecute(JdbcThinConnectionMultipleAddressesTest.url(), true);
    }

    @Test
    public void testPortRangeAllNodesFailoverOnStatementExecute() throws Exception {
        this.checkReconnectOnStatementExecute(URL_PORT_RANGE, true);
    }

    @Test
    public void testMultipleAddressesOneNodeFailoverOnResultSet() throws Exception {
        this.checkReconnectOnResultSet(JdbcThinConnectionMultipleAddressesTest.url(), false);
    }

    @Test
    public void testMultipleAddressesAllNodesFailoverOnResultSet() throws Exception {
        this.checkReconnectOnResultSet(JdbcThinConnectionMultipleAddressesTest.url(), true);
    }

    @Test
    public void testPortRangeAllNodesFailoverOnResultSet() throws Exception {
        this.checkReconnectOnResultSet(URL_PORT_RANGE, true);
    }

    @Test
    public void testMultipleAddressesOneNodeFailoverOnMeta() throws Exception {
        this.checkReconnectOnMeta(JdbcThinConnectionMultipleAddressesTest.url(), false);
    }

    @Test
    public void testMultipleAddressesAllNodesFailoverOnMeta() throws Exception {
        this.checkReconnectOnMeta(JdbcThinConnectionMultipleAddressesTest.url(), true);
    }

    @Test
    public void testPortRangeAllNodesFailoverOnMeta() throws Exception {
        this.checkReconnectOnMeta(URL_PORT_RANGE, true);
    }

    @Test
    public void testMultipleAddressesOneNodeFailoverOnStreaming() throws Exception {
        this.checkReconnectOnStreaming(JdbcThinConnectionMultipleAddressesTest.url(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientConnectionMXBean() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL_PORT_RANGE);){
            Statement stmt0 = conn.createStatement();
            stmt0.execute("SELECT 1");
            ResultSet rs0 = stmt0.getResultSet();
            ClientProcessorMXBean serverMxBean = null;
            for (int i = 0; i < 3 && (serverMxBean = this.clientProcessorBean(i)).getConnections().isEmpty(); ++i) {
            }
            JdbcThinConnectionMultipleAddressesTest.assertNotNull((String)"No ClientConnections MXBean found.", serverMxBean);
            serverMxBean.dropAllConnections();
            stmt0.execute("SELECT 1");
            JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)rs0.isClosed());
            serverMxBean.dropAllConnections();
            Statement stmt1 = conn.createStatement();
            JdbcThinConnectionMultipleAddressesTest.assertThrowsSql(() -> stmt1.execute("SELECT 1; SELECT 1"), FAILED_CONNECT_TO_CLUSTER_MESSAGE, "08006");
            JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)stmt1.isClosed());
            JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)this.getActiveClients().isEmpty());
            Statement stmt2 = conn.createStatement();
            stmt2.execute("SELECT 1");
            ResultSet rs1 = stmt2.getResultSet();
            List<String> activeClients = this.getActiveClients();
            JdbcThinConnectionMultipleAddressesTest.assertEquals((int)1, (int)activeClients.size());
            JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)rs1.next());
            JdbcThinConnectionMultipleAddressesTest.assertEquals((int)1, (int)rs1.getInt(1));
            rs1.close();
            stmt2.close();
        }
        boolean allClosed = GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return JdbcThinConnectionMultipleAddressesTest.this.getActiveClients().isEmpty();
            }
        }, (long)10000L);
        JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)allClosed);
    }

    @Test
    public void testConnectionFailure() {
        JdbcThinConnectionMultipleAddressesTest.assertThrowsSql(() -> DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:12345"), "Failed to connect to server", "08001");
        JdbcThinConnectionMultipleAddressesTest.assertThrowsSql(() -> DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:12345?PartitionAwareness=true"), "Failed to connect to server", "08001");
    }

    @Test
    public void testSingleAddressReconnectAfterRestart() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL_SINGLE_PORT);){
            Throwable throwable;
            ResultSet rs2;
            Statement stmt1 = JdbcThinConnectionMultipleAddressesTest.createTestTable(conn);
            try (Statement stmt = conn.createStatement();){
                this.stopGrid(0);
                this.startGrid(0);
                stmt.execute("SELECT 1");
                stmt.execute("SELECT 1");
            }
            stmt = conn.createStatement();
            var5_7 = null;
            try {
                rs2 = stmt.executeQuery("SELECT 1");
                throwable = null;
                try {
                    JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)rs2.next());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
                this.stopGrid(0);
                this.startGrid(0);
                stmt.execute("SELECT 1");
                stmt.execute("SELECT 1");
            }
            catch (Throwable rs2) {
                var5_7 = rs2;
                throw rs2;
            }
            finally {
                if (stmt != null) {
                    if (var5_7 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs2) {
                            var5_7.addSuppressed(rs2);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            stmt = conn.createStatement();
            stmt.execute("SELECT 1");
            this.stopGrid(0);
            this.startGrid(0);
            stmt.close();
            JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)stmt.isClosed());
            stmt = conn.createStatement();
            var5_7 = null;
            try {
                stmt.execute("SELECT 1");
                this.stopGrid(0);
                this.startGrid(0);
                stmt.execute("SELECT 1");
                stmt.execute("SELECT 1");
            }
            catch (Throwable rs2) {
                var5_7 = rs2;
                throw rs2;
            }
            finally {
                if (stmt != null) {
                    if (var5_7 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs2) {
                            var5_7.addSuppressed(rs2);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            this.stopGrid(0);
            this.startGrid(0);
            stmt = conn.createStatement();
            var5_7 = null;
            try {
                stmt.execute("SELECT 1");
                stmt.execute("SELECT 1; SELECT 1");
            }
            catch (Throwable rs2) {
                var5_7 = rs2;
                throw rs2;
            }
            finally {
                if (stmt != null) {
                    if (var5_7 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs2) {
                            var5_7.addSuppressed(rs2);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            this.stopGrid(0);
            this.startGrid(0);
            stmt = conn.createStatement();
            var5_7 = null;
            try {
                JdbcThinConnectionMultipleAddressesTest.assertThrowsSql(() -> stmt.executeUpdate("INSERT INTO TEST VALUES (1, 1)"), FAILED_CONNECT_TO_CLUSTER_MESSAGE, "08006");
                JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)stmt.isClosed());
                JdbcThinConnectionMultipleAddressesTest.assertThrowsSql(() -> stmt.execute("SELECT 1"), STATEMENT_CLOSED_ON_DISCONNECT_MESSAGE, null);
            }
            catch (Throwable rs2) {
                var5_7 = rs2;
                throw rs2;
            }
            finally {
                if (stmt != null) {
                    if (var5_7 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs2) {
                            var5_7.addSuppressed(rs2);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            stmt = conn.createStatement();
            var5_7 = null;
            try {
                JdbcThinConnectionMultipleAddressesTest.assertEquals((int)1, (int)stmt.executeUpdate("INSERT INTO TEST VALUES (1, 1)"));
                JdbcThinConnectionMultipleAddressesTest.assertFalse((boolean)stmt.isClosed());
            }
            catch (Throwable rs2) {
                var5_7 = rs2;
                throw rs2;
            }
            finally {
                if (stmt != null) {
                    if (var5_7 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs2) {
                            var5_7.addSuppressed(rs2);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            this.stopGrid(0);
            this.startGrid(0);
            stmt = conn.prepareStatement("INSERT INTO TEST VALUES (?, ?)");
            var5_7 = null;
            try {
                stmt.setInt(1, 2);
                stmt.setInt(2, 2);
                JdbcThinConnectionMultipleAddressesTest.assertThrowsSql(((PreparedStatement)stmt)::executeUpdate, FAILED_CONNECT_TO_CLUSTER_MESSAGE, "08006");
                JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)stmt.isClosed());
            }
            catch (Throwable rs2) {
                var5_7 = rs2;
                throw rs2;
            }
            finally {
                if (stmt != null) {
                    if (var5_7 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs2) {
                            var5_7.addSuppressed(rs2);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            stmt = conn.prepareStatement("INSERT INTO TEST VALUES (?, ?)");
            var5_7 = null;
            try {
                stmt.setInt(1, 2);
                stmt.setInt(2, 2);
                JdbcThinConnectionMultipleAddressesTest.assertEquals((int)1, (int)stmt.executeUpdate());
                JdbcThinConnectionMultipleAddressesTest.assertFalse((boolean)stmt.isClosed());
            }
            catch (Throwable rs2) {
                var5_7 = rs2;
                throw rs2;
            }
            finally {
                if (stmt != null) {
                    if (var5_7 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs2) {
                            var5_7.addSuppressed(rs2);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            this.stopGrid(0);
            this.startGrid(0);
            stmt = conn.prepareStatement("INSERT INTO TEST VALUES (?, ?)");
            var5_7 = null;
            try {
                stmt.setInt(1, 3);
                stmt.setInt(2, 3);
                stmt.addBatch();
                stmt.setInt(1, 4);
                stmt.setInt(2, 4);
                stmt.addBatch();
                JdbcThinConnectionMultipleAddressesTest.assertThrowsSql(((PreparedStatement)stmt)::executeBatch, FAILED_CONNECT_TO_CLUSTER_MESSAGE, "08006");
                JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)stmt.isClosed());
            }
            catch (Throwable rs2) {
                var5_7 = rs2;
                throw rs2;
            }
            finally {
                if (stmt != null) {
                    if (var5_7 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs2) {
                            var5_7.addSuppressed(rs2);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            stmt = conn.prepareStatement("INSERT INTO TEST VALUES (?, ?)");
            var5_7 = null;
            try {
                stmt.setInt(1, 3);
                stmt.setInt(2, 3);
                stmt.addBatch();
                stmt.setInt(1, 4);
                stmt.setInt(2, 4);
                stmt.addBatch();
                Assert.assertArrayEquals((int[])new int[]{1, 1}, (int[])stmt.executeBatch());
                JdbcThinConnectionMultipleAddressesTest.assertFalse((boolean)stmt.isClosed());
            }
            catch (Throwable rs2) {
                var5_7 = rs2;
                throw rs2;
            }
            finally {
                if (stmt != null) {
                    if (var5_7 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs2) {
                            var5_7.addSuppressed(rs2);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            stmt = conn.createStatement();
            var5_7 = null;
            try {
                rs2 = stmt.executeQuery("SELECT COUNT(1) FROM TEST");
                throwable = null;
                try {
                    JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)rs2.next());
                    JdbcThinConnectionMultipleAddressesTest.assertEquals((long)4L, (long)rs2.getLong(1));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                var5_7 = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt != null) {
                    if (var5_7 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable7) {
                            var5_7.addSuppressed(throwable7);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)stmt1.isClosed());
        }
    }

    @Test
    public void testSingleAddressReconnectDuringRestart() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL_SINGLE_PORT);){
            this.stopGrid(0);
            try (Statement stmt = conn.createStatement();){
                JdbcThinConnectionMultipleAddressesTest.assertThrowsSql(() -> stmt.execute("SELECT 1"), "Failed to connect to server", "08006");
                JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)stmt.isClosed());
            }
            this.startGrid(0);
            stmt = conn.createStatement();
            var4_6 = null;
            try {
                stmt.execute("SELECT 1");
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (var4_6 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
    }

    @Test
    public void testReconnectWithTxContextIsNotAllowed() throws Exception {
        try (Connection conn = DriverManager.getConnection(URL_SINGLE_PORT);){
            conn.setAutoCommit(false);
            Statement stmt1 = JdbcThinConnectionMultipleAddressesTest.createTestTable(conn);
            stmt1.execute("CREATE TABLE TEST_MVCC (ID INT, NAME VARCHAR, PRIMARY KEY(ID)) WITH \"cache_name=TEST_MVCC,template=replicated,atomicity=transactional_snapshot\"");
            stmt1.executeUpdate("INSERT INTO TEST VALUES (1, 1)");
            this.stopGrid(0);
            this.startGrid(0);
            stmt1.execute("SELECT * FROM TEST");
            stmt1.execute("SELECT * FROM TEST_MVCC");
            this.stopGrid(0);
            this.startGrid(0);
            try (Statement stmt = conn.createStatement();){
                JdbcThinConnectionMultipleAddressesTest.assertThrowsSql(() -> stmt.execute("SELECT 1"), FAILED_CONNECT_TO_CLUSTER_MESSAGE, "08006");
                JdbcThinConnectionMultipleAddressesTest.assertThrowsSql(() -> stmt.execute("SELECT 1"), STATEMENT_CLOSED_ON_DISCONNECT_MESSAGE, null);
            }
            JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)stmt1.isClosed());
            JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)conn.isClosed());
            JdbcThinConnectionMultipleAddressesTest.assertThrowsSql(conn::createStatement, "Connection is closed", "08003");
        }
    }

    @NotNull
    private List<String> getActiveClients() {
        ArrayList<String> activeClients = new ArrayList<String>(1);
        for (int i = 0; i < 3; ++i) {
            ClientProcessorMXBean mxBean = this.clientProcessorBean(i);
            JdbcThinConnectionMultipleAddressesTest.assertNotNull((Object)mxBean);
            activeClients.addAll(mxBean.getConnections());
        }
        return activeClients;
    }

    private ClientProcessorMXBean clientProcessorBean(int igniteInt) {
        ObjectName mbeanName = null;
        try {
            mbeanName = U.makeMBeanName((String)this.getTestIgniteInstanceName(igniteInt), (String)"Clients", (String)ClientListenerProcessor.class.getSimpleName());
        }
        catch (MalformedObjectNameException e) {
            JdbcThinConnectionMultipleAddressesTest.fail((String)"Failed to register MBean.");
        }
        MBeanServer mbeanSrv = ManagementFactory.getPlatformMBeanServer();
        if (!mbeanSrv.isRegistered(mbeanName)) {
            JdbcThinConnectionMultipleAddressesTest.fail((String)("MBean is not registered: " + mbeanName.getCanonicalName()));
        }
        return MBeanServerInvocationHandler.newProxyInstance(mbeanSrv, mbeanName, ClientProcessorMXBean.class, true);
    }

    private void checkReconnectOnMeta(String url, boolean allNodes) throws Exception {
        try (Connection conn = DriverManager.getConnection(url);){
            DatabaseMetaData meta = conn.getMetaData();
            String[] types = new String[]{"TABLES"};
            ResultSet rs0 = meta.getTables(null, null, null, types);
            JdbcThinConnectionMultipleAddressesTest.assertFalse((boolean)rs0.next());
            this.stop(conn, allNodes);
            if (allNodes) {
                JdbcThinConnectionMultipleAddressesTest.assertThrowsSql(() -> meta.getTables(null, null, null, null), "Failed to connect to server", "08006");
                JdbcThinConnectionMultipleAddressesTest.assertThrowsSql(() -> meta.getTables(null, null, null, null), "Failed to connect to server", "08006");
            } else {
                rs0 = meta.getTables(null, null, null, types);
                JdbcThinConnectionMultipleAddressesTest.assertFalse((boolean)rs0.next());
            }
            this.restart(allNodes);
            rs0 = meta.getTables(null, null, null, types);
            JdbcThinConnectionMultipleAddressesTest.assertFalse((boolean)rs0.next());
        }
    }

    private void checkReconnectOnStatementExecute(String url, boolean allNodes) throws Exception {
        try (Connection conn = DriverManager.getConnection(url);){
            Statement stmt0 = conn.createStatement();
            stmt0.execute("SELECT 1");
            ResultSet rs0 = stmt0.getResultSet();
            JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)rs0.next());
            JdbcThinConnectionMultipleAddressesTest.assertEquals((int)1, (int)rs0.getInt(1));
            JdbcThinConnectionMultipleAddressesTest.assertFalse((boolean)rs0.isClosed());
            this.stop(conn, allNodes);
            this.restart(allNodes);
            stmt0.execute("SELECT 1");
            ResultSet rs1 = stmt0.getResultSet();
            JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)rs1.next());
            JdbcThinConnectionMultipleAddressesTest.assertEquals((int)1, (int)rs1.getInt(1));
        }
    }

    private void checkReconnectOnResultSet(String url, boolean allNodes) throws Exception {
        try (Connection conn = DriverManager.getConnection(url);){
            Statement stmt0 = conn.createStatement();
            stmt0.execute("SELECT 1");
            ResultSet rs0 = stmt0.getResultSet();
            JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)rs0.next());
            JdbcThinConnectionMultipleAddressesTest.assertEquals((int)1, (int)rs0.getInt(1));
            JdbcThinConnectionMultipleAddressesTest.assertFalse((boolean)rs0.isClosed());
            this.stop(conn, allNodes);
            rs0.close();
            this.restart(allNodes);
            Statement stmt1 = conn.createStatement();
            stmt1.execute("SELECT 1");
            ResultSet rs1 = stmt1.getResultSet();
            JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)rs1.next());
            JdbcThinConnectionMultipleAddressesTest.assertEquals((int)1, (int)rs1.getInt(1));
        }
    }

    private void checkReconnectOnStreaming(String url, boolean allNodes) throws Exception {
        try (Connection conn = DriverManager.getConnection(url);){
            final Statement stmt0 = conn.createStatement();
            stmt0.execute("CREATE TABLE TEST(id int primary key, val int)");
            stmt0.execute("SET STREAMING 1 BATCH_SIZE 10 ALLOW_OVERWRITE 0  PER_NODE_BUFFER_SIZE 1000 FLUSH_FREQUENCY 1000");
            ResultSet rs0 = stmt0.getResultSet();
            this.stop(conn, allNodes);
            final int[] id = new int[]{0};
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    while (id[0] >= 0) {
                        stmt0.execute("INSERT INTO TEST(id, val) values (" + id[0] + ", " + id[0] + ")");
                        id[0] = id[0] + 1;
                    }
                    return null;
                }
            }, SQLException.class, (String)"Failed to communicate with Ignite cluster on JDBC streaming");
            int minId = id[0];
            this.restart(allNodes);
            Statement stmt1 = conn.createStatement();
            stmt1.execute("SET STREAMING 1 BATCH_SIZE 10 ALLOW_OVERWRITE 0  PER_NODE_BUFFER_SIZE 1000 FLUSH_FREQUENCY 1000");
            for (int i = 0; i < 10; ++i) {
                stmt1.execute("INSERT INTO TEST(id, val) values (" + id[0] + ", " + id[0] + ")");
                id[0] = id[0] + 1;
            }
            stmt1.execute("SET STREAMING 0");
            stmt1.execute("SELECT ID FROM TEST WHERE id < " + minId);
            JdbcThinConnectionMultipleAddressesTest.assertFalse((boolean)stmt1.getResultSet().next());
            stmt1.execute("SELECT count(id) FROM TEST WHERE id > " + minId);
            JdbcThinConnectionMultipleAddressesTest.assertTrue((boolean)stmt1.getResultSet().next());
        }
    }

    private void stop(Connection conn, boolean all) {
        if (all) {
            this.stopAllGrids();
        } else if (partitionAwareness) {
            for (int i = 0; i < 2; ++i) {
                this.stopGrid(i);
            }
        } else {
            int idx = ((JdbcThinConnection)conn).serverIndex();
            this.stopGrid(idx);
        }
    }

    private void restart(boolean all) throws Exception {
        if (all) {
            this.startGrids(3);
        }
    }

    private static void assertThrowsSql(GridTestUtils.RunnableX run, String message, String sqlState) {
        SQLException ex = (SQLException)GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            run.runx();
            return null;
        }, SQLException.class, (String)message);
        JdbcThinConnectionMultipleAddressesTest.assertEquals((String)String.valueOf(ex), (String)sqlState, (String)ex.getSQLState());
    }

    private static Statement createTestTable(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE TEST (ID INT, NAME VARCHAR, PRIMARY KEY(ID)) WITH \"cache_name=TEST,template=replicated\"");
        return stmt;
    }
}

