/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.query.NestedTxMode;
import org.apache.ignite.internal.processors.query.QueryHistory;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.testframework.GridStringLogger;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class JdbcThinAffinityAwarenessTransactionsSelfTest
extends JdbcThinAbstractSelfTest {
    private static final String URL = "jdbc:ignite:thin://127.0.0.1:10800..10802?affinityAwareness=true";
    private static final int NODES_CNT = 3;
    private static final int QUERY_EXECUTION_MULTIPLIER = 5;
    private Connection conn;
    private Statement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        log = new GridStringLogger();
        return super.getConfiguration(igniteInstanceName).setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("default").setNearConfiguration(null)}).setMarshaller((Marshaller)new BinaryMarshaller()).setGridLogger(log);
    }

    private CacheConfiguration cacheConfiguration(@NotNull String name) {
        return JdbcThinAffinityAwarenessTransactionsSelfTest.defaultCacheConfiguration().setName(name).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT);
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
        try (Connection c = JdbcThinAffinityAwarenessTransactionsSelfTest.prepareConnection(true, NestedTxMode.ERROR);
             Statement stmt = c.createStatement();){
            stmt.execute("CREATE TABLE Person (id int primary key, firstName varchar, lastName varchar, age int) WITH \"cache_name=persons,wrap_value=true,atomicity=transactional_snapshot\"");
            stmt.executeUpdate("insert into Person (id, firstName, lastName, age) values (1, 'John1', 'Dow1', 1);insert into Person (id, firstName, lastName, age) values (2, 'John2', 'Dow2', 2);insert into Person (id, firstName, lastName, age) values (3, 'John3', 'Dow3', 3);");
        }
    }

    protected void beforeTest() throws Exception {
        this.conn = DriverManager.getConnection(URL);
        this.stmt = this.conn.createStatement();
        assert (this.stmt != null);
        assert (!this.stmt.isClosed());
    }

    protected void afterTest() throws Exception {
        U.closeQuiet((AutoCloseable)this.stmt);
        this.conn.close();
        assert (this.stmt.isClosed());
        assert (this.conn.isClosed());
    }

    private static Connection prepareConnection(boolean autoCommit, NestedTxMode nestedTxMode) throws SQLException {
        Connection res = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800..10802?affinityAwareness=true&nestedTransactionsMode=" + nestedTxMode.name());
        res.setAutoCommit(autoCommit);
        return res;
    }

    @Test
    public void testExecuteQueries() throws Exception {
        this.stmt.execute("BEGIN");
        this.checkNodesUsage("select * from Person where _key = 1", 1, false);
        this.stmt.execute("COMMIT");
        this.stmt.execute("BEGIN");
        this.checkNodesUsage("select * from Person where _key = 1 or _key = 2", 2, false);
        this.stmt.execute("COMMIT");
        this.stmt.execute("BEGIN");
        this.checkNodesUsage("select * from Person where _key in (1, 2)", 2, false);
        this.stmt.execute("COMMIT");
    }

    @Test
    public void testUpdateQueries() throws Exception {
        this.stmt.execute("BEGIN");
        this.checkNodesUsage("update Person set firstName = 'TestFirstName' where _key = 1", 1, true);
        this.stmt.execute("COMMIT");
        this.stmt.execute("BEGIN");
        this.checkNodesUsage("update Person set firstName = 'TestFirstName' where _key = 1 or _key = 2", 2, true);
        this.stmt.execute("COMMIT");
        this.stmt.execute("BEGIN");
        this.checkNodesUsage("update Person set firstName = 'TestFirstName' where _key in (1, 2)", 2, true);
        this.stmt.execute("COMMIT");
    }

    @Test
    public void testDeleteQueries() throws Exception {
        this.stmt.execute("BEGIN");
        this.checkNodesUsage("delete from Person where _key = 1000 or _key = 2000", 0, true);
        this.stmt.execute("COMMIT");
        this.stmt.execute("BEGIN");
        this.checkNodesUsage("delete from Person where _key in (1000, 2000)", 0, true);
        this.stmt.execute("COMMIT");
    }

    private void checkNodesUsage(String sql, int expRowsCnt, boolean dml) throws Exception {
        int i;
        if (dml) {
            this.stmt.executeUpdate(sql);
        } else {
            this.stmt.executeQuery(sql);
        }
        for (i = 0; i < 3; ++i) {
            ((IgniteH2Indexing)this.grid(i).context().query().getIndexing()).runningQueryManager().resetQueryHistoryMetrics();
        }
        for (i = 0; i < 15; ++i) {
            ResultSet rs = null;
            int updatedRowsCnt = 0;
            if (dml) {
                updatedRowsCnt = this.stmt.executeUpdate(sql);
            } else {
                rs = this.stmt.executeQuery(sql);
            }
            if (dml) {
                JdbcThinAffinityAwarenessTransactionsSelfTest.assertEquals((String)("Unexpected updated rows count: expected [" + expRowsCnt + "], got [" + updatedRowsCnt + "]"), (int)expRowsCnt, (int)updatedRowsCnt);
                continue;
            }
            assert (rs != null);
            int gotRowsCnt = 0;
            while (rs.next()) {
                ++gotRowsCnt;
            }
            JdbcThinAffinityAwarenessTransactionsSelfTest.assertEquals((String)("Unexpected rows count: expected [" + expRowsCnt + "], got [" + gotRowsCnt + "]"), (int)expRowsCnt, (int)gotRowsCnt);
        }
        int nonEmptyMetricsCntr = 0;
        int qryExecutionsCntr = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            Collection metrics = ((IgniteH2Indexing)this.grid(i2).context().query().getIndexing()).runningQueryManager().queryHistoryMetrics().values();
            if (metrics.isEmpty()) continue;
            ++nonEmptyMetricsCntr;
            qryExecutionsCntr = (int)((long)qryExecutionsCntr + ((QueryHistory)new ArrayList(metrics).get(0)).executions());
        }
        JdbcThinAffinityAwarenessTransactionsSelfTest.assertTrue((String)("Unexpected amount of used nodes: expected [0 < nodesCnt <= 1], got [" + nonEmptyMetricsCntr + "]"), (nonEmptyMetricsCntr == 1 ? 1 : 0) != 0);
        JdbcThinAffinityAwarenessTransactionsSelfTest.assertEquals((String)("Executions count doesn't match expeted value: expected [15], got [" + qryExecutionsCntr + "]"), (int)15, (int)qryExecutionsCntr);
    }
}

