/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcLocalCachesSelfTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache";
    private static final String URL = "jdbc:ignite://127.0.0.1/cache";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcLocalCachesSelfTest.defaultCacheConfiguration();
        cache.setName(CACHE_NAME);
        cache.setCacheMode(CacheMode.LOCAL);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{String.class, Integer.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(2);
        IgniteCache cache1 = this.grid(0).cache(CACHE_NAME);
        assert (cache1 != null);
        cache1.put((Object)"key1", (Object)1);
        cache1.put((Object)"key2", (Object)2);
        IgniteCache cache2 = this.grid(1).cache(CACHE_NAME);
        assert (cache2 != null);
        cache2.put((Object)"key1", (Object)3);
        cache2.put((Object)"key2", (Object)4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCache1() throws Exception {
        Properties cfg = new Properties();
        cfg.setProperty("ignite.jdbc.nodeId", this.grid(0).localNode().id().toString());
        try (Connection conn = null;){
            conn = DriverManager.getConnection(URL, cfg);
            ResultSet rs = conn.createStatement().executeQuery("select _val from Integer order by _val");
            int cnt = 0;
            while (rs.next()) {
                JdbcLocalCachesSelfTest.assertEquals((int)(++cnt), (int)rs.getInt(1));
            }
            JdbcLocalCachesSelfTest.assertEquals((int)2, (int)cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCache2() throws Exception {
        Properties cfg = new Properties();
        cfg.setProperty("ignite.jdbc.nodeId", this.grid(1).localNode().id().toString());
        try (Connection conn = null;){
            conn = DriverManager.getConnection(URL, cfg);
            ResultSet rs = conn.createStatement().executeQuery("select _val from Integer order by _val");
            int cnt = 0;
            while (rs.next()) {
                JdbcLocalCachesSelfTest.assertEquals((int)(++cnt + 2), (int)rs.getInt(1));
            }
            JdbcLocalCachesSelfTest.assertEquals((int)2, (int)cnt);
        }
    }
}

